/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.Description;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.BatchExecution;
import org.scassandra.http.client.BatchQuery;
import org.scassandra.matchers.ScassandraMatcher;

public class BatchExecutionMatcher
extends ScassandraMatcher<List<BatchExecution>, BatchExecution> {
    private final BatchExecution expectedBatchExecution;

    BatchExecutionMatcher(BatchExecution expectedBatchExecution) {
        if (expectedBatchExecution == null) {
            throw new IllegalArgumentException("null expectedBatchExecution");
        }
        this.expectedBatchExecution = expectedBatchExecution;
    }

    public void describeMismatchSafely(List<BatchExecution> batchExecutions, Description description) {
        description.appendText("the following batches were executed: ");
        for (BatchExecution batchExecution : batchExecutions) {
            description.appendText("\n" + batchExecution);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected batch " + this.expectedBatchExecution + " to be executed");
    }

    @Override
    protected boolean match(BatchExecution actualBatchExecution) {
        if (!actualBatchExecution.getConsistency().equals(this.expectedBatchExecution.getConsistency())) {
            return false;
        }
        if (!actualBatchExecution.getBatchType().equals((Object)this.expectedBatchExecution.getBatchType())) {
            return false;
        }
        List<BatchQuery> expectedBatchQueries = this.expectedBatchExecution.getBatchQueries();
        List<BatchQuery> actualBatchQueries = actualBatchExecution.getBatchQueries();
        for (int i = 0; i < this.expectedBatchExecution.getBatchQueries().size(); ++i) {
            List<Object> actualVariables;
            List<CqlType> actualVariableTypes;
            BatchQuery expectedBatchQuery = expectedBatchQueries.get(0);
            BatchQuery actualBatchQuery = actualBatchQueries.get(0);
            if (!expectedBatchQuery.getQuery().equals(actualBatchQuery.getQuery())) {
                return false;
            }
            if (!expectedBatchQuery.getBatchQueryKind().equals((Object)actualBatchQuery.getBatchQueryKind())) {
                return false;
            }
            List<Object> expectedVariables = expectedBatchQuery.getVariables();
            if (this.checkVariables(expectedVariables, actualVariableTypes = actualBatchQuery.getVariableTypes(), actualVariables = actualBatchQuery.getVariables())) continue;
            return false;
        }
        return true;
    }
}

