/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.server.cqlmessages;

import akka.util.ByteIterator;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CqlProtocolHelper$ {
    public static final CqlProtocolHelper$ MODULE$;
    private final ByteOrder byteOrder;
    private final byte[] NullValue;

    static {
        new CqlProtocolHelper$();
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public byte[] NullValue() {
        return this.NullValue;
    }

    public byte[] serializeString(String string) {
        ByteStringBuilder bs = ByteString$.MODULE$.newBuilder();
        bs.putShort(string.length(), this.byteOrder());
        bs.putBytes(string.getBytes());
        return (byte[])bs.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public byte[] serializeLongString(String string) {
        ByteStringBuilder bs = ByteString$.MODULE$.newBuilder();
        bs.putInt(string.length(), this.byteOrder());
        bs.putBytes(string.getBytes("UTF-8"));
        return (byte[])bs.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public byte[] serializeByte(byte by) {
        return new byte[]{by};
    }

    public byte[] serializeInt(int n) {
        ByteStringBuilder frameBuilder = ByteString$.MODULE$.newBuilder();
        frameBuilder.putInt(n, this.byteOrder());
        return (byte[])frameBuilder.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public byte[] serializeShort(short s) {
        ByteStringBuilder frameBuilder = ByteString$.MODULE$.newBuilder();
        frameBuilder.putShort((int)s, this.byteOrder());
        return (byte[])frameBuilder.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public byte[] serializeShortBytes(byte[] bytes) {
        ByteStringBuilder frameBuilder = ByteString$.MODULE$.newBuilder();
        frameBuilder.putShort(bytes.length, this.byteOrder());
        frameBuilder.putBytes(bytes);
        return (byte[])frameBuilder.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public <U> byte[] serializeCollection(Function2<ByteStringBuilder, Object, ByteStringBuilder> sizeF, TraversableOnce<U> input, Function1<U, byte[]> entrySerializer) {
        ByteStringBuilder frameBuilder = ByteString$.MODULE$.newBuilder();
        sizeF.apply((Object)frameBuilder, (Object)BoxesRunTime.boxToInteger((int)input.size()));
        input.foreach((Function1)new Serializable(entrySerializer, frameBuilder){
            public static final long serialVersionUID = 0L;
            private final Function1 entrySerializer$1;
            private final ByteStringBuilder frameBuilder$1;

            public final ByteStringBuilder apply(U value) {
                return this.frameBuilder$1.putBytes((byte[])this.entrySerializer$1.apply(value));
            }
            {
                this.entrySerializer$1 = entrySerializer$1;
                this.frameBuilder$1 = frameBuilder$1;
            }
        });
        return (byte[])frameBuilder.result().toArray(ClassTag$.MODULE$.Byte());
    }

    public <String> byte[] serializeStringCollection(TraversableOnce<String> input, Function1<String, byte[]> entrySerializer) {
        return this.serializeCollection((Function2<ByteStringBuilder, Object, ByteStringBuilder>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteStringBuilder apply(ByteStringBuilder x$1, int x$2) {
                return x$1.putShort(x$2, CqlProtocolHelper$.MODULE$.byteOrder());
            }
        }, input, entrySerializer);
    }

    public byte[] serializeStringList(List<String> input) {
        return this.serializeStringCollection((TraversableOnce)input, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String string) {
                return CqlProtocolHelper$.MODULE$.serializeString(string);
            }
        });
    }

    public byte[] serializeStringMap(Map<String, String> input) {
        return this.serializeStringCollection((TraversableOnce)input, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Tuple2<String, String> e) {
                return (byte[])Predef$.MODULE$.byteArrayOps(CqlProtocolHelper$.MODULE$.serializeString((String)e._1())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(CqlProtocolHelper$.MODULE$.serializeString((String)e._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            }
        });
    }

    public byte[] serializeStringMultiMap(Map<String, Set<String>> input) {
        return this.serializeStringCollection((TraversableOnce)input, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Tuple2<String, Set<String>> e) {
                return (byte[])Predef$.MODULE$.byteArrayOps(CqlProtocolHelper$.MODULE$.serializeString((String)e._1())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(CqlProtocolHelper$.MODULE$.serializeStringList((List<String>)((TraversableOnce)e._2()).toList())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            }
        });
    }

    public String readString(ByteIterator iterator) {
        short stringLength = iterator.getShort(this.byteOrder());
        byte[] stringBytes = new byte[stringLength];
        iterator.getBytes(stringBytes);
        return new String(stringBytes);
    }

    public Option<String> readLongString(ByteIterator iterator) {
        int stringLength = iterator.getInt(this.byteOrder());
        if (stringLength == -1) {
            return None$.MODULE$;
        }
        byte[] stringBytes = new byte[stringLength];
        iterator.getBytes(stringBytes);
        return new Some((Object)new String(stringBytes));
    }

    public Option<Object> readIntValue(ByteIterator iterator) {
        int intLength = iterator.getInt(this.byteOrder());
        if (intLength == -1) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)iterator.getInt(this.byteOrder())));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readShortBytes(ByteIterator iterator) {
        void var3_3;
        short length = iterator.getShort(this.byteOrder());
        byte[] bytes = new byte[length];
        iterator.getBytes(bytes);
        return var3_3;
    }

    public byte[] readLongBytes(ByteIterator iterator) {
        byte[] byArray;
        int length;
        int n = length = iterator.getInt(this.byteOrder());
        switch (n) {
            default: {
                byte[] bytes = new byte[length];
                iterator.getBytes(bytes);
                byArray = bytes;
                break;
            }
            case -1: {
                byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
            }
        }
        return byArray;
    }

    public boolean readNullValue(ByteIterator iterator) {
        byte[] bytes = new byte[4];
        iterator.getBytes(bytes);
        IndexedSeq indexedSeq = Predef$.MODULE$.byteArrayOps(bytes).deep();
        IndexedSeq indexedSeq2 = Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-1, -1, -1, -1}), ClassTag$.MODULE$.Byte())).deep();
        return !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
    }

    public ByteString combineHeaderAndLength(byte[] header, byte[] body) {
        return ByteString$.MODULE$.apply((byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(header).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(this.serializeInt(body.length)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(body), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
    }

    public int readPreparedStatementId(ByteIterator iterator) {
        iterator.drop(2);
        return iterator.getInt(this.byteOrder());
    }

    public byte[] hex2Bytes(String hex) {
        try {
            return (byte[])((TraversableOnce)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), hex.length() - 1).by(2).withFilter((Function1)new Serializable(hex){
                public static final long serialVersionUID = 0L;
                private final String hex$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                public boolean apply$mcZI$sp(int i) {
                    return i > 0 || !this.hex$1.startsWith("0x");
                }
                {
                    this.hex$1 = hex$1;
                }
            }).map((Function1)new Serializable(hex){
                public static final long serialVersionUID = 0L;
                private final String hex$1;

                public final String apply(int i) {
                    return this.hex$1.substring(i, i + 2);
                }
                {
                    this.hex$1 = hex$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte apply(String hexValue) {
                    return (byte)Integer.parseInt(hexValue, 16);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not valid hex ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hex})));
        }
    }

    public String bytes2Hex(byte[] bytes) {
        return new StringBuilder().append((Object)"0x").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(bytes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte x$3) {
                return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$3)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString()).toString();
    }

    private CqlProtocolHelper$() {
        MODULE$ = this;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.NullValue = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-1, -1, -1, -1}), ClassTag$.MODULE$.Byte());
    }
}

