/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.server.cqlmessages.response;

import akka.util.ByteIterator;
import akka.util.ByteString;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.scassandra.server.cqlmessages.CqlProtocolHelper$;
import org.scassandra.server.cqlmessages.OpCodes$;
import org.scassandra.server.cqlmessages.ProtocolVersion;
import org.scassandra.server.cqlmessages.ProtocolVersion$;
import org.scassandra.server.cqlmessages.response.Ready;
import org.scassandra.server.cqlmessages.response.Response;
import org.scassandra.server.cqlmessages.response.Result$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class ResponseDeserializer$
implements LazyLogging {
    public static final ResponseDeserializer$ MODULE$;
    private final int HeaderLength;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ResponseDeserializer$();
    }

    private Logger logger$lzycompute() {
        ResponseDeserializer$ responseDeserializer$ = this;
        synchronized (responseDeserializer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public int HeaderLength() {
        return this.HeaderLength;
    }

    public Response deserialize(ByteString byteString) {
        byte by;
        block7: {
            Response response;
            block6: {
                block5: {
                    if (byteString.length() < this.HeaderLength()) {
                        throw new IllegalArgumentException();
                    }
                    ByteIterator iterator = byteString.iterator();
                    byte protocolVersionByte = iterator.getByte();
                    byte flags = iterator.getByte();
                    byte stream = iterator.getByte();
                    byte opCode = iterator.getByte();
                    int bodyLength = iterator.getInt(CqlProtocolHelper$.MODULE$.byteOrder());
                    ProtocolVersion protocolVersion = ProtocolVersion$.MODULE$.protocol(protocolVersionByte);
                    if (iterator.len() < bodyLength) {
                        throw new IllegalArgumentException();
                    }
                    by = opCode;
                    if (OpCodes$.MODULE$.Ready() != by) break block5;
                    response = new Ready(stream, protocolVersion);
                    break block6;
                }
                if (OpCodes$.MODULE$.Result() != by) break block7;
                response = Result$.MODULE$.fromByteString(byteString);
            }
            return response;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown opcode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)})));
    }

    public String readString(ByteIterator iterator, int length) {
        byte[] bytes = new byte[length];
        iterator.getBytes(bytes);
        return new String(bytes);
    }

    private ResponseDeserializer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.HeaderLength = 8;
    }
}

