/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.server.priming.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.scassandra.server.priming.PrimeAddResult;
import org.scassandra.server.priming.PrimeAddSuccess$;
import org.scassandra.server.priming.PrimeValidator;
import org.scassandra.server.priming.PrimeValidator$;
import org.scassandra.server.priming.query.Prime;
import org.scassandra.server.priming.query.PrimeCriteria;
import org.scassandra.server.priming.query.PrimeMatch;
import org.scassandra.server.priming.query.PrimeQueryStore$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u00015\u0011q\u0002\u0015:j[\u0016\fV/\u001a:z'R|'/\u001a\u0006\u0003\u0007\u0011\tQ!];fefT!!\u0002\u0004\u0002\u000fA\u0014\u0018.\\5oO*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011AC:dCN\u001c\u0018M\u001c3sC*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001d\u001b\u00051\"BA\f\u0019\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI\"$\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0012aA2p[&\u0011QD\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!9A\u0005\u0001b\u0001\n\u0003)\u0013!\u0003<bY&$\u0017\r^8s+\u00051\u0003CA\u0014)\u001b\u0005!\u0011BA\u0015\u0005\u00059\u0001&/[7f-\u0006d\u0017\u000eZ1u_JDaa\u000b\u0001!\u0002\u00131\u0013A\u0003<bY&$\u0017\r^8sA!9Q\u0006\u0001a\u0001\n\u0003q\u0013aC9vKJL\bK]5nKN,\u0012a\f\t\u0005aU:$(D\u00012\u0015\t\u00114'A\u0005j[6,H/\u00192mK*\u0011A\u0007E\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001c2\u0005\ri\u0015\r\u001d\t\u0003EaJ!!\u000f\u0002\u0003\u001bA\u0013\u0018.\\3De&$XM]5b!\t\u00113(\u0003\u0002=\u0005\t)\u0001K]5nK\"9a\b\u0001a\u0001\n\u0003y\u0014aD9vKJL\bK]5nKN|F%Z9\u0015\u0005\u0001\u001b\u0005CA\bB\u0013\t\u0011\u0005C\u0001\u0003V]&$\bb\u0002#>\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004B\u0002$\u0001A\u0003&q&\u0001\u0007rk\u0016\u0014\u0018\u0010\u0015:j[\u0016\u001c\b\u0005C\u0004I\u0001\u0001\u0007I\u0011\u0001\u0018\u0002%E,XM]=QCR$XM\u001d8Qe&lWm\u001d\u0005\b\u0015\u0002\u0001\r\u0011\"\u0001L\u0003Y\tX/\u001a:z!\u0006$H/\u001a:o!JLW.Z:`I\u0015\fHC\u0001!M\u0011\u001d!\u0015*!AA\u0002=BaA\u0014\u0001!B\u0013y\u0013aE9vKJL\b+\u0019;uKJt\u0007K]5nKN\u0004\u0003\"\u0002)\u0001\t\u0003q\u0013\u0001D4fi\u0006cG\u000e\u0015:j[\u0016\u001c\b\"\u0002*\u0001\t\u0003\u0019\u0016aA1eIR\u0019AkV-\u0011\u0005\u001d*\u0016B\u0001,\u0005\u00059\u0001&/[7f\u0003\u0012$'+Z:vYRDQ\u0001W)A\u0002]\n\u0001b\u0019:ji\u0016\u0014\u0018.\u0019\u0005\u00065F\u0003\rAO\u0001\u0006aJLW.\u001a\u0005\u00069\u0002!\t!X\u0001\u0004O\u0016$HC\u00010b!\ryqLO\u0005\u0003AB\u0011aa\u00149uS>t\u0007\"\u00022\\\u0001\u0004\u0019\u0017A\u00039sS6,W*\u0019;dQB\u0011!\u0005Z\u0005\u0003K\n\u0011!\u0002\u0015:j[\u0016l\u0015\r^2i\u0011\u00159\u0007\u0001\"\u0001i\u0003]9W\r\u001e)sS6,7I]5uKJL\u0017MQ=Rk\u0016\u0014\u0018\u0010\u0006\u0002jkB\u0019!N]\u001c\u000f\u0005-\u0004hB\u00017p\u001b\u0005i'B\u00018\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002r!\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005\u0011a\u0015n\u001d;\u000b\u0005E\u0004\u0002\"B\u0002g\u0001\u00041\bCA<{\u001d\ty\u00010\u0003\u0002z!\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tI\b\u0003C\u0003\u007f\u0001\u0011\u0005q0A\u0003dY\u0016\f'\u000fF\u0001A\u000f\u001d\t\u0019A\u0001E\u0001\u0003\u000b\tq\u0002\u0015:j[\u0016\fV/\u001a:z'R|'/\u001a\t\u0004E\u0005\u001daAB\u0001\u0003\u0011\u0003\tIaE\u0002\u0002\b9AqaHA\u0004\t\u0003\ti\u0001\u0006\u0002\u0002\u0006!9\u0011\u0011CA\u0004\t\u0003\u0001\u0013!B1qa2L\b")
public class PrimeQueryStore
implements LazyLogging {
    private final PrimeValidator validator;
    private Map<PrimeCriteria, Prime> queryPrimes;
    private Map<PrimeCriteria, Prime> queryPatternPrimes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static PrimeQueryStore apply() {
        return PrimeQueryStore$.MODULE$.apply();
    }

    private Logger logger$lzycompute() {
        PrimeQueryStore primeQueryStore = this;
        synchronized (primeQueryStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public PrimeValidator validator() {
        return this.validator;
    }

    public Map<PrimeCriteria, Prime> queryPrimes() {
        return this.queryPrimes;
    }

    public void queryPrimes_$eq(Map<PrimeCriteria, Prime> x$1) {
        this.queryPrimes = x$1;
    }

    public Map<PrimeCriteria, Prime> queryPatternPrimes() {
        return this.queryPatternPrimes;
    }

    public void queryPatternPrimes_$eq(Map<PrimeCriteria, Prime> x$1) {
        this.queryPatternPrimes = x$1;
    }

    public Map<PrimeCriteria, Prime> getAllPrimes() {
        return this.queryPrimes();
    }

    public PrimeAddResult add(PrimeCriteria criteria, Prime prime) {
        PrimeAddResult primeAddResult;
        block9: {
            PrimeAddResult primeAddResult2;
            block8: {
                PrimeAddResult primeAddResult3;
                block7: {
                    PrimeAddSuccess$ primeAddSuccess$;
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding prime with criteria ", " and prime result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{criteria, prime})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    primeAddResult = this.validator().validate(criteria, prime, this.queryPrimes());
                    if (!PrimeAddSuccess$.MODULE$.equals(primeAddResult)) break block7;
                    if (criteria.patternMatch()) {
                        this.queryPatternPrimes_$eq((Map<PrimeCriteria, Prime>)this.queryPatternPrimes().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)criteria), (Object)prime)));
                        primeAddSuccess$ = PrimeAddSuccess$.MODULE$;
                    } else {
                        this.queryPrimes_$eq((Map<PrimeCriteria, Prime>)this.queryPrimes().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)criteria), (Object)prime)));
                        primeAddSuccess$ = PrimeAddSuccess$.MODULE$;
                    }
                    primeAddResult2 = primeAddSuccess$;
                    break block8;
                }
                if (primeAddResult == null) break block9;
                primeAddResult2 = primeAddResult3 = primeAddResult;
            }
            return primeAddResult2;
        }
        throw new MatchError((Object)primeAddResult);
    }

    public Option<Prime> get(PrimeMatch primeMatch) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Current primes: ").append(this.queryPrimes()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query for |", "|"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{primeMatch})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.queryPrimes().find(this.findPrime$1(primeMatch)).orElse((Function0)new Serializable(this, primeMatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimeQueryStore $outer;
            private final PrimeMatch primeMatch$1;

            public final Option<Tuple2<PrimeCriteria, Prime>> apply() {
                return this.$outer.queryPatternPrimes().find(this.$outer.org$scassandra$server$priming$query$PrimeQueryStore$$findPrimePattern$1(this.primeMatch$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.primeMatch$1 = primeMatch$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Prime apply(Tuple2<PrimeCriteria, Prime> x$1) {
                return (Prime)x$1._2();
            }
        });
    }

    public List<PrimeCriteria> getPrimeCriteriaByQuery(String query) {
        return ((TraversableOnce)this.queryPrimes().keys().filter((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final String query$1;

            public final boolean apply(PrimeCriteria primeCriteria) {
                String string = primeCriteria.query();
                String string2 = this.query$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.query$1 = query$1;
            }
        })).toList();
    }

    public void clear() {
        this.queryPrimes_$eq((Map<PrimeCriteria, Prime>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.queryPatternPrimes_$eq((Map<PrimeCriteria, Prime>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    private final Function1 findPrime$1(PrimeMatch primeMatch$1) {
        return new Serializable(this, primeMatch$1){
            public static final long serialVersionUID = 0L;
            private final PrimeMatch primeMatch$1;

            public final boolean apply(Tuple2<PrimeCriteria, Prime> entry) {
                String string = ((PrimeCriteria)entry._1()).query();
                String string2 = this.primeMatch$1.query();
                return !(string != null ? !string.equals(string2) : string2 != null) && ((PrimeCriteria)entry._1()).consistency().contains((Object)this.primeMatch$1.consistency());
            }
            {
                this.primeMatch$1 = primeMatch$1;
            }
        };
    }

    public final Function1 org$scassandra$server$priming$query$PrimeQueryStore$$findPrimePattern$1(PrimeMatch primeMatch$1) {
        return new Serializable(this, primeMatch$1){
            public static final long serialVersionUID = 0L;
            private final PrimeMatch primeMatch$1;

            public final boolean apply(Tuple2<PrimeCriteria, Prime> entry) {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            option = new StringOps(Predef$.MODULE$.augmentString(((PrimeCriteria)entry._1()).query())).r().findFirstIn((CharSequence)this.primeMatch$1.query());
                            if (!(option instanceof Some)) break block2;
                            bl = ((PrimeCriteria)entry._1()).consistency().contains((Object)this.primeMatch$1.consistency());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                this.primeMatch$1 = primeMatch$1;
            }
        };
    }

    public PrimeQueryStore() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.validator = PrimeValidator$.MODULE$.apply();
        this.queryPrimes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.queryPatternPrimes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

