/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.client.RepositoryClient;

public class Avro1124RESTRepositoryClient
implements RepositoryClient {
    private WebResource webResource;

    @Inject
    public Avro1124RESTRepositoryClient(@Named(value="schema-repo.url") String url) {
        this.webResource = Client.create().resource(url);
    }

    public Subject register(String subject, SubjectConfig config) {
        Form form = new Form();
        for (Map.Entry entry : RepositoryUtil.safeConfig((SubjectConfig)config).asMap().entrySet()) {
            form.putSingle((String)entry.getKey(), (String)entry.getValue());
        }
        String regSubjectName = (String)((WebResource.Builder)this.webResource.path(subject).accept(new String[]{"text/plain"}).type("application/x-www-form-urlencoded")).put(String.class, (Object)form);
        return new RESTSubject(regSubjectName);
    }

    public Subject lookup(String subject) {
        RepositoryUtil.validateSchemaOrSubject((String)subject);
        try {
            this.webResource.path(subject).get(String.class);
            return new RESTSubject(subject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Iterable<Subject> subjects() {
        ArrayList<Subject> subjectList = new ArrayList<Subject>();
        try {
            String subjects = (String)this.webResource.get(String.class);
            for (String subjName : RepositoryUtil.subjectNamesFromString((String)subjects)) {
                subjectList.add(new RESTSubject(subjName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subjectList;
    }

    public void close() {
    }

    private class RESTSubject
    extends Subject {
        private RESTSubject(String name) {
            super(name);
        }

        public SubjectConfig getConfig() {
            String path = this.getName() + "/config";
            try {
                String propString = (String)Avro1124RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).get(String.class);
                Properties props = new Properties();
                props.load(new StringReader(propString));
                return RepositoryUtil.configFromProperties((Properties)props);
            }
            catch (Exception e) {
                return null;
            }
        }

        public SchemaEntry register(String schema) throws SchemaValidationException {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String path = this.getName() + "/register";
            return this.handleRegisterRequest(path, schema);
        }

        public SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String idStr = latest == null ? "" : latest.getId();
            String path = this.getName() + "/register_if_latest/" + idStr;
            return this.handleRegisterRequest(path, schema);
        }

        private SchemaEntry handleRegisterRequest(String path, String schema) throws SchemaValidationException {
            try {
                String schemaId = (String)((WebResource.Builder)Avro1124RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).type(MediaType.TEXT_PLAIN_TYPE)).put(String.class, (Object)schema);
                return new SchemaEntry(schemaId, schema);
            }
            catch (UniformInterfaceException e) {
                ClientResponse cr = e.getResponse();
                if (ClientResponse.Status.fromStatusCode((int)cr.getStatus()).equals((Object)ClientResponse.Status.FORBIDDEN)) {
                    throw new SchemaValidationException("Invalid schema: " + schema);
                }
                return null;
            }
            catch (ClientHandlerException e) {
                return null;
            }
        }

        public SchemaEntry lookupBySchema(String schema) {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String path = this.getName() + "/schema";
            try {
                String schemaId = (String)((WebResource.Builder)Avro1124RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).type(MediaType.TEXT_PLAIN_TYPE)).post(String.class, (Object)schema);
                return new SchemaEntry(schemaId, schema);
            }
            catch (UniformInterfaceException e) {
                return null;
            }
        }

        public SchemaEntry lookupById(String schemaId) {
            RepositoryUtil.validateSchemaOrSubject((String)schemaId);
            String path = this.getName() + "/id/" + schemaId;
            try {
                String schema = (String)Avro1124RESTRepositoryClient.this.webResource.path(path).get(String.class);
                return new SchemaEntry(schemaId, schema);
            }
            catch (UniformInterfaceException e) {
                return null;
            }
        }

        public SchemaEntry latest() {
            String path = this.getName() + "/latest";
            try {
                String entryStr = (String)Avro1124RESTRepositoryClient.this.webResource.path(path).get(String.class);
                return new SchemaEntry(entryStr);
            }
            catch (UniformInterfaceException e) {
                return null;
            }
        }

        public Iterable<SchemaEntry> allEntries() {
            String path = this.getName() + "/all";
            try {
                String entriesStr = (String)Avro1124RESTRepositoryClient.this.webResource.path(path).get(String.class);
                return this.schemaEntriesFromStr(entriesStr);
            }
            catch (UniformInterfaceException e) {
                return Collections.emptyList();
            }
        }

        private Iterable<SchemaEntry> schemaEntriesFromStr(String entriesStr) {
            return RepositoryUtil.schemasFromString((String)entriesStr);
        }

        public boolean integralKeys() {
            try {
                String path = this.getName() + "/integral";
                String integral = (String)Avro1124RESTRepositoryClient.this.webResource.path(path).get(String.class);
                return Boolean.parseBoolean(integral);
            }
            catch (UniformInterfaceException e) {
                return false;
            }
        }
    }
}

