/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.client.RepositoryClient;
import org.schemarepo.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTRepositoryClient
implements RepositoryClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebResource webResource;
    private JsonUtil jsonUtil;
    private boolean returnNoneOnExceptions;

    @Inject
    public RESTRepositoryClient(@Named(value="schema-repo.rest-client.server-url") String url, @Named(value="schema-repo.json.util-implementation") JsonUtil jsonUtil, @Named(value="schema-repo.rest-client.return-none-on-exceptions") boolean returnNoneOnExceptions) {
        this.logger.info(String.format("Pointing to schema-repo server at %s", url));
        this.logger.info(String.format("Remote exceptions from GET requests will be %s", returnNoneOnExceptions ? "swallowed and an 'empty' value returned" : "propagated to the caller"));
        this.webResource = Client.create().resource(url);
        this.returnNoneOnExceptions = returnNoneOnExceptions;
        this.jsonUtil = jsonUtil;
    }

    public Subject register(String subject, SubjectConfig config) {
        Form form = new Form();
        for (Map.Entry entry : RepositoryUtil.safeConfig((SubjectConfig)config).asMap().entrySet()) {
            form.putSingle((String)entry.getKey(), (String)entry.getValue());
        }
        String regSubjectName = (String)((WebResource.Builder)this.webResource.path(subject).accept(new String[]{"text/plain"}).type("application/x-www-form-urlencoded")).put(String.class, (Object)form);
        return new RESTSubject(regSubjectName);
    }

    public Subject lookup(String subject) {
        RepositoryUtil.validateSchemaOrSubject((String)subject);
        RESTSubject s = null;
        try {
            this.webResource.path(subject).get(String.class);
            s = new RESTSubject(subject);
        }
        catch (RuntimeException e) {
            this.handleException(e, String.format("Failed to lookup subject %s", subject), true);
        }
        return s;
    }

    public Iterable<Subject> subjects() {
        ArrayList<Subject> subjectList = new ArrayList<Subject>();
        try {
            String subjects = (String)this.webResource.accept(new String[]{"application/json"}).get(String.class);
            for (String subjName : this.jsonUtil.subjectNamesFromJson(subjects)) {
                subjectList.add(new RESTSubject(subjName));
            }
        }
        catch (RuntimeException e) {
            this.handleException(e, "Failed to list all subjects", false);
        }
        return subjectList;
    }

    public void close() {
    }

    private void handleException(Exception ex, String msg, boolean resourceNotFoundExpected) {
        ClientResponse.Status status;
        ClientResponse.Status status2 = status = ex instanceof UniformInterfaceException ? ((UniformInterfaceException)((Object)ex)).getResponse().getClientResponseStatus() : null;
        if (status == ClientResponse.Status.NOT_FOUND && resourceNotFoundExpected || status == ClientResponse.Status.CONFLICT) {
            this.logger.debug(msg, (Throwable)ex);
        } else if (this.returnNoneOnExceptions) {
            if (status != null && status.getFamily() == Response.Status.Family.CLIENT_ERROR) {
                this.logger.info(msg, (Throwable)ex);
            } else {
                this.logger.error(msg, (Throwable)ex);
            }
        } else {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(msg, ex);
        }
    }

    private class RESTSubject
    extends Subject {
        private RESTSubject(String name) {
            super(name);
        }

        public SubjectConfig getConfig() {
            String path = this.getName() + "/config";
            SubjectConfig config = null;
            try {
                String propString = (String)RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).get(String.class);
                Properties props = new Properties();
                props.load(new StringReader(propString));
                config = RepositoryUtil.configFromProperties((Properties)props);
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to get config of subject %s", this.getName()), false);
            }
            catch (IOException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to parse config data of subject %s", this.getName()), false);
            }
            return config;
        }

        public SchemaEntry register(String schema) throws SchemaValidationException {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String path = this.getName() + "/register";
            return this.handleRegisterRequest(path, schema, false);
        }

        public SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String idStr = latest == null ? "" : latest.getId();
            String path = this.getName() + "/register_if_latest/" + idStr;
            return this.handleRegisterRequest(path, schema, true);
        }

        private SchemaEntry handleRegisterRequest(String path, String schema, boolean resourceNotFoundExpected) throws SchemaValidationException {
            SchemaEntry schemaEntry = null;
            try {
                String schemaId = (String)((WebResource.Builder)RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).type(MediaType.TEXT_PLAIN_TYPE)).put(String.class, (Object)schema);
                schemaEntry = new SchemaEntry(schemaId, schema);
            }
            catch (UniformInterfaceException e) {
                ClientResponse cr = e.getResponse();
                if (ClientResponse.Status.fromStatusCode((int)cr.getStatus()).equals((Object)ClientResponse.Status.FORBIDDEN)) {
                    throw new SchemaValidationException("Invalid schema: " + schema);
                }
                RESTRepositoryClient.this.handleException((Exception)((Object)e), String.format("Failed to register new schema for subject %s", this.getName()), resourceNotFoundExpected);
            }
            catch (ClientHandlerException e) {
                RESTRepositoryClient.this.handleException((Exception)((Object)e), String.format("Failed to register new schema for subject %s", this.getName()), resourceNotFoundExpected);
            }
            return schemaEntry;
        }

        public SchemaEntry lookupBySchema(String schema) {
            RepositoryUtil.validateSchemaOrSubject((String)schema);
            String path = this.getName() + "/schema";
            SchemaEntry schemaEntry = null;
            try {
                String schemaId = (String)((WebResource.Builder)RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"text/plain"}).type(MediaType.TEXT_PLAIN_TYPE)).post(String.class, (Object)schema);
                schemaEntry = new SchemaEntry(schemaId, schema);
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to locate schema %s in subject %s", schema, this.getName()), true);
            }
            return schemaEntry;
        }

        public SchemaEntry lookupById(String schemaId) {
            RepositoryUtil.validateSchemaOrSubject((String)schemaId);
            String path = this.getName() + "/id/" + schemaId;
            SchemaEntry schemaEntry = null;
            try {
                String schema = (String)RESTRepositoryClient.this.webResource.path(path).get(String.class);
                schemaEntry = new SchemaEntry(schemaId, schema);
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to locate schema with ID %s in subject %s", schemaId, this.getName()), true);
            }
            return schemaEntry;
        }

        public SchemaEntry latest() {
            String path = this.getName() + "/latest";
            SchemaEntry schemaEntry = null;
            try {
                String entryStr = (String)RESTRepositoryClient.this.webResource.path(path).get(String.class);
                schemaEntry = new SchemaEntry(entryStr);
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to locate latest schema in subject %s", this.getName()), true);
            }
            return schemaEntry;
        }

        public Iterable<SchemaEntry> allEntries() {
            String path = this.getName() + "/all";
            Iterable<Object> entries = Collections.emptyList();
            try {
                String entriesStr = (String)RESTRepositoryClient.this.webResource.path(path).accept(new String[]{"application/json"}).get(String.class);
                entries = RESTRepositoryClient.this.jsonUtil.schemasFromJson(entriesStr);
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to retrieve all schema entries in subject %s", this.getName()), false);
            }
            return entries;
        }

        public boolean integralKeys() {
            boolean integral = false;
            try {
                String path = this.getName() + "/integral";
                integral = Boolean.parseBoolean((String)RESTRepositoryClient.this.webResource.path(path).get(String.class));
            }
            catch (RuntimeException e) {
                RESTRepositoryClient.this.handleException(e, String.format("Failed to determine if keys are integral in subject %s", this.getName()), false);
            }
            return integral;
        }
    }
}

