/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.IOException;
import javax.inject.Inject;
import org.schemarepo.Repository;
import org.schemarepo.RepositoryCache;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepository
implements Repository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repo;
    private final RepositoryCache cache;
    private final double runtimeID = Math.random();

    @Inject
    public CacheRepository(Repository repo, RepositoryCache cache) {
        this.repo = repo;
        this.cache = cache;
        this.logger.info("Constructed {}", (Object)this);
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        Subject s = this.cache.lookup(subjectName);
        if (s == null) {
            return this.cache.add(this.repo.register(subjectName, config));
        }
        return s;
    }

    @Override
    public Subject lookup(String subjectName) {
        Subject s = this.cache.lookup(subjectName);
        if (s == null) {
            return this.cache.add(this.repo.lookup(subjectName));
        }
        return s;
    }

    @Override
    public Iterable<Subject> subjects() {
        Iterable<Subject> subs = this.repo.subjects();
        for (Subject s : subs) {
            this.cache.add(s);
        }
        return subs;
    }

    @Override
    public void close() throws IOException {
        this.repo.close();
        this.logger.info("Closed {}", (Object)this);
    }

    public String toString() {
        return "CacheRepository with the following properties:\n\trepo: " + this.repo.getClass().toString() + "\n" + "\tcache: " + this.cache.getClass().toString() + "\n" + "\truntimeID: " + this.runtimeID;
    }
}

