/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import javax.inject.Inject;
import org.schemarepo.InMemorySchemaEntryCache;
import org.schemarepo.InMemorySubjectCache;
import org.schemarepo.Repository;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.ValidatorFactory;

public class InMemoryRepository
implements Repository {
    private final InMemorySubjectCache subjects = new InMemorySubjectCache();
    private final ValidatorFactory validators;

    @Inject
    public InMemoryRepository(ValidatorFactory validators) {
        this.validators = validators;
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        return this.subjects.add(Subject.validatingSubject(new MemSubject(subjectName, config), this.validators));
    }

    @Override
    public Subject lookup(String subject) {
        return this.subjects.lookup(subject);
    }

    @Override
    public Iterable<Subject> subjects() {
        return this.subjects.values();
    }

    @Override
    public void close() {
    }

    private static class MemSubject
    extends Subject {
        private final InMemorySchemaEntryCache schemas = new InMemorySchemaEntryCache();
        private SchemaEntry latest = null;
        private int nextId = 0;
        private SubjectConfig config;

        protected MemSubject(String name, SubjectConfig config) {
            super(name);
            this.config = RepositoryUtil.safeConfig(config);
        }

        @Override
        public SubjectConfig getConfig() {
            return this.config;
        }

        @Override
        public synchronized SchemaEntry register(String schema) throws SchemaValidationException {
            SchemaEntry valueInCache;
            String id = String.valueOf(this.nextId);
            SchemaEntry toRegister = new SchemaEntry(id, schema);
            if (toRegister == (valueInCache = this.schemas.add(toRegister))) {
                ++this.nextId;
                this.latest = toRegister;
            }
            return valueInCache;
        }

        @Override
        public synchronized SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            if (latest == this.latest || latest != null && latest.equals(this.latest)) {
                return this.register(schema);
            }
            return null;
        }

        @Override
        public SchemaEntry lookupBySchema(String schema) {
            return this.schemas.lookupBySchema(schema);
        }

        @Override
        public SchemaEntry lookupById(String id) {
            return this.schemas.lookupById(id);
        }

        @Override
        public synchronized SchemaEntry latest() {
            return this.latest;
        }

        @Override
        public synchronized Iterable<SchemaEntry> allEntries() {
            return this.schemas.values();
        }

        @Override
        public boolean integralKeys() {
            return true;
        }
    }
}

