/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.schemarepo.Repository;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public class ReadOnlyRepository
implements Repository {
    private final Repository repo;

    @Inject
    public ReadOnlyRepository(Repository repo) {
        this.repo = repo;
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        throw new IllegalStateException("Cannot register a Subject in a ReadOnlyRepository");
    }

    @Override
    public Subject lookup(String subjectName) {
        return Subject.readOnly(this.repo.lookup(subjectName));
    }

    @Override
    public Iterable<Subject> subjects() {
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        for (Subject sub : this.repo.subjects()) {
            subjects.add(Subject.readOnly(sub));
        }
        return subjects;
    }

    @Override
    public void close() throws IOException {
        this.repo.close();
    }
}

