/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.schemarepo.SchemaEntry;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public final class RepositoryUtil {
    private RepositoryUtil() {
    }

    public static String subjectsToString(Iterable<Subject> subjects) {
        StringBuilder sb = new StringBuilder();
        for (Subject s : subjects) {
            sb.append(s.getName()).append("\n");
        }
        return sb.toString();
    }

    public static Iterable<String> subjectNamesFromString(String str) {
        ArrayList<String> subjects = new ArrayList<String>();
        if (str != null && !str.isEmpty()) {
            String[] strs;
            for (String s : strs = str.split("\n")) {
                subjects.add(s);
            }
        }
        return subjects;
    }

    public static String schemasToString(Iterable<SchemaEntry> allEntries) {
        StringBuilder sb = new StringBuilder();
        boolean scheamWithNewLine = false;
        for (SchemaEntry s : allEntries) {
            if (s.getSchema().contains("\n")) {
                scheamWithNewLine = true;
            }
            sb.append(s.toString()).append("\n");
        }
        if (scheamWithNewLine) {
            return "ERROR: One of the schemas for this topic contains a new line and won't be parse-able properly. Please use a non-plain text format instead (e.g.: JSON).\n" + sb;
        }
        return sb.toString();
    }

    public static Iterable<SchemaEntry> schemasFromString(String str) {
        ArrayList<SchemaEntry> schemas = new ArrayList<SchemaEntry>();
        if (str != null && !str.isEmpty()) {
            String[] strs;
            for (String s : strs = str.split("\n")) {
                schemas.add(new SchemaEntry(s));
            }
        }
        return schemas;
    }

    public static void validateSchemaOrSubject(String val) {
        if (null == val || val.isEmpty()) {
            throw new IllegalArgumentException("Provided string is null or empty: '" + val + "'");
        }
    }

    public static SubjectConfig configFromProperties(Properties props) {
        HashMap<String, String> propData = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            propData.put(key, props.getProperty(key));
        }
        return new SubjectConfig.Builder().set(propData).build();
    }

    public static SubjectConfig safeConfig(SubjectConfig config) {
        if (null == config) {
            return SubjectConfig.emptyConfig();
        }
        return config;
    }
}

