/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.schemarepo.DelegatingSubject;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaEntryCache;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.SubjectConfig;
import org.schemarepo.Validator;
import org.schemarepo.ValidatorFactory;

public abstract class Subject {
    private final String name;

    protected Subject(String name) {
        RepositoryUtil.validateSchemaOrSubject(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract SubjectConfig getConfig();

    public abstract boolean integralKeys();

    public abstract SchemaEntry register(String var1) throws SchemaValidationException;

    public abstract SchemaEntry registerIfLatest(String var1, SchemaEntry var2) throws SchemaValidationException;

    public abstract SchemaEntry lookupBySchema(String var1);

    public abstract SchemaEntry lookupById(String var1);

    public abstract SchemaEntry latest();

    public abstract Iterable<SchemaEntry> allEntries();

    public String toString() {
        return this.name;
    }

    public static final Subject readOnly(Subject subject) {
        if (null == subject) {
            return subject;
        }
        return new ReadOnlySubject(subject);
    }

    public static Subject validatingSubject(Subject subject, ValidatorFactory factory) {
        if (null == subject) {
            return subject;
        }
        List<Validator> validators = factory.getValidators(subject.getConfig().getValidators());
        if (!validators.isEmpty()) {
            return new ValidatingSubject(subject, new CompositeValidator(validators));
        }
        return subject;
    }

    public static Subject cacheWith(Subject subject, SchemaEntryCache cache) {
        return null == subject || null == cache ? subject : new CachingSubject(subject, cache);
    }

    private static class CachingSubject
    extends DelegatingSubject {
        private final SchemaEntryCache cache;

        private CachingSubject(Subject delegate, SchemaEntryCache cache) {
            super(delegate);
            this.cache = cache;
        }

        @Override
        public SchemaEntry register(String schema) throws SchemaValidationException {
            SchemaEntry entry = this.cache.lookupBySchema(schema);
            if (entry == null) {
                return this.cache.add(super.register(schema));
            }
            return entry;
        }

        @Override
        public SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            return this.cache.add(super.registerIfLatest(schema, latest));
        }

        @Override
        public SchemaEntry lookupBySchema(String schema) {
            SchemaEntry entry = this.cache.lookupBySchema(schema);
            if (entry == null) {
                return this.cache.add(super.lookupBySchema(schema));
            }
            return entry;
        }

        @Override
        public SchemaEntry lookupById(String id) {
            SchemaEntry entry = this.cache.lookupById(id);
            if (entry == null) {
                return this.cache.add(super.lookupById(id));
            }
            return entry;
        }

        @Override
        public Iterable<SchemaEntry> allEntries() {
            Iterable<SchemaEntry> all = super.allEntries();
            for (SchemaEntry entry : all) {
                this.cache.add(entry);
            }
            return all;
        }
    }

    private static class ValidatingSubject
    extends DelegatingSubject {
        protected final Validator validator;

        private ValidatingSubject(Subject delegate, Validator validator) {
            super(delegate);
            this.validator = validator;
        }

        @Override
        public SchemaEntry register(String schema) throws SchemaValidationException {
            SchemaEntry actualLatest;
            SchemaEntry registered;
            do {
                Iterable<SchemaEntry> schemaEntries = this.allEntries();
                actualLatest = null;
                Iterator<SchemaEntry> i$ = schemaEntries.iterator();
                if (i$.hasNext()) {
                    SchemaEntry entry;
                    actualLatest = entry = i$.next();
                }
                this.validator.validate(schema, schemaEntries);
            } while (null == (registered = super.registerIfLatest(schema, actualLatest)));
            return registered;
        }

        @Override
        public SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            Iterable<SchemaEntry> schemaEntries = this.allEntries();
            SchemaEntry actualLatest = null;
            Iterator<SchemaEntry> i$ = schemaEntries.iterator();
            if (i$.hasNext()) {
                SchemaEntry entry;
                actualLatest = entry = i$.next();
            }
            if (actualLatest == latest || actualLatest != null && actualLatest.equals(latest)) {
                this.validator.validate(schema, schemaEntries);
                return super.registerIfLatest(schema, latest);
            }
            return null;
        }
    }

    private static final class CompositeValidator
    implements Validator {
        private final ArrayList<Validator> validators;

        private CompositeValidator(List<Validator> validators) {
            this.validators = new ArrayList<Validator>(validators);
        }

        @Override
        public void validate(String schemaToValidate, Iterable<SchemaEntry> schemasInOrder) throws SchemaValidationException {
            for (Validator v : this.validators) {
                v.validate(schemaToValidate, schemasInOrder);
            }
        }
    }

    private static class ReadOnlySubject
    extends DelegatingSubject {
        private ReadOnlySubject(Subject subject) {
            super(subject);
        }

        @Override
        public SchemaEntry register(String schema) throws SchemaValidationException {
            throw new IllegalStateException("Cannot register, subject is read-only");
        }

        @Override
        public SchemaEntry registerIfLatest(String schema, SchemaEntry latest) {
            throw new IllegalStateException("Cannot register, subject is read-only");
        }
    }
}

