/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubjectConfig {
    private static final SubjectConfig EMPTY = new Builder().build();
    private final Map<String, String> conf;
    private final Set<String> validators;

    private SubjectConfig(Map<String, String> conf, Set<String> validators) {
        this.conf = conf;
        this.validators = validators;
    }

    public String get(String key) {
        return this.conf.get(key);
    }

    public Set<String> getValidators() {
        return this.validators;
    }

    public Map<String, String> asMap() {
        return this.conf;
    }

    public static SubjectConfig emptyConfig() {
        return EMPTY;
    }

    public int hashCode() {
        return ((Object)this.conf).hashCode() * 31 + ((Object)this.validators).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubjectConfig other = (SubjectConfig)obj;
        if (!((Object)this.validators).equals(other.validators)) {
            return false;
        }
        return ((Object)this.conf).equals(other.conf);
    }

    private static List<String> commaSplit(String toSplit) {
        if (toSplit == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : toSplit.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            list.add(s);
        }
        return list;
    }

    private static String commaJoin(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(s).append(',');
        }
        return sb.toString();
    }

    public static class Builder {
        private static final String RESERVED_PREFIX = "repo.";
        private static final String VALIDATORS_KEY = "repo.validators";
        private final HashMap<String, String> conf = new HashMap();
        private final HashSet<String> validators = new HashSet();

        public Builder set(Map<String, String> config) {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder set(String key, String value) {
            if (key.startsWith(RESERVED_PREFIX)) {
                if (!VALIDATORS_KEY.equals(key)) throw new RuntimeException("SubjectConfig keys starting with 'repo.' are reserved, failed to set: " + key + " to value: " + value);
                this.setValidators(SubjectConfig.commaSplit(value));
                return this;
            } else {
                this.conf.put(key, value);
            }
            return this;
        }

        public Builder setValidators(Collection<String> validatorNames) {
            this.validators.clear();
            this.conf.remove(VALIDATORS_KEY);
            if (!validatorNames.isEmpty()) {
                this.validators.addAll(validatorNames);
                this.conf.put(VALIDATORS_KEY, SubjectConfig.commaJoin(this.validators));
            }
            return this;
        }

        public Builder addValidator(String validatorName) {
            this.validators.add(validatorName);
            this.conf.put(VALIDATORS_KEY, SubjectConfig.commaJoin(this.validators));
            return this;
        }

        public SubjectConfig build() {
            return new SubjectConfig(Collections.unmodifiableMap(new HashMap<String, String>(this.conf)), Collections.unmodifiableSet(new HashSet<String>(this.validators)));
        }
    }
}

