/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.util.ArrayList;
import java.util.List;
import org.schwa.dr.Ann;
import org.schwa.dr.FieldSchema;

public class AnnSchema {
    protected final Class<? extends Ann> klass;
    protected final String name;
    protected String serial;
    protected List<FieldSchema> fieldSchemas;

    protected AnnSchema(Class<? extends Ann> klass, String name, String serial) {
        this.klass = klass;
        this.name = name;
        this.serial = serial;
        this.fieldSchemas = new ArrayList<FieldSchema>();
    }

    public void addField(FieldSchema fieldSchema) {
        this.fieldSchemas.add(fieldSchema);
    }

    public Class<? extends Ann> getKlass() {
        return this.klass;
    }

    public FieldSchema getField(int index) {
        return this.fieldSchemas.get(index);
    }

    public FieldSchema getField(String name) {
        for (FieldSchema field : this.fieldSchemas) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List<FieldSchema> getFields() {
        return this.fieldSchemas;
    }

    public String getName() {
        return this.name;
    }

    public String getSerial() {
        return this.serial;
    }

    public boolean hasFields() {
        return !this.fieldSchemas.isEmpty();
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public static AnnSchema create(Class<? extends Ann> klass, String name) {
        return new AnnSchema(klass, name, name);
    }

    public static AnnSchema create(Class<? extends Ann> klass, String name, String serial) {
        return new AnnSchema(klass, name, serial);
    }
}

