/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.schwa.dr.Ann;
import org.schwa.dr.AnnSchema;
import org.schwa.dr.ByteSlice;
import org.schwa.dr.Doc;
import org.schwa.dr.FieldSchema;
import org.schwa.dr.IllegalAnnotationException;
import org.schwa.dr.Slice;
import org.schwa.dr.Store;
import org.schwa.dr.StoreSchema;
import org.schwa.dr.dr;

public final class DocSchema
extends AnnSchema {
    public static final Class<?>[] ALLOWED_FIELD_KLASSES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, String.class, ByteSlice.class};
    public static final Class<? extends Annotation>[] ANNOTATION_KLASSES = new Class[]{dr.Field.class, dr.Pointer.class, dr.SelfPointer.class, dr.Store.class};
    protected List<AnnSchema> annSchemas = new ArrayList<AnnSchema>();
    protected List<StoreSchema> storeSchemas = new ArrayList<StoreSchema>();

    private DocSchema(Class<? extends Ann> klass, String name) {
        super(klass, name, "__meta__");
        this.traverseDocKlass();
    }

    public void addSchema(AnnSchema annSchema) {
        this.annSchemas.add(annSchema);
    }

    public void addStore(StoreSchema storeSchema) {
        this.storeSchemas.add(storeSchema);
    }

    public AnnSchema getSchema(Class<? extends Ann> klass) {
        for (AnnSchema ann : this.annSchemas) {
            if (!ann.getKlass().equals(klass)) continue;
            return ann;
        }
        return null;
    }

    public List<AnnSchema> getSchemas() {
        return this.annSchemas;
    }

    public StoreSchema getStore(String name) {
        for (StoreSchema store : this.storeSchemas) {
            if (!store.getName().equals(name)) continue;
            return store;
        }
        return null;
    }

    public List<StoreSchema> getStores() {
        return this.storeSchemas;
    }

    public boolean hasStore(String name) {
        return this.getStore(name) != null;
    }

    public boolean hasStores() {
        return !this.storeSchemas.isEmpty();
    }

    private void traverseDocKlass() {
        for (Field field : this.klass.getFields()) {
            Class<?> fieldKlass = field.getType();
            dr.Store drStore = field.getAnnotation(dr.Store.class);
            if (fieldKlass != Store.class || drStore == null) continue;
            DocSchema.ensureNoOtherAnnotations(field, dr.Store.class);
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            assert (types.length == 1);
            Class storedKlass = (Class)types[0];
            dr.Ann drAnn = storedKlass.getAnnotation(dr.Ann.class);
            if (drAnn == null) {
                throw new IllegalAnnotationException("The stored class '" + storedKlass + "' in field '" + field + "' is not annotated with dr.Ann");
            }
            StoreSchema storeSchema = StoreSchema.create(field, storedKlass, drStore);
            this.addStore(storeSchema);
            AnnSchema annSchema = drAnn.serial().isEmpty() ? AnnSchema.create(storedKlass, storedKlass.getSimpleName()) : AnnSchema.create(storedKlass, storedKlass.getSimpleName(), drAnn.serial());
            this.addSchema(annSchema);
        }
        this.traverseAnnSchema(this);
        for (AnnSchema s : this.annSchemas) {
            this.traverseAnnSchema(s);
        }
    }

    private void traverseAnnSchema(AnnSchema annSchema) {
        for (Field field : annSchema.getKlass().getFields()) {
            Class<?> fieldKlass = field.getType();
            dr.Field drField = field.getAnnotation(dr.Field.class);
            dr.Pointer drPointer = field.getAnnotation(dr.Pointer.class);
            dr.SelfPointer drSelfPointer = field.getAnnotation(dr.SelfPointer.class);
            if (drField != null) {
                DocSchema.ensureNoOtherAnnotations(field, dr.Field.class);
                DocSchema.validateFieldField(field, drField, annSchema);
                continue;
            }
            if (drPointer != null) {
                DocSchema.ensureNoOtherAnnotations(field, dr.Pointer.class);
                if (!this.hasStore(drPointer.store())) {
                    throw new IllegalAnnotationException("Store name '" + drPointer.store() + "' on field '" + field + "' is unknown");
                }
                DocSchema.validatePointerField(field, drPointer, annSchema);
                continue;
            }
            if (drSelfPointer == null) continue;
            DocSchema.ensureNoOtherAnnotations(field, dr.SelfPointer.class);
            DocSchema.validateSelfPointerField(field, drSelfPointer, annSchema);
        }
    }

    private static void ensureNoOtherAnnotations(Field field, Class<?> knownAnnotationKlass) {
        for (Class<? extends Annotation> klass : ANNOTATION_KLASSES) {
            if (klass == knownAnnotationKlass || field.getAnnotation(klass) == null) continue;
            throw new IllegalAnnotationException("Field '" + field + "' cannot have more than one docrep annotation.");
        }
    }

    private static void validateFieldField(Field field, dr.Field drField, AnnSchema annSchema) {
        Class<?> fieldKlass = field.getType();
        Class<?> validKlass = null;
        for (Class<?> k : ALLOWED_FIELD_KLASSES) {
            if (k != fieldKlass) continue;
            validKlass = k;
            break;
        }
        if (validKlass == null) {
            throw new IllegalAnnotationException("Field '" + field + "' which is annotated with dr.Field is of an invalid type");
        }
        FieldSchema fieldSchema = fieldKlass == ByteSlice.class ? FieldSchema.createByteSlice(field, drField) : FieldSchema.createPrimitive(field, drField);
        annSchema.addField(fieldSchema);
    }

    private static void validatePointerField(Field field, dr.Pointer drPointer, AnnSchema annSchema) {
        FieldSchema fieldSchema;
        Class<?> fieldKlass = field.getType();
        if (fieldKlass == Slice.class) {
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            Class pointedToKlass = (Class)types[0];
            fieldSchema = FieldSchema.createPointerSlice(field, drPointer, pointedToKlass);
        } else if (Ann.class.isAssignableFrom(fieldKlass)) {
            Class<?> pointedToKlass = fieldKlass;
            fieldSchema = FieldSchema.createPointer(field, drPointer, pointedToKlass);
        } else if (List.class.isAssignableFrom(fieldKlass)) {
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            Class listKlass = (Class)types[0];
            if (!Ann.class.isAssignableFrom(listKlass)) {
                throw new IllegalAnnotationException("Field '" + field + "' cannot be annotated with dr.Pointer when the generic type T of List<T> is not an Ann subclass");
            }
            Class pointedToKlass = listKlass;
            fieldSchema = FieldSchema.createPointers(field, drPointer, pointedToKlass);
        } else {
            throw new IllegalAnnotationException("Field '" + field + "' which is annotated with dr.Pointer is of an invalid type");
        }
        annSchema.addField(fieldSchema);
    }

    private static void validateSelfPointerField(Field field, dr.SelfPointer drSelfPointer, AnnSchema annSchema) {
        FieldSchema fieldSchema;
        Class<?> fieldKlass = field.getType();
        if (fieldKlass == Slice.class) {
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            Class pointedToKlass = (Class)types[0];
            fieldSchema = FieldSchema.createSelfPointerSlice(field, drSelfPointer, pointedToKlass);
        } else if (Ann.class.isAssignableFrom(fieldKlass)) {
            Class<?> pointedToKlass = fieldKlass;
            fieldSchema = FieldSchema.createSelfPointer(field, drSelfPointer, pointedToKlass);
        } else if (List.class.isAssignableFrom(fieldKlass)) {
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            Class listKlass = (Class)types[0];
            if (!Ann.class.isAssignableFrom(listKlass)) {
                throw new IllegalAnnotationException("Field '" + field + "' cannot be annotated with dr.Pointer when the generic type T of List<T> is not an Ann subclass");
            }
            Class pointedToKlass = listKlass;
            fieldSchema = FieldSchema.createSelfPointers(field, drSelfPointer, pointedToKlass);
        } else {
            throw new IllegalAnnotationException("Field '" + field + "' which is annotated with dr.Pointer is of an invalid type");
        }
        annSchema.addField(fieldSchema);
    }

    public static <T extends Doc> DocSchema create(Class<T> klass) {
        if (!klass.isAnnotationPresent(dr.Doc.class)) {
            throw new IllegalArgumentException("The provided class is not annotated with dr.Doc");
        }
        return new DocSchema(klass, klass.getName());
    }
}

