/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.msgpack.core.MessagePackFactory;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.value.holder.ValueHolder;
import org.schwa.dr.Ann;
import org.schwa.dr.AnnSchema;
import org.schwa.dr.Doc;
import org.schwa.dr.DocSchema;
import org.schwa.dr.DocrepException;
import org.schwa.dr.FieldMode;
import org.schwa.dr.FieldSchema;
import org.schwa.dr.ReaderException;
import org.schwa.dr.ReaderHelper;
import org.schwa.dr.Store;
import org.schwa.dr.StoreSchema;
import org.schwa.dr.runtime.RTAnnSchema;
import org.schwa.dr.runtime.RTFactory;
import org.schwa.dr.runtime.RTFieldSchema;
import org.schwa.dr.runtime.RTManager;
import org.schwa.dr.runtime.RTStoreSchema;

public final class Reader<T extends Doc>
implements Iterable<T>,
Iterator<T> {
    public static final byte WIRE_VERSION = 3;
    private final ByteArrayInputStream in;
    private final DocSchema docSchema;
    private final MessageUnpacker unpacker;
    private T doc;

    public Reader(ByteArrayInputStream in, DocSchema docSchema) {
        this.in = in;
        this.docSchema = docSchema;
        this.unpacker = new MessageUnpacker((MessageBufferInput)new InputStreamBufferInput((InputStream)in, 1));
        this.readNext();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.doc != null;
    }

    @Override
    public T next() {
        T doc = this.doc;
        this.readNext();
        return doc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void readNext() {
        try {
            this._readNext();
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
        catch (InstantiationException e) {
            throw new DocrepException(e);
        }
        catch (IllegalAccessException e) {
            throw new DocrepException(e);
        }
    }

    private void _readNext() throws IOException, InstantiationException, IllegalAccessException {
        byte wireVersion;
        try {
            wireVersion = this.unpacker.unpackByte();
        }
        catch (EOFException e) {
            this.doc = null;
            return;
        }
        if (wireVersion != 3) {
            throw new ReaderException("Invalid wire format version. Stream has version " + wireVersion + " but I can only read version " + 3 + ". Ensure the input is not plain text.");
        }
        RTManager rt = RTFactory.create();
        this.doc = (Doc)this.docSchema.getKlass().newInstance();
        this.doc.setDRRT(rt);
        HashMap<String, AnnSchema> klassNameMap = new HashMap<String, AnnSchema>();
        klassNameMap.put("__meta__", this.docSchema);
        for (AnnSchema ann : this.docSchema.getSchemas()) {
            klassNameMap.put(ann.getSerial(), ann);
        }
        HashMap<RTFieldSchema, Integer> rtFieldSchemaToStoreIds = new HashMap<RTFieldSchema, Integer>();
        Integer klassIdMeta = null;
        int nklasses = this.unpacker.unpackArrayHeader();
        for (int k = 0; k != nklasses; ++k) {
            int npair = this.unpacker.unpackArrayHeader();
            if (npair != 2) {
                throw new ReaderException("Invalid sized tuple read in: expected 2 elements but found " + npair);
            }
            String klassName = this.unpacker.unpackString();
            AnnSchema schema = (AnnSchema)klassNameMap.get(klassName);
            RTAnnSchema rtAnnSchema = schema == null ? new RTAnnSchema(k, klassName) : new RTAnnSchema(k, klassName, schema);
            rt.addAnn(rtAnnSchema);
            if (klassName.equals("__meta__")) {
                klassIdMeta = k;
            }
            int nfields = this.unpacker.unpackArrayHeader();
            for (int f = 0; f != nfields; ++f) {
                RTFieldSchema rtFieldSchema;
                String fieldName = null;
                int storeId = -1;
                boolean isPointer = false;
                boolean isSelfPointer = false;
                boolean isSlice = false;
                boolean isCollection = false;
                int nitems = this.unpacker.unpackMapHeader();
                block12: for (int i = 0; i != nitems; ++i) {
                    byte key = this.unpacker.unpackByte();
                    switch (key) {
                        case 0: {
                            fieldName = this.unpacker.unpackString();
                            continue block12;
                        }
                        case 1: {
                            storeId = this.unpacker.unpackInt();
                            isPointer = true;
                            continue block12;
                        }
                        case 2: {
                            this.unpacker.unpackNil();
                            isSlice = true;
                            continue block12;
                        }
                        case 3: {
                            this.unpacker.unpackNil();
                            isSelfPointer = true;
                            continue block12;
                        }
                        case 4: {
                            this.unpacker.unpackNil();
                            isCollection = true;
                            continue block12;
                        }
                        default: {
                            throw new ReaderException("Unknown value " + key + " as key in <field> map");
                        }
                    }
                }
                if (fieldName == null) {
                    throw new ReaderException("Field number " + (f + 1) + " did not contain a NAME key");
                }
                if (rtAnnSchema.isLazy()) {
                    rtFieldSchema = new RTFieldSchema(f, fieldName, null, isCollection, isSelfPointer, isSlice);
                } else {
                    FieldSchema fieldDef = null;
                    for (FieldSchema field : rtAnnSchema.getDef().getFields()) {
                        if (!field.getSerial().equals(fieldName)) continue;
                        fieldDef = field;
                        break;
                    }
                    rtFieldSchema = new RTFieldSchema(f, fieldName, null, isCollection, isSelfPointer, isSlice, fieldDef);
                    if (fieldDef != null) {
                        if (isPointer != fieldDef.isPointer()) {
                            throw new ReaderException("Field '" + fieldName + "' of class '" + klassName + "' has IS_POINTER as " + isPointer + " on the stream, but " + fieldDef.isPointer() + " on the class's field");
                        }
                        if (isSlice != fieldDef.isSlice()) {
                            throw new ReaderException("Field '" + fieldName + "' of class '" + klassName + "' has IS_SLICE as " + isSlice + " on the stream, but " + fieldDef.isSlice() + " on the class's field");
                        }
                        if (isSelfPointer != fieldDef.isSelfPointer()) {
                            throw new ReaderException("Field '" + fieldName + "' of class '" + klassName + "' has IS_SELF_POINTER as " + isSelfPointer + " on the stream, but " + fieldDef.isSelfPointer() + " on the class's field");
                        }
                        if (isCollection != fieldDef.isCollection()) {
                            throw new ReaderException("Field '" + fieldName + "' of class '" + klassName + "' has IS_COLLECTION as " + isCollection + " on the stream, but " + fieldDef.isCollection() + " on the class's field");
                        }
                    }
                }
                rtAnnSchema.addField(rtFieldSchema);
                if (!isPointer) continue;
                rtFieldSchemaToStoreIds.put(rtFieldSchema, storeId);
            }
        }
        if (klassIdMeta == null) {
            throw new ReaderException("Did not read in a __meta__ class");
        }
        RTAnnSchema rtDocSchema = rt.getSchema(klassIdMeta);
        rt.setDocSchema(rtDocSchema);
        int nstores = this.unpacker.unpackArrayHeader();
        for (int n = 0; n != nstores; ++n) {
            Class<? extends Ann> klassKlass;
            int ntriple = this.unpacker.unpackArrayHeader();
            if (ntriple != 3) {
                throw new ReaderException("Invalid sized tuple read in: expected 3 elements but found " + ntriple);
            }
            String storeName = this.unpacker.unpackString();
            int klassId = this.unpacker.unpackInt();
            int nElem = this.unpacker.unpackInt();
            if (klassId >= rt.getSchemas().size()) {
                throw new ReaderException("klassId value " + klassId + " >= number of klasses (" + rt.getSchemas().size() + ")");
            }
            StoreSchema def = null;
            for (StoreSchema store : this.docSchema.getStores()) {
                if (!store.getSerial().equals(storeName)) continue;
                def = store;
                break;
            }
            RTAnnSchema klass = rt.getSchema(klassId);
            RTStoreSchema rtStoreSchema = def == null ? new RTStoreSchema(n, storeName, klass, null, nElem) : new RTStoreSchema(n, storeName, klass, def);
            rtDocSchema.addStore(rtStoreSchema);
            if (rtStoreSchema.isLazy()) continue;
            Class<? extends Ann> storeKlass = def.getStoredKlass();
            if (!storeKlass.equals(klassKlass = klass.getDef().getKlass())) {
                throw new ReaderException("Store '" + storeName + "' points to " + storeKlass + " but the stream says it points to " + klassKlass);
            }
            def.resize(nElem, (Doc)this.doc);
        }
        for (RTAnnSchema rtSchema : rt.getSchemas()) {
            for (RTFieldSchema rtField : rtSchema.getFields()) {
                Class<? extends Ann> storedKlass;
                Class<? extends Ann> pointedToKlass;
                if (!rtFieldSchemaToStoreIds.containsKey(rtField)) continue;
                int storeId = (Integer)rtFieldSchemaToStoreIds.get(rtField);
                if (storeId >= rtDocSchema.getStores().size()) {
                    throw new ReaderException("storeId value " + storeId + " >= number of stores (" + rtDocSchema.getStores().size() + ")");
                }
                RTStoreSchema rtStore = rtDocSchema.getStore(storeId);
                if (!rtField.isLazy() && (pointedToKlass = rtField.getDef().getPointedToKlass()) != (storedKlass = rtStore.getDef().getStoredKlass())) {
                    throw new ReaderException("Field points to " + pointedToKlass + " but the containing Store stores " + storedKlass);
                }
                rtField.setContainingStore(rtStore);
            }
        }
        long _instancesNBytes = this.unpacker.unpackLong();
        if (_instancesNBytes > Integer.MAX_VALUE) {
            throw new ReaderException("<instances_nbytes> is too large for Java (" + _instancesNBytes + ")");
        }
        int instancesNBytes = (int)_instancesNBytes;
        if (!this.docSchema.hasFields()) {
            byte[] lazyBytes = new byte[instancesNBytes];
            int nbytesRead = this.in.read(lazyBytes);
            if (nbytesRead != instancesNBytes) {
                throw new ReaderException("Failed to read in " + instancesNBytes + " from the input stream");
            }
            rtDocSchema.setLazy(lazyBytes);
        } else {
            ByteArrayOutputStream lazyBOS = new ByteArrayOutputStream(instancesNBytes);
            MessagePacker lazyPacker = MessagePackFactory.newDefaultPacker((OutputStream)lazyBOS);
            int lazyNElem = 0;
            int nitems = this.unpacker.unpackMapHeader();
            for (int i = 0; i != nitems; ++i) {
                int key = this.unpacker.unpackInt();
                RTFieldSchema field = rtDocSchema.getField(key);
                if (field.isLazy()) {
                    ValueHolder lazyValue = new ValueHolder();
                    this.unpacker.unpackValue(lazyValue);
                    lazyPacker.packInt(key);
                    lazyPacker.packValue(lazyValue.get());
                    ++lazyNElem;
                    continue;
                }
                this.in.mark(0);
                int availableBefore = this.in.available();
                ReaderHelper.read(field, this.doc, this.doc, null, this.unpacker);
                int availableAfter = this.in.available();
                if (field.getDef().getMode() != FieldMode.READ_ONLY) continue;
                this.in.reset();
                int lazyNBytes = availableBefore - availableAfter;
                byte[] lazyData = new byte[lazyNBytes];
                int nRead = this.in.read(lazyData);
                if (nRead != lazyNBytes) {
                    throw new ReaderException("Failed to read the correct number of bytes");
                }
                lazyPacker.packInt(key);
                lazyPacker.flush();
                lazyBOS.write(lazyData);
                ++lazyNElem;
            }
            if (lazyNElem != 0) {
                lazyPacker.flush();
                this.doc.setDRLazy(lazyBOS.toByteArray());
                this.doc.setDRLazyNElem(lazyNElem);
            }
        }
        for (RTStoreSchema rtStoreSchema : rtDocSchema.getStores()) {
            long _instancesNBytes2 = this.unpacker.unpackLong();
            if (_instancesNBytes2 > Integer.MAX_VALUE) {
                throw new ReaderException("<instances_nbytes> is too large for Java (" + _instancesNBytes2 + ")");
            }
            int instancesNBytes2 = (int)_instancesNBytes2;
            if (rtStoreSchema.isLazy()) {
                byte[] lazyBytes = new byte[instancesNBytes2];
                int nbytesRead = this.in.read(lazyBytes);
                if (nbytesRead != instancesNBytes2) {
                    throw new ReaderException("Failed to read in " + instancesNBytes2 + " from the input stream");
                }
                rtStoreSchema.setLazy(lazyBytes);
                continue;
            }
            RTAnnSchema storedKlass = rtStoreSchema.getStoredKlass();
            Store<? extends Ann> store = rtStoreSchema.getDef().getStore((Doc)this.doc);
            int ninstances = this.unpacker.unpackArrayHeader();
            for (int o = 0; o != ninstances; ++o) {
                Object ann = store.get(o);
                ByteArrayOutputStream lazyBOS = new ByteArrayOutputStream();
                MessagePacker lazyPacker = MessagePackFactory.newDefaultPacker((OutputStream)lazyBOS);
                int lazyNElem = 0;
                int nitems = this.unpacker.unpackMapHeader();
                for (int i = 0; i != nitems; ++i) {
                    int key = this.unpacker.unpackInt();
                    RTFieldSchema field = storedKlass.getField(key);
                    if (field.isLazy()) {
                        ValueHolder lazyValue = new ValueHolder();
                        this.unpacker.unpackValue(lazyValue);
                        lazyPacker.packInt(key);
                        lazyPacker.packValue(lazyValue.get());
                        ++lazyNElem;
                        continue;
                    }
                    this.in.mark(0);
                    int availableBefore = this.in.available();
                    ReaderHelper.read(field, (Ann)ann, this.doc, store, this.unpacker);
                    int availableAfter = this.in.available();
                    if (field.getDef().getMode() != FieldMode.READ_ONLY) continue;
                    this.in.reset();
                    int lazyNBytes = availableBefore - availableAfter;
                    byte[] lazyData = new byte[lazyNBytes];
                    int nRead = this.in.read(lazyData);
                    if (nRead != lazyNBytes) {
                        throw new ReaderException("Failed to read the correct number of bytes");
                    }
                    lazyPacker.packInt(key);
                    lazyPacker.flush();
                    lazyBOS.write(lazyData);
                    ++lazyNElem;
                }
                if (lazyNElem == 0) continue;
                lazyPacker.flush();
                ann.setDRLazy(lazyBOS.toByteArray());
                ann.setDRLazyNElem(lazyNElem);
            }
        }
    }
}

