/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.msgpack.core.MessageUnpacker;
import org.schwa.dr.Ann;
import org.schwa.dr.ByteSlice;
import org.schwa.dr.Doc;
import org.schwa.dr.FieldSchema;
import org.schwa.dr.ReaderException;
import org.schwa.dr.Slice;
import org.schwa.dr.Store;
import org.schwa.dr.StoreSchema;
import org.schwa.dr.runtime.RTFieldSchema;
import org.schwa.dr.runtime.RTStoreSchema;

final class ReaderHelper {
    private ReaderHelper() {
    }

    public static void read(RTFieldSchema rtFieldSchema, Ann ann, Doc doc, Store<? extends Ann> currentStore, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        StoreSchema storeSchema;
        FieldSchema fieldSchema = rtFieldSchema.getDef();
        Field field = fieldSchema.getField();
        RTStoreSchema rtStoreSchema = rtFieldSchema.getContainingStore();
        StoreSchema storeSchema2 = storeSchema = rtStoreSchema == null ? null : rtStoreSchema.getDef();
        if (rtFieldSchema.isPointer() && rtStoreSchema.isLazy()) {
            throw new ReaderException("Pointer field '" + field + "' cannot point into a lazy store");
        }
        if (rtFieldSchema.isPointer() || rtFieldSchema.isSelfPointer()) {
            Store<? extends Ann> store = rtFieldSchema.isSelfPointer() ? currentStore : rtStoreSchema.getDef().getStore(doc);
            if (rtFieldSchema.isSlice()) {
                ReaderHelper.readPointerSlice(field, ann, store, unpacker);
            } else if (rtFieldSchema.isCollection()) {
                ReaderHelper.readPointers(field, ann, store, unpacker);
            } else {
                ReaderHelper.readPointer(field, ann, store, unpacker);
            }
        } else {
            Class<?> klass = fieldSchema.getField().getType();
            if (klass == ByteSlice.class) {
                ReaderHelper.readByteSlice(field, ann, unpacker);
            } else {
                ReaderHelper.readPrimitive(field, ann, klass, unpacker);
            }
        }
    }

    private static void readByteSlice(Field field, Ann ann, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        int npair = unpacker.unpackArrayHeader();
        if (npair != 2) {
            throw new ReaderException("Invalid sized list read in for SLICE: expected 2 elements but found " + npair);
        }
        long a = unpacker.unpackLong();
        long b = unpacker.unpackLong();
        ByteSlice slice = (ByteSlice)field.get(ann);
        if (slice == null) {
            slice = new ByteSlice();
            field.set(ann, slice);
        }
        slice.start = a;
        slice.stop = a + b;
    }

    private static void readPointer(Field field, Ann ann, Store<? extends Ann> store, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        int index = unpacker.unpackInt();
        field.set(ann, store.get(index));
    }

    private static void readPointerSlice(Field field, Ann ann, Store<? extends Ann> store, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        int npair = unpacker.unpackArrayHeader();
        if (npair != 2) {
            throw new ReaderException("Invalid sized list read in for SLICE: expected 2 elements but found " + npair);
        }
        int a = unpacker.unpackInt();
        int b = unpacker.unpackInt();
        Slice slice = (Slice)field.get(ann);
        if (slice == null) {
            slice = new Slice();
            field.set(ann, slice);
        }
        slice.start = store.get(a);
        slice.stop = store.get(a + b - 1);
    }

    private static void readPointers(Field field, Ann ann, Store<? extends Ann> store, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        int nitems = unpacker.unpackArrayHeader();
        ArrayList<Object> list = new ArrayList<Object>(nitems);
        for (int i = 0; i != nitems; ++i) {
            int index = unpacker.unpackInt();
            list.add(store.get(index));
        }
        field.set(ann, list);
    }

    private static void readPrimitive(Field field, Ann ann, Class<?> klass, MessageUnpacker unpacker) throws IOException, IllegalAccessException {
        if (klass == String.class) {
            String value = unpacker.unpackString();
            field.set(ann, value);
        } else if (klass == Byte.TYPE || klass == Byte.class) {
            byte value = unpacker.unpackByte();
            field.set(ann, value);
        } else if (klass == Character.TYPE || klass == Character.class) {
            char value = (char)unpacker.unpackInt();
            field.set(ann, Character.valueOf(value));
        } else if (klass == Short.TYPE || klass == Short.class) {
            short value = unpacker.unpackShort();
            field.set(ann, value);
        } else if (klass == Integer.TYPE || klass == Integer.class) {
            int value = unpacker.unpackInt();
            field.set(ann, value);
        } else if (klass == Long.TYPE || klass == Long.class) {
            long value = unpacker.unpackLong();
            field.set(ann, value);
        } else if (klass == Float.TYPE || klass == Float.class) {
            float value = unpacker.unpackFloat();
            field.set(ann, Float.valueOf(value));
        } else if (klass == Double.TYPE || klass == Double.class) {
            double value = unpacker.unpackDouble();
            field.set(ann, value);
        } else if (klass == Boolean.TYPE || klass == Boolean.class) {
            boolean value = unpacker.unpackBoolean();
            field.set(ann, value);
        } else {
            throw new ReaderException("Unknown type (" + klass + ") of field '" + field + "'");
        }
    }
}

