/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.schwa.dr.Ann;
import org.schwa.dr.DocrepException;

public class Store<T extends Ann>
implements List<T> {
    protected final List<T> items = new ArrayList<T>();

    @Override
    public boolean add(T obj) {
        if (obj.getDRIndex() != null) {
            throw new IllegalArgumentException("Cannot insert an object into a Store which is already in a store (drIndex=" + obj.getDRIndex() + ")");
        }
        obj.setDRIndex(this.items.size());
        return this.items.add(obj);
    }

    @Override
    public void add(int index, T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Ann obj : c) {
            if (obj.getDRIndex() == null) continue;
            throw new IllegalArgumentException("Cannot insert an object into a Store which is already in a store (drIndex=" + obj.getDRIndex() + ")");
        }
        for (Ann obj : c) {
            obj.setDRIndex(this.items.size());
        }
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (Ann obj : this.items) {
            obj.setDRIndex(null);
        }
        this.items.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    public T create(Class<T> klass) {
        Ann obj;
        try {
            obj = (Ann)klass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new DocrepException(e);
        }
        catch (InstantiationException e) {
            throw new DocrepException(e);
        }
        this.add((T)obj);
        return (T)obj;
    }

    public void create(Class<T> klass, int n) {
        for (int i = 0; i != n; ++i) {
            this.create(klass);
        }
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.items).equals(o);
    }

    @Override
    public T get(int index) {
        return (T)((Ann)this.items.get(index));
    }

    @Override
    public int hashCode() {
        return ((Object)this.items).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.items.toArray(a);
    }
}

