/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.lang.reflect.Field;
import org.schwa.dr.Ann;
import org.schwa.dr.Doc;
import org.schwa.dr.DocrepException;
import org.schwa.dr.FieldMode;
import org.schwa.dr.Store;
import org.schwa.dr.dr;

public final class StoreSchema {
    private final Field field;
    private final String name;
    private final Class<? extends Ann> storedKlass;
    private final FieldMode mode;
    private String serial;

    private StoreSchema(Field field, Class<? extends Ann> storedKlass, String name, FieldMode mode, String serial) {
        this.field = field;
        this.name = name;
        this.storedKlass = storedKlass;
        this.mode = mode;
        serial = serial.trim();
        this.serial = serial.isEmpty() ? name : serial;
    }

    public Field getField() {
        return this.field;
    }

    public FieldMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public String getSerial() {
        return this.serial;
    }

    public Store<? extends Ann> getStore(Doc doc) {
        try {
            return (Store)this.field.get(doc);
        }
        catch (IllegalAccessException e) {
            throw new DocrepException(e);
        }
    }

    public Class<? extends Ann> getStoredKlass() {
        return this.storedKlass;
    }

    public void resize(int size, Doc doc) {
        try {
            Store store = (Store)this.field.get(doc);
            for (int i = 0; i != size; ++i) {
                Ann ann = this.storedKlass.newInstance();
                store.add(ann);
            }
        }
        catch (IllegalAccessException e) {
            throw new DocrepException(e);
        }
        catch (InstantiationException e) {
            throw new DocrepException(e);
        }
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public int size(Doc doc) {
        try {
            return ((Store)this.field.get(doc)).size();
        }
        catch (IllegalAccessException e) {
            throw new DocrepException(e);
        }
    }

    public static StoreSchema create(Field field, Class<? extends Ann> storedKlass, dr.Store drStore) {
        return new StoreSchema(field, storedKlass, field.getName(), drStore.mode(), drStore.serial());
    }
}

