/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.msgpack.core.MessagePackFactory;
import org.msgpack.core.MessagePacker;
import org.schwa.dr.Ann;
import org.schwa.dr.Doc;
import org.schwa.dr.DocSchema;
import org.schwa.dr.FieldMode;
import org.schwa.dr.Store;
import org.schwa.dr.WriterHelper;
import org.schwa.dr.runtime.RTAnnSchema;
import org.schwa.dr.runtime.RTFactory;
import org.schwa.dr.runtime.RTFieldSchema;
import org.schwa.dr.runtime.RTManager;
import org.schwa.dr.runtime.RTStoreSchema;

public final class Writer {
    public static final byte WIRE_VERSION = 3;
    private final OutputStream out;
    private final DocSchema docSchema;
    private final MessagePacker packer;

    public Writer(OutputStream out, DocSchema docSchema) {
        this.out = out;
        this.docSchema = docSchema;
        this.packer = MessagePackFactory.newDefaultPacker((OutputStream)out);
    }

    public void write(Doc doc) throws IOException {
        RTManager rt = RTFactory.buildOrMerge(doc.getDRRT(), this.docSchema);
        RTAnnSchema rtDocSchema = rt.getDocSchema();
        this.packer.packByte((byte)3);
        this.writeKlassesHeader(rt.getSchemas(), rtDocSchema);
        this.writeStoresHeader(rtDocSchema.getStores(), doc);
        if (rtDocSchema.isLazy()) {
            byte[] lazyData = rtDocSchema.getLazyData();
            this.packer.packInt(lazyData.length);
            this.packer.flush();
            this.out.write(lazyData);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.writeInstance(doc, rtDocSchema, doc, dos);
            this.packer.packInt(bos.size());
            this.packer.flush();
            bos.writeTo(this.out);
        }
        for (RTStoreSchema rtStoreSchema : rtDocSchema.getStores()) {
            if (rtStoreSchema.isLazy()) {
                byte[] lazy = rtStoreSchema.getLazyData();
                this.packer.packInt(lazy.length);
                this.packer.flush();
                this.out.write(lazy, 0, lazy.length);
                continue;
            }
            RTAnnSchema storedKlass = rtStoreSchema.getStoredKlass();
            Store<? extends Ann> store = rtStoreSchema.getDef().getStore(doc);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            Writer.writeArrayHeader(dos, store.size());
            for (Ann ann : store) {
                this.writeInstance(ann, storedKlass, doc, dos);
            }
            this.packer.packInt(bos.size());
            this.packer.flush();
            bos.writeTo(this.out);
        }
        this.packer.flush();
        this.out.flush();
    }

    private void writeKlassesHeader(List<RTAnnSchema> schemas, RTAnnSchema rtDocSchema) throws IOException {
        this.packer.packArrayHeader(schemas.size());
        int i = 0;
        for (RTAnnSchema schema : schemas) {
            this.packer.packArrayHeader(2);
            if (schema.getKlassId() != i) {
                throw new AssertionError();
            }
            if (schema == rtDocSchema) {
                this.packer.packString("__meta__");
            } else if (schema.isLazy()) {
                this.packer.packString(schema.getSerial());
            } else {
                this.packer.packString(schema.getDef().getSerial());
            }
            this.packer.packArrayHeader(schema.getFields().size());
            for (RTFieldSchema field : schema.getFields()) {
                int nfields = 1 + (field.isPointer() ? 1 : 0) + (field.isSlice() ? 1 : 0) + (field.isCollection() ? 1 : 0) + (field.isSelfPointer() ? 1 : 0);
                this.packer.packMapHeader(nfields);
                this.packer.packByte((byte)0);
                this.packer.packString(field.isLazy() ? field.getSerial() : field.getDef().getSerial());
                if (field.isPointer()) {
                    this.packer.packByte((byte)1);
                    this.packer.packInt(field.getContainingStore().getStoreId());
                }
                if (field.isSlice()) {
                    this.packer.packByte((byte)2);
                    this.packer.packNil();
                }
                if (field.isSelfPointer()) {
                    this.packer.packByte((byte)3);
                    this.packer.packNil();
                }
                if (!field.isCollection()) continue;
                this.packer.packByte((byte)4);
                this.packer.packNil();
            }
            ++i;
        }
    }

    private void writeStoresHeader(List<RTStoreSchema> stores, Doc doc) throws IOException {
        this.packer.packArrayHeader(stores.size());
        for (RTStoreSchema store : stores) {
            this.packer.packArrayHeader(3);
            if (store.isLazy()) {
                this.packer.packString(store.getSerial());
                this.packer.packInt(store.getStoredKlass().getKlassId());
                this.packer.packInt(store.getLazyNElem());
                continue;
            }
            this.packer.packString(store.getDef().getSerial());
            this.packer.packInt(store.getStoredKlass().getKlassId());
            this.packer.packInt(store.getDef().size(doc));
        }
    }

    private void writeInstance(Ann ann, RTAnnSchema schema, Doc doc, DataOutputStream out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int nNewElem = 0;
        MessagePacker packer = MessagePackFactory.newDefaultPacker((OutputStream)bos);
        for (RTFieldSchema field : schema.getFields()) {
            if (field.isLazy() || field.getDef().getMode() != FieldMode.READ_WRITE || !WriterHelper.write(packer, field, ann)) continue;
            ++nNewElem;
        }
        packer.flush();
        int nElem = nNewElem + ann.getDRLazyNElem();
        Writer.writeMapBegin(out, nElem);
        if (nElem != 0) {
            if (ann.getDRLazyNElem() != 0) {
                out.write(ann.getDRLazy());
            }
            bos.writeTo(out);
        }
    }

    private static void writeArrayHeader(DataOutputStream out, int size) throws IOException {
        if (size < 16) {
            out.write((byte)(0x90 | size));
        } else if (size < 65536) {
            out.write(-36);
            out.writeShort((short)size);
        } else {
            out.write(-35);
            out.writeInt(size);
        }
    }

    private static void writeMapBegin(DataOutputStream out, int size) throws IOException {
        if (size < 16) {
            out.write((byte)(0x80 | size));
        } else if (size < 65536) {
            out.write(-34);
            out.writeShort((short)size);
        } else {
            out.write(-33);
            out.writeInt(size);
        }
    }
}

