/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr;

import java.io.IOException;
import java.util.List;
import org.msgpack.core.MessagePacker;
import org.schwa.dr.Ann;
import org.schwa.dr.ByteSlice;
import org.schwa.dr.FieldSchema;
import org.schwa.dr.Slice;
import org.schwa.dr.WriterException;
import org.schwa.dr.runtime.RTFieldSchema;

final class WriterHelper {
    private WriterHelper() {
    }

    public static boolean write(MessagePacker packer, RTFieldSchema rtFieldSchema, Ann ann) throws IOException {
        FieldSchema fieldSchema = rtFieldSchema.getDef();
        int fieldId = rtFieldSchema.getFieldId();
        Object value = fieldSchema.getFieldValue(ann);
        if (rtFieldSchema.isPointer() || rtFieldSchema.isSelfPointer()) {
            if (rtFieldSchema.isSlice()) {
                return WriterHelper.writePointerSlice(packer, fieldId, (Slice)value);
            }
            if (rtFieldSchema.isCollection()) {
                return WriterHelper.writePointers(packer, fieldId, (List)value);
            }
            return WriterHelper.writePointer(packer, fieldId, (Ann)value);
        }
        Class<?> klass = fieldSchema.getField().getType();
        if (klass == ByteSlice.class) {
            return WriterHelper.writeByteSlice(packer, fieldId, (ByteSlice)value);
        }
        return WriterHelper.writePrimitive(packer, fieldId, value, klass);
    }

    private static boolean writePrimitive(MessagePacker packer, int fieldId, Object value, Class<?> klass) throws IOException {
        if (klass == String.class) {
            return WriterHelper.writeString(packer, fieldId, (String)value);
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            Byte v = (Byte)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packByte(v.byteValue());
                return true;
            }
        } else if (klass == Character.TYPE || klass == Character.class) {
            Character v = (Character)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packInt((int)v.charValue());
                return true;
            }
        } else if (klass == Short.TYPE || klass == Short.class) {
            Short v = (Short)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packShort(v.shortValue());
                return true;
            }
        } else if (klass == Integer.TYPE || klass == Integer.class) {
            Integer v = (Integer)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packInt(v.intValue());
                return true;
            }
        } else if (klass == Long.TYPE || klass == Long.class) {
            Long v = (Long)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packLong(v.longValue());
                return true;
            }
        } else if (klass == Float.TYPE || klass == Float.class) {
            Float v = (Float)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packFloat(v.floatValue());
                return true;
            }
        } else if (klass == Double.TYPE || klass == Double.class) {
            Double v = (Double)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packDouble(v.doubleValue());
                return true;
            }
        } else if (klass == Boolean.TYPE || klass == Boolean.class) {
            Boolean v = (Boolean)value;
            if (v != null) {
                packer.packInt(fieldId);
                packer.packBoolean(v.booleanValue());
                return true;
            }
        } else {
            throw new WriterException("Unknown type of field (" + klass + ")");
        }
        return false;
    }

    private static boolean writeByteSlice(MessagePacker packer, int fieldId, ByteSlice slice) throws IOException {
        if (slice == null) {
            return false;
        }
        packer.packInt(fieldId);
        packer.packArrayHeader(2);
        packer.packLong(slice.start);
        packer.packLong(slice.stop - slice.start);
        return true;
    }

    private static boolean writePointer(MessagePacker packer, int fieldId, Ann ann) throws IOException {
        if (ann == null) {
            return false;
        }
        packer.packInt(fieldId);
        packer.packInt(ann.getDRIndex().intValue());
        return true;
    }

    private static boolean writePointerSlice(MessagePacker packer, int fieldId, Slice<? extends Ann> slice) throws IOException {
        if (slice == null) {
            return false;
        }
        packer.packInt(fieldId);
        packer.packArrayHeader(2);
        packer.packInt(slice.start.getDRIndex().intValue());
        packer.packInt(slice.stop.getDRIndex() - slice.start.getDRIndex() + 1);
        return true;
    }

    private static boolean writePointers(MessagePacker packer, int fieldId, List<? extends Ann> annotations) throws IOException {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        packer.packInt(fieldId);
        packer.packArrayHeader(annotations.size());
        for (Ann ann : annotations) {
            packer.packInt(ann.getDRIndex().intValue());
        }
        return true;
    }

    private static boolean writeString(MessagePacker packer, int fieldId, String s) throws IOException {
        if (s == null || s.isEmpty()) {
            return false;
        }
        packer.packInt(fieldId);
        packer.packString(s);
        return true;
    }
}

