/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr.runtime;

import java.util.ArrayList;
import java.util.List;
import org.schwa.dr.AnnSchema;
import org.schwa.dr.runtime.RTFieldSchema;
import org.schwa.dr.runtime.RTStoreSchema;

public final class RTAnnSchema {
    private int klassId;
    private String serial;
    private AnnSchema def;
    private List<RTFieldSchema> fields;
    private List<RTStoreSchema> stores;
    private byte[] lazy;

    public RTAnnSchema(int klassId, String serial) {
        this(klassId, serial, null);
    }

    public RTAnnSchema(int klassId, String serial, AnnSchema def) {
        this.klassId = klassId;
        this.serial = serial;
        this.def = def;
        this.fields = new ArrayList<RTFieldSchema>();
        this.stores = new ArrayList<RTStoreSchema>();
        this.lazy = null;
    }

    public void addField(RTFieldSchema field) {
        this.fields.add(field);
    }

    public void addStore(RTStoreSchema store) {
        this.stores.add(store);
    }

    public AnnSchema getDef() {
        return this.def;
    }

    public RTFieldSchema getField(int index) {
        return this.fields.get(index);
    }

    public List<RTFieldSchema> getFields() {
        return this.fields;
    }

    public int getKlassId() {
        return this.klassId;
    }

    public byte[] getLazyData() {
        return this.lazy;
    }

    public String getSerial() {
        return this.serial;
    }

    public RTStoreSchema getStore(int index) {
        return this.stores.get(index);
    }

    public List<RTStoreSchema> getStores() {
        return this.stores;
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    public boolean isLazy() {
        return this.def == null;
    }

    public void setDef(AnnSchema def) {
        this.def = def;
    }

    public void setLazy(byte[] lazy) {
        this.lazy = lazy;
    }
}

