/*
 * Decompiled with CFR 0.152.
 */
package org.schwa.dr.runtime;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.schwa.dr.Ann;
import org.schwa.dr.AnnSchema;
import org.schwa.dr.DocSchema;
import org.schwa.dr.FieldSchema;
import org.schwa.dr.StoreSchema;
import org.schwa.dr.runtime.RTAnnSchema;
import org.schwa.dr.runtime.RTFieldSchema;
import org.schwa.dr.runtime.RTManager;
import org.schwa.dr.runtime.RTStoreSchema;

public final class RTFactory {
    public static RTManager create() {
        return new RTManager(null);
    }

    public static RTManager buildOrMerge(RTManager rt, DocSchema docSchema) {
        if (rt == null) {
            return RTFactory.build(docSchema);
        }
        return RTFactory.merge(rt, docSchema);
    }

    public static RTManager build(DocSchema docSchema) {
        RTAnnSchema rtDocSchema = new RTAnnSchema(0, "__meta__", docSchema);
        RTManager rt = new RTManager(rtDocSchema);
        rt.addAnn(rtDocSchema);
        return RTFactory.merge(rt, docSchema);
    }

    public static RTManager merge(RTManager rt, DocSchema docSchema) {
        RTAnnSchema rtDocSchema = rt.getDocSchema();
        int klassId = 0;
        HashMap<String, RTAnnSchema> knownKlasses = new HashMap<String, RTAnnSchema>();
        if (!rt.getSchemas().isEmpty()) {
            for (RTAnnSchema s : rt.getSchemas()) {
                if (!s.isLazy()) {
                    knownKlasses.put(s.getDef().getName(), s);
                }
                if (s.getKlassId() <= klassId) continue;
                klassId = s.getKlassId();
            }
            ++klassId;
        }
        int storeId = 0;
        HashMap<String, RTStoreSchema> knownStores = new HashMap<String, RTStoreSchema>();
        if (!rtDocSchema.getStores().isEmpty()) {
            for (RTStoreSchema s : rtDocSchema.getStores()) {
                if (!s.isLazy()) {
                    knownStores.put(s.getDef().getName(), s);
                }
                if (s.getStoreId() <= storeId) continue;
                storeId = s.getStoreId();
            }
            ++storeId;
        }
        for (StoreSchema store : docSchema.getStores()) {
            RTStoreSchema rtStore = (RTStoreSchema)knownStores.get(store.getName());
            if (rtStore == null) {
                rtStore = new RTStoreSchema(storeId, store.getSerial(), null, store);
                rtDocSchema.addStore(rtStore);
                knownStores.put(store.getName(), rtStore);
                ++storeId;
                continue;
            }
            rtStore.setDef(store);
        }
        List<RTStoreSchema> rtStores = rtDocSchema.getStores();
        if (!rtStores.isEmpty()) {
            Collections.sort(rtStores, new Comparator<RTStoreSchema>(){

                @Override
                public int compare(RTStoreSchema a, RTStoreSchema b) {
                    return a.getStoreId() == b.getStoreId() ? 0 : (a.getStoreId() < b.getStoreId() ? -1 : 1);
                }
            });
            RTStoreSchema last = rtStores.get(rtStores.size() - 1);
            if (last.getStoreId() + 1 != rtStores.size()) {
                throw new AssertionError();
            }
        }
        RTFactory.mergeFields(rtDocSchema, docSchema, knownStores);
        HashMap<Class<? extends Ann>, RTAnnSchema> annKlassToRTAnn = new HashMap<Class<? extends Ann>, RTAnnSchema>();
        for (AnnSchema ann : docSchema.getSchemas()) {
            RTAnnSchema rtAnn = (RTAnnSchema)knownKlasses.get(ann.getName());
            if (rtAnn == null) {
                rtAnn = new RTAnnSchema(klassId, ann.getSerial(), ann);
                rt.addAnn(rtAnn);
                knownKlasses.put(ann.getName(), rtAnn);
                ++klassId;
            } else {
                rtAnn.setDef(ann);
            }
            RTFactory.mergeFields(rtAnn, ann, knownStores);
            annKlassToRTAnn.put(ann.getKlass(), rtAnn);
        }
        List<RTAnnSchema> rtAnnSchemas = rt.getSchemas();
        Collections.sort(rtAnnSchemas, new Comparator<RTAnnSchema>(){

            @Override
            public int compare(RTAnnSchema a, RTAnnSchema b) {
                return a.getKlassId() == b.getKlassId() ? 0 : (a.getKlassId() < b.getKlassId() ? -1 : 1);
            }
        });
        RTAnnSchema last = rtAnnSchemas.get(rtAnnSchemas.size() - 1);
        if (last.getKlassId() + 1 != rtAnnSchemas.size()) {
            throw new AssertionError();
        }
        for (StoreSchema store : docSchema.getStores()) {
            RTStoreSchema rtStore = (RTStoreSchema)knownStores.get(store.getName());
            if (rtStore.getStoredKlass() != null) continue;
            rtStore.setStoredKlass((RTAnnSchema)annKlassToRTAnn.get(store.getStoredKlass()));
        }
        return rt;
    }

    private static void mergeFields(RTAnnSchema rtSchema, AnnSchema schema, Map<String, RTStoreSchema> knownStores) {
        int fieldId = 0;
        HashMap<String, RTFieldSchema> knownFields = new HashMap<String, RTFieldSchema>();
        if (!rtSchema.getFields().isEmpty()) {
            for (RTFieldSchema f : rtSchema.getFields()) {
                if (!f.isLazy()) {
                    knownFields.put(f.getDef().getName(), f);
                }
                if (f.getFieldId() <= fieldId) continue;
                fieldId = f.getFieldId();
            }
            ++fieldId;
        }
        for (FieldSchema field : schema.getFields()) {
            RTFieldSchema rtField = (RTFieldSchema)knownFields.get(field.getName());
            if (rtField == null) {
                RTStoreSchema rtStore = null;
                if (field.isPointer()) {
                    rtStore = knownStores.get(field.getStoreName());
                }
                rtField = new RTFieldSchema(fieldId, field.getSerial(), rtStore, field.isCollection(), field.isSelfPointer(), field.isSlice(), field);
                rtSchema.addField(rtField);
                ++fieldId;
                continue;
            }
            rtField.setDef(field);
        }
        List<RTFieldSchema> rtFields = rtSchema.getFields();
        if (!rtFields.isEmpty()) {
            Collections.sort(rtFields, new Comparator<RTFieldSchema>(){

                @Override
                public int compare(RTFieldSchema a, RTFieldSchema b) {
                    return a.getFieldId() == b.getFieldId() ? 0 : (a.getFieldId() < b.getFieldId() ? -1 : 1);
                }
            });
            RTFieldSchema last = rtFields.get(rtFields.size() - 1);
            if (last.getFieldId() + 1 != rtFields.size()) {
                throw new AssertionError();
            }
        }
    }
}

