/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.impl;

import java.net.Proxy;
import org.schwering.irc.lib.IRCConfig;
import org.schwering.irc.lib.IRCExceptionHandler;
import org.schwering.irc.lib.IRCRuntimeConfig;
import org.schwering.irc.lib.IRCSSLSupport;
import org.schwering.irc.lib.IRCServerConfig;
import org.schwering.irc.lib.IRCTrafficLogger;
import org.schwering.irc.lib.impl.DefaultIRCSSLSupport;
import org.schwering.irc.lib.impl.DefaultIRCServerConfig;

public class DefaultIRCConfig
extends DefaultIRCServerConfig
implements IRCConfig {
    private final boolean autoPong;
    private final Proxy proxy;
    private final IRCSSLSupport sslSupport;
    private final boolean stripColorsEnabled;
    private final int timeout;
    private final IRCTrafficLogger trafficLogger;
    private final IRCExceptionHandler exceptionHandler;

    public DefaultIRCConfig(IRCConfig config) {
        this(config.getHost(), config.getPorts(), config.getPassword(), config.getNick(), config.getUsername(), config.getRealname(), config.getEncoding(), config.getTimeout(), config.isAutoPong(), config.isStripColorsEnabled(), new DefaultIRCSSLSupport(config.getSSLSupport()), config.getProxy(), config.getTrafficLogger(), config.getExceptionHandler());
    }

    public DefaultIRCConfig(IRCServerConfig serverConfig, IRCRuntimeConfig runtimeConfig) {
        this(serverConfig.getHost(), serverConfig.getPorts(), serverConfig.getPassword(), serverConfig.getNick(), serverConfig.getUsername(), serverConfig.getRealname(), serverConfig.getEncoding(), runtimeConfig.getTimeout(), runtimeConfig.isAutoPong(), runtimeConfig.isStripColorsEnabled(), new DefaultIRCSSLSupport(runtimeConfig.getSSLSupport()), runtimeConfig.getProxy(), runtimeConfig.getTrafficLogger(), runtimeConfig.getExceptionHandler());
    }

    public DefaultIRCConfig(String host, int[] ports, String pass, String nick, String username, String realname, String encoding, int timeout, boolean autoPong, boolean stripColorsEnabled, IRCSSLSupport sslSupport, Proxy proxy, IRCTrafficLogger trafficLogger, IRCExceptionHandler exceptionHandler) {
        super(host, ports, pass, nick, username, realname, encoding);
        this.timeout = timeout;
        this.autoPong = autoPong;
        this.stripColorsEnabled = stripColorsEnabled;
        this.sslSupport = sslSupport;
        this.proxy = proxy;
        this.trafficLogger = trafficLogger;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public IRCSSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public IRCTrafficLogger getTrafficLogger() {
        return this.trafficLogger;
    }

    @Override
    public boolean isAutoPong() {
        return this.autoPong;
    }

    @Override
    public boolean isStripColorsEnabled() {
        return this.stripColorsEnabled;
    }

    @Override
    public IRCExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

