/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.impl;

import java.util.Arrays;
import org.schwering.irc.lib.IRCServerConfig;

public class DefaultIRCServerConfig
implements IRCServerConfig {
    private final String encoding;
    private final String host;
    private final String nick;
    private final String pass;
    private final int[] ports;
    private final String realname;
    private final String username;

    public DefaultIRCServerConfig(IRCServerConfig serverConfig) {
        this(serverConfig.getHost(), serverConfig.getPorts(), serverConfig.getPassword(), serverConfig.getNick(), serverConfig.getUsername(), serverConfig.getRealname(), serverConfig.getEncoding());
    }

    public DefaultIRCServerConfig(String host, int[] ports, String pass, String nick, String username, String realname, String encoding) {
        if (host == null || ports == null || ports.length == 0) {
            throw new IllegalArgumentException("Host and ports may not be null.");
        }
        this.host = host;
        this.ports = ports;
        this.pass = pass != null && pass.length() == 0 ? null : pass;
        this.nick = nick;
        this.username = username;
        this.realname = realname;
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getNick() {
        return this.nick;
    }

    @Override
    public String getPassword() {
        return this.pass;
    }

    @Override
    public int getPortAt(int index) {
        return this.ports[index];
    }

    @Override
    public int[] getPorts() {
        return this.ports == null ? new int[]{} : Arrays.copyOf(this.ports, this.ports.length);
    }

    @Override
    public int getPortsCount() {
        return this.ports != null ? this.ports.length : 0;
    }

    @Override
    public String getRealname() {
        return this.realname;
    }

    @Override
    public String getUsername() {
        return this.username;
    }
}

