/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.IRCSSLSupport;

public class SocketFactory {
    private final Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    private final int timeout;

    public SocketFactory(int timeout, Proxy proxy, IRCSSLSupport sslSupport) throws KeyManagementException, NoSuchAlgorithmException {
        this.timeout = timeout;
        Proxy proxy2 = this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
        if (sslSupport != null) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(sslSupport.getKeyManagers(), sslSupport.getTrustManagers(), sslSupport.getSecureRandom());
            this.sslSocketFactory = sslContext.getSocketFactory();
        } else {
            this.sslSocketFactory = null;
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket result;
        if (this.sslSocketFactory == null) {
            result = new Socket(this.proxy);
            result.connect(new InetSocketAddress(host, port), this.timeout);
        } else if (this.proxy == Proxy.NO_PROXY) {
            SSLSocket sslResult = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
            sslResult.startHandshake();
            result = sslResult;
        } else {
            Socket proxySocket = new Socket(this.proxy);
            SSLSocket sslResult = (SSLSocket)this.sslSocketFactory.createSocket(proxySocket, host, port, true);
            sslResult.startHandshake();
            result = sslResult;
        }
        result.setSoTimeout(this.timeout);
        return result;
    }
}

