/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.scijava.minimaven.AbstractPOMHandler;
import org.scijava.minimaven.BuildEnvironment;
import org.scijava.minimaven.Coordinate;
import org.scijava.minimaven.JavaCompiler;
import org.scijava.minimaven.SnapshotPOMHandler;
import org.scijava.minimaven.VersionPOMHandler;
import org.scijava.util.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MavenProject
implements Comparable<MavenProject> {
    protected final BuildEnvironment env;
    protected boolean buildFromSource;
    protected boolean built;
    protected File directory;
    protected File target;
    protected String sourceDirectory = "src/main/java";
    protected MavenProject parent;
    protected MavenProject[] children;
    protected Coordinate coordinate = new Coordinate();
    protected Coordinate parentCoordinate;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected List<String> modules = new ArrayList<String>();
    protected List<Coordinate> dependencies = new ArrayList<Coordinate>();
    protected List<Coordinate> dependencyManagement = new ArrayList<Coordinate>();
    protected Set<String> repositories = new TreeSet<String>();
    protected String sourceVersion;
    protected String targetVersion;
    protected String mainClass;
    protected boolean includeImplementationBuild;
    protected String packaging = "jar";
    private BooleanState upToDate = BooleanState.UNKNOWN;
    private BooleanState jarUpToDate = BooleanState.UNKNOWN;
    private static Attributes.Name CREATED_BY = new Attributes.Name("Created-By");

    protected MavenProject addModule(String name) throws IOException, ParserConfigurationException, SAXException {
        return this.addChild(this.env.parse(new File(new File(this.directory, name), "pom.xml"), this));
    }

    protected MavenProject addChild(MavenProject child) {
        MavenProject[] newChildren = new MavenProject[this.children.length + 1];
        System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
        newChildren[this.children.length] = child;
        this.children = newChildren;
        return child;
    }

    protected MavenProject(BuildEnvironment miniMaven, File directory, MavenProject parent) {
        this.env = miniMaven;
        this.directory = directory;
        this.parent = parent;
        if (parent != null) {
            this.coordinate.groupId = parent.coordinate.groupId;
            this.coordinate.version = parent.coordinate.version;
            this.parentCoordinate = parent.coordinate;
            this.includeImplementationBuild = parent.includeImplementationBuild;
        }
    }

    public void clean() throws IOException, ParserConfigurationException, SAXException {
        String ijDirProperty = this.expand(this.getProperty("imagej.app.directory"));
        File ijDir = ijDirProperty == null ? null : new File(ijDirProperty);
        this.clean(ijDir != null && ijDir.isDirectory() ? ijDir : null);
    }

    public void clean(File ijDir) throws IOException, ParserConfigurationException, SAXException {
        String fileName;
        if ("pom".equals(this.getPackaging())) {
            for (MavenProject child : this.getChildren()) {
                if (child == null) continue;
                child.clean(ijDir);
            }
            return;
        }
        if (!this.buildFromSource) {
            return;
        }
        for (MavenProject child : this.getDependencies(true, this.env.downloadAutomatically, new String[0])) {
            if (child == null) continue;
            child.clean(ijDir);
        }
        if (this.target.isDirectory()) {
            BuildEnvironment.rmRF(this.target);
        } else if (this.target.exists()) {
            this.target.delete();
        }
        File jar = this.getTarget();
        if (jar.exists()) {
            jar.delete();
        }
        if ((fileName = jar.getName()).endsWith(".jar") && ijDir != null) {
            this.deleteVersions(new File(ijDir, "plugins"), fileName, null);
            this.deleteVersions(new File(ijDir, "jars"), fileName, null);
        }
    }

    public void downloadDependencies() throws IOException, ParserConfigurationException, SAXException {
        this.getDependencies(true, true, "test");
        this.download();
    }

    protected void download() throws FileNotFoundException {
        if (this.buildFromSource || this.target.exists()) {
            return;
        }
        this.download(this.coordinate, true);
    }

    protected void download(Coordinate dependency, boolean quiet) throws FileNotFoundException {
        for (String url : this.getRoot().getRepositories()) {
            try {
                if (this.env.debug) {
                    this.env.err.println("Trying to download from " + url);
                }
                this.env.downloadAndVerify(url, dependency, quiet);
                return;
            }
            catch (Exception e) {
                if (!this.env.verbose) continue;
                e.printStackTrace();
            }
        }
        throw new FileNotFoundException("Could not download " + dependency.getJarName());
    }

    public boolean upToDate(boolean includingJar) throws IOException, ParserConfigurationException, SAXException {
        if (includingJar) {
            if (this.jarUpToDate == BooleanState.UNKNOWN) {
                this.jarUpToDate = this.checkUpToDate(true) ? BooleanState.YES : BooleanState.NO;
            }
            return this.jarUpToDate == BooleanState.YES;
        }
        if (this.upToDate == BooleanState.UNKNOWN) {
            this.upToDate = this.checkUpToDate(false) ? BooleanState.YES : BooleanState.NO;
        }
        return this.upToDate == BooleanState.YES;
    }

    public boolean checkUpToDate(boolean includingJar) throws IOException, ParserConfigurationException, SAXException {
        File jar;
        if (!this.buildFromSource) {
            return true;
        }
        for (MavenProject child : this.getDependencies(true, this.env.downloadAutomatically, "test")) {
            if (child == null || child.upToDate(includingJar)) continue;
            if (this.env.verbose) {
                this.env.err.println(this.getArtifactId() + " not up-to-date because of " + child.getArtifactId());
            }
            return false;
        }
        File source = this.getSourceDirectory();
        ArrayList<String> notUpToDates = new ArrayList<String>();
        long lastModified = this.addRecursively(notUpToDates, source, ".java", this.target, ".class", false);
        int count = notUpToDates.size();
        if (count == 1 && ((String)notUpToDates.get(0)).endsWith("poi/hssf/dev/EFHSSF.java")) {
            count = 0;
        }
        if (count > 0) {
            if (this.env.verbose) {
                StringBuilder files = new StringBuilder();
                boolean counter = false;
                for (String item : notUpToDates) {
                    files.append(item);
                }
                this.env.err.println(this.getArtifactId() + " not up-to-date because " + count + " source files are not up-to-date (" + files + ")");
            }
            return false;
        }
        long lastModified2 = this.updateRecursively(new File(source.getParentFile(), "resources"), this.target, true);
        if (lastModified < lastModified2) {
            lastModified = lastModified2;
        }
        if (includingJar && (!(jar = this.getTarget()).exists() || jar.lastModified() < lastModified)) {
            if (this.env.verbose) {
                this.env.err.println(this.getArtifactId() + " not up-to-date because " + jar + " is not up-to-date");
            }
            return false;
        }
        return true;
    }

    public File getSourceDirectory() {
        String sourcePath = this.getSourcePath();
        File file = new File(sourcePath);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.directory, sourcePath);
    }

    public String getSourcePath() {
        return this.expand(this.sourceDirectory);
    }

    protected void addToJarRecursively(JarOutputStream out, File directory, String prefix) throws IOException {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        for (File file : list) {
            if (file.isFile()) {
                if (file.getAbsolutePath().endsWith("/Fiji_Updater/target/classes/META-INF/maven/sc.fiji/Fiji_Updater/pom.properties")) continue;
                out.putNextEntry(new ZipEntry(prefix + file.getName()));
                BuildEnvironment.copy(new FileInputStream(file), out, false);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.addToJarRecursively(out, file, prefix + file.getName() + "/");
        }
    }

    public void buildAndInstall() throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        String ijDirProperty = this.expand(this.getProperty("imagej.app.directory"));
        if (ijDirProperty == null) {
            throw new IOException("imagej.app.directory does not point to an ImageJ.app/ directory!");
        }
        this.buildAndInstall(new File(ijDirProperty), false);
    }

    public void buildAndInstall(File ijDir) throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        this.buildAndInstall(ijDir, false);
    }

    public void buildAndInstall(File ijDir, boolean forceBuild) throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        if ("pom".equals(this.getPackaging())) {
            this.env.err.println("Looking at children of " + this.getArtifactId());
            for (MavenProject child : this.getChildren()) {
                if (child == null) continue;
                child.buildAndInstall(ijDir, forceBuild);
            }
            Set<MavenProject> dependencies = this.getDependencies(true, false, "test", "provided", "system");
            if (dependencies != null && dependencies.size() > 0) {
                for (MavenProject project : this.getDependencies(true, false, "test", "provided", "system")) {
                    project.copyToImageJAppDirectory(ijDir, true);
                }
            }
            return;
        }
        this.build(true, forceBuild);
        for (MavenProject project : this.getDependencies(true, false, "test", "provided", "system")) {
            project.copyToImageJAppDirectory(ijDir, true);
        }
        this.copyToImageJAppDirectory(ijDir, true);
    }

    public void buildJar() throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        this.build(true, false);
    }

    public void build() throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        this.build(false);
    }

    public void build(boolean makeJar) throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        this.build(makeJar, false);
    }

    public void build(boolean makeJar, boolean forceBuild) throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        this.build(makeJar, forceBuild, false);
    }

    public void build(boolean makeJar, boolean forceBuild, boolean includeSources) throws JavaCompiler.CompileError, IOException, ParserConfigurationException, SAXException {
        if (!forceBuild && this.upToDate(makeJar)) {
            return;
        }
        if (!this.buildFromSource || this.built) {
            return;
        }
        boolean forceFullBuild = false;
        for (MavenProject child : this.getDependencies(true, this.env.downloadAutomatically, "test")) {
            if (child == null || child.upToDate(makeJar)) continue;
            child.build(makeJar);
            forceFullBuild = true;
        }
        File source = this.getSourceDirectory();
        File resources = new File(source.getParentFile(), "resources");
        if (!source.exists() && !resources.exists()) {
            return;
        }
        this.target.mkdirs();
        ArrayList<String> arguments = new ArrayList<String>();
        String classPath = this.getClassPath(true);
        MavenProject pom2 = this;
        while (pom2 != null && pom2.sourceVersion == null) {
            pom2 = pom2.parent;
        }
        if (pom2 != null) {
            arguments.add("-source");
            arguments.add(pom2.sourceVersion);
        }
        pom2 = this;
        while (pom2 != null && pom2.targetVersion == null) {
            pom2 = pom2.parent;
        }
        if (pom2 != null) {
            arguments.add("-target");
            arguments.add(pom2.targetVersion);
        }
        arguments.add("-classpath");
        arguments.add(classPath);
        arguments.add("-d");
        arguments.add(this.target.getPath());
        int count = arguments.size();
        this.addRecursively(arguments, source, ".java", this.target, ".class", !forceFullBuild);
        count = arguments.size() - count;
        if (count > 0) {
            this.env.err.println("Compiling " + count + " file" + (count > 1 ? "s" : "") + " in " + this.directory);
            if (this.env.verbose) {
                this.env.err.println(((Object)arguments).toString());
                this.env.err.println("using the class path: " + classPath);
            }
            String[] array = arguments.toArray(new String[arguments.size()]);
            if (this.env.javac != null) {
                this.env.javac.call(array, this.env.verbose, this.env.debug);
            }
        }
        this.updateRecursively(resources, this.target, false);
        File pom = new File(this.directory, "pom.xml");
        if (pom.exists()) {
            File targetFile = new File(this.target, "META-INF/maven/" + this.coordinate.groupId + "/" + this.coordinate.artifactId + "/pom.xml");
            targetFile.getParentFile().mkdirs();
            BuildEnvironment.copyFile(pom, targetFile);
        }
        String manifestClassPath = this.getManifestClassPath();
        File file = new File(this.target, "META-INF/MANIFEST.MF");
        Manifest manifest = null;
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            manifest = new Manifest(in);
            ((InputStream)in).close();
        } else {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            file.getParentFile().mkdirs();
        }
        Attributes main = manifest.getMainAttributes();
        if (this.mainClass != null) {
            main.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (manifestClassPath != null) {
            main.put(Attributes.Name.CLASS_PATH, manifestClassPath);
        }
        main.put(CREATED_BY, "MiniMaven");
        if (this.includeImplementationBuild && !this.getArtifactId().equals("Fiji_Updater")) {
            main.put(new Attributes.Name("Implementation-Build"), this.env.getImplementationBuild(this.directory));
        }
        FileOutputStream manifestOut = new FileOutputStream(file);
        manifest.write(manifestOut);
        ((OutputStream)manifestOut).close();
        if (makeJar) {
            FileOutputStream jarOut = new FileOutputStream(this.getTarget());
            JarOutputStream out = new JarOutputStream(jarOut);
            this.addToJarRecursively(out, this.target, "");
            if (includeSources) {
                if (pom.exists()) {
                    out.putNextEntry(new ZipEntry("pom.xml"));
                    BuildEnvironment.copy(new FileInputStream(pom), out, false);
                }
                this.addToJarRecursively(out, source, "src/main/java/");
                this.addToJarRecursively(out, resources, "src/main/resources/");
            }
            out.close();
            ((OutputStream)jarOut).close();
        }
        this.built = true;
    }

    protected long addRecursively(List<String> list, File directory, String extension, File targetDirectory, String targetExtension, boolean includeUpToDates) {
        long lastModified = 0L;
        if (list == null) {
            return lastModified;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return lastModified;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                long lastModified2 = this.addRecursively(list, file, extension, new File(targetDirectory, file.getName()), targetExtension, includeUpToDates);
                if (lastModified >= lastModified2) continue;
                lastModified = lastModified2;
                continue;
            }
            String name = file.getName();
            if (!name.endsWith(extension) || name.equals("package-info.java")) continue;
            File targetFile = new File(targetDirectory, name.substring(0, name.length() - extension.length()) + targetExtension);
            long lastModified2 = file.lastModified();
            if (lastModified < lastModified2) {
                lastModified = lastModified2;
            }
            if (!includeUpToDates && targetFile.exists() && targetFile.lastModified() >= lastModified2) continue;
            list.add(file.getPath());
        }
        return lastModified;
    }

    protected long updateRecursively(File source, File target, boolean dryRun) throws IOException {
        long lastModified = 0L;
        File[] list = source.listFiles();
        if (list == null) {
            return lastModified;
        }
        for (File file : list) {
            long lastModified2;
            File targetFile = new File(target, file.getName());
            if (file.isDirectory()) {
                lastModified2 = this.updateRecursively(file, targetFile, dryRun);
                if (lastModified >= lastModified2) continue;
                lastModified = lastModified2;
                continue;
            }
            if (!file.isFile()) continue;
            lastModified2 = file.lastModified();
            if (lastModified < lastModified2) {
                lastModified = lastModified2;
            }
            if (dryRun || targetFile.exists() && targetFile.lastModified() >= lastModified2) continue;
            targetFile.getParentFile().mkdirs();
            BuildEnvironment.copyFile(file, targetFile);
        }
        return lastModified;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public String getGAV() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + ":" + this.getPackaging();
    }

    public String getGroupId() {
        return this.coordinate.groupId;
    }

    public String getArtifactId() {
        return this.coordinate.artifactId;
    }

    public String getVersion() {
        return this.coordinate.version;
    }

    public String getJarName() {
        return this.coordinate.getJarName();
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean isJAR() {
        return "jar".equals(this.getPackaging()) || "bundle".equals(this.getPackaging());
    }

    public File getTarget() {
        if (!this.buildFromSource) {
            return this.target;
        }
        return new File(new File(this.directory, "target"), this.getJarName());
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean getBuildFromSource() {
        return this.buildFromSource;
    }

    public String getClassPath(boolean forCompile) throws IOException, ParserConfigurationException, SAXException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.target);
        if (this.env.debug) {
            this.env.err.println("Get classpath for " + this.coordinate + " for " + (forCompile ? "compile" : "runtime"));
        }
        for (MavenProject pom : this.getDependencies(true, this.env.downloadAutomatically, "test", forCompile ? "runtime" : "provided")) {
            if (this.env.debug) {
                this.env.err.println("Adding dependency " + pom.coordinate + " to classpath");
            }
            builder.append(File.pathSeparator).append(pom.getTarget());
        }
        return builder.toString();
    }

    private String getManifestClassPath() throws IOException, ParserConfigurationException, SAXException {
        StringBuilder builder = new StringBuilder();
        for (MavenProject pom : this.getDependencies(true, this.env.downloadAutomatically, "test", "provided")) {
            if (!pom.isJAR()) continue;
            builder.append(" ").append(pom.getArtifactId() + "-" + pom.coordinate.version + ".jar");
        }
        if (builder.length() == 0) {
            return null;
        }
        builder.delete(0, 1);
        return builder.toString();
    }

    private final void deleteVersions(File directory, String filename, File excluding) {
        File[] versioned = FileUtils.getAllVersions((File)directory, (String)filename);
        if (versioned == null) {
            return;
        }
        for (File file : versioned) {
            if (file.equals(excluding)) continue;
            if (!file.getName().equals(filename)) {
                this.env.err.println("Warning: deleting '" + file + "'");
            }
            if (file.delete()) continue;
            this.env.err.println("Warning: could not delete '" + file + "'");
        }
    }

    private void copyToImageJAppDirectory(File ijDir, boolean deleteOtherVersions) throws IOException {
        if ("pom".equals(this.getPackaging())) {
            return;
        }
        File source = this.getTarget();
        if (!source.exists()) {
            if ("imglib-tests".equals(this.getArtifactId())) {
                return;
            }
            if ("imglib2-tests".equals(this.getArtifactId())) {
                return;
            }
            throw new IOException("Artifact does not exist: " + source);
        }
        File targetDir = new File(ijDir, MavenProject.getTargetDirectory(source));
        File target = new File(targetDir, this.getArtifactId() + ("Fiji_Updater".equals(this.getArtifactId()) ? "" : "-" + this.getVersion()) + (this.coordinate.classifier == null ? "" : "-" + this.coordinate.classifier) + ".jar");
        if (!targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Could not make directory " + targetDir);
            }
        } else if (target.exists() && target.lastModified() >= source.lastModified()) {
            if (deleteOtherVersions) {
                this.deleteVersions(targetDir, target.getName(), target);
            }
            return;
        }
        if (deleteOtherVersions) {
            this.deleteVersions(targetDir, target.getName(), null);
        }
        BuildEnvironment.copyFile(source, target);
    }

    private static String getTargetDirectory(File source) {
        if (MavenProject.isImageJ1Plugin(source)) {
            return "plugins";
        }
        String name = source.getName();
        if (source.toURI().toString().contains("/ome/") || (name.startsWith("scifio-4.4.") || name.startsWith("jai_imageio-4.4.")) && source.getAbsolutePath().contains("loci")) {
            return "jars/bio-formats";
        }
        return "jars";
    }

    private static boolean isImageJ1Plugin(File file) {
        String name = file.getName();
        if (name.indexOf(95) < 0 || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return new File(file, "src/main/resources/plugins.config").exists();
        }
        if (name.endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(file);
                for (JarEntry entry : Collections.list(jar.entries())) {
                    if (!entry.getName().equals("plugins.config")) continue;
                    jar.close();
                    return true;
                }
                jar.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void copyDependencies(File directory, boolean onlyNewer) throws IOException, ParserConfigurationException, SAXException {
        for (MavenProject pom : this.getDependencies(true, this.env.downloadAutomatically, "test", "provided")) {
            File file = pom.getTarget();
            File destination = new File(directory, pom.coordinate.artifactId + ".jar");
            if (!file.exists() || onlyNewer && destination.exists() && destination.lastModified() >= file.lastModified()) continue;
            BuildEnvironment.copyFile(file, destination);
        }
    }

    public Set<MavenProject> getDependencies() throws IOException, ParserConfigurationException, SAXException {
        return this.getDependencies(false, this.env.downloadAutomatically, new String[0]);
    }

    public Set<MavenProject> getDependencies(boolean excludeOptionals, boolean downloadAutomatically, String ... excludeScopes) throws IOException, ParserConfigurationException, SAXException {
        TreeSet<MavenProject> set = new TreeSet<MavenProject>();
        this.getDependencies(set, excludeOptionals, downloadAutomatically, null, excludeScopes);
        return set;
    }

    public void getDependencies(Set<MavenProject> result, boolean excludeOptionals, boolean downloadAutomatically, Set<String> exclusions, String ... excludeScopes) throws IOException, ParserConfigurationException, SAXException {
        exclusions = exclusions != null ? new LinkedHashSet<String>(exclusions) : new LinkedHashSet<String>();
        for (Coordinate dependency : this.dependencies) {
            File file;
            String scope;
            if (excludeOptionals && dependency.optional || (scope = this.expand(dependency.scope)) != null && excludeScopes != null && this.arrayContainsString(excludeScopes, scope)) continue;
            Coordinate expanded = this.expand(dependency);
            if (exclusions.size() > 0 && exclusions.contains(expanded.getGroupId() + ":" + expanded.getArtifactId())) continue;
            this.addExclusions(exclusions, expanded);
            MavenProject pom = this.findPOM(expanded, !this.env.verbose, false);
            String systemPath = this.expand(dependency.systemPath);
            if (pom == null && systemPath != null && (file = new File(systemPath)).exists()) {
                result.add(this.env.fakePOM(file, expanded));
                continue;
            }
            if (!this.env.offlineMode && downloadAutomatically && pom != null && pom.coordinate.version != null && (pom.coordinate.version.startsWith("[") || pom.coordinate.version.endsWith("-SNAPSHOT")) && pom.directory.getPath().startsWith(BuildEnvironment.mavenRepository.getPath()) && this.maybeDownloadAutomatically(pom.coordinate, !this.env.verbose, downloadAutomatically)) {
                if (pom.coordinate.version.startsWith("[")) {
                    pom.coordinate.setSnapshotVersion(VersionPOMHandler.parse(new File(pom.directory.getParentFile(), "maven-metadata-version.xml")));
                } else {
                    pom.coordinate.setSnapshotVersion(SnapshotPOMHandler.parse(new File(pom.directory, "maven-metadata-snapshot.xml")));
                }
                dependency.setSnapshotVersion(pom.coordinate.getVersion());
            }
            if (pom == null && downloadAutomatically) {
                try {
                    pom = this.findPOM(expanded, !this.env.verbose, downloadAutomatically);
                }
                catch (IOException e) {
                    this.env.err.println("Failed to download dependency " + expanded.artifactId + " of " + this.getArtifactId());
                    throw e;
                }
            }
            if (pom == null || result.contains(pom)) continue;
            result.add(pom);
            try {
                pom.getDependencies(result, this.env.downloadAutomatically, excludeOptionals, exclusions, excludeScopes);
            }
            catch (IOException e) {
                this.env.err.println("Problems downloading the dependencies of " + this.getArtifactId());
                throw e;
            }
        }
    }

    private void addExclusions(final Set<String> exclusions, Coordinate dependency) {
        if (dependency.exclusions != null) {
            exclusions.addAll(dependency.exclusions);
        }
        final String groupId = dependency.getGroupId();
        final String artifactId = dependency.getArtifactId();
        this.queryDependencyManagement(new DependencyManagementCallback(){

            @Override
            public boolean coordinate(MavenProject project, Coordinate coordinate) {
                if (coordinate.exclusions != null && groupId.equals(project.expand(coordinate.groupId)) && artifactId.equals(project.expand(coordinate.artifactId))) {
                    exclusions.addAll(coordinate.exclusions);
                }
                return false;
            }
        });
    }

    public List<Coordinate> getDirectDependencies() {
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        for (Coordinate coordinate : this.dependencies) {
            result.add(this.expand(coordinate));
        }
        return result;
    }

    protected boolean arrayContainsString(String[] array, String key) {
        for (String string : array) {
            if (!string.equals(key)) continue;
            return true;
        }
        return false;
    }

    public Coordinate expand(Coordinate dependency) {
        boolean optional = dependency.optional;
        String scope = this.expand(dependency.scope);
        String groupId = this.expand(dependency.groupId);
        String artifactId = this.expand(dependency.artifactId);
        String version = this.expand(dependency.version);
        String classifier = this.expand(dependency.classifier);
        String systemPath = this.expand(dependency.systemPath);
        Set<String> exclusions = dependency.exclusions;
        if (version == null) {
            version = this.findVersion(groupId, artifactId);
        }
        return new Coordinate(groupId, artifactId, version, scope, optional, systemPath, classifier, exclusions);
    }

    private String findVersion(final String groupId, final String artifactId) {
        if (groupId == null || artifactId == null) {
            return null;
        }
        final String[] result = new String[]{null};
        this.queryDependencyManagement(new DependencyManagementCallback(){

            @Override
            public boolean coordinate(MavenProject project, Coordinate coordinate) {
                if (coordinate == null || coordinate.version == null || !groupId.equals(project.expand(coordinate.groupId)) || !artifactId.equals(project.expand(coordinate.artifactId))) {
                    return false;
                }
                result[0] = project.expand(coordinate.version);
                return true;
            }
        });
        return result[0];
    }

    private void queryDependencyManagement(DependencyManagementCallback callback) {
        for (Coordinate dependency : this.dependencyManagement) {
            if (!callback.coordinate(this, dependency)) continue;
            return;
        }
        MavenProject parent = this.parent;
        while (parent != null) {
            for (Coordinate dependency : parent.dependencies) {
                if (!callback.coordinate(parent, dependency)) continue;
                return;
            }
            for (Coordinate dependency : parent.dependencyManagement) {
                if (!callback.coordinate(parent, dependency)) continue;
                return;
            }
            parent = parent.parent;
        }
    }

    public String expand(String string) {
        if (string == null) {
            return null;
        }
        String result = string;
        int dollarCurly;
        while ((dollarCurly = result.indexOf("${")) >= 0) {
            int endCurly = result.indexOf("}", dollarCurly + 2);
            if (endCurly < 0) {
                throw new RuntimeException("Invalid string: " + string);
            }
            String property = this.getProperty(result.substring(dollarCurly + 2, endCurly));
            if (property == null) {
                if (dollarCurly == 0 && endCurly == result.length() - 1) {
                    return null;
                }
                property = "";
            }
            result = result.substring(0, dollarCurly) + property + result.substring(endCurly + 1);
        }
        return result;
    }

    public String getProperty(String key) {
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        if (key.equals("project.basedir")) {
            return this.directory.getPath();
        }
        if (key.equals("rootdir")) {
            File directory = this.directory;
            while (true) {
                File parent;
                if ((parent = directory.getParentFile()) == null || !new File(parent, "pom.xml").exists()) {
                    return directory.getPath();
                }
                directory = parent;
            }
        }
        if (this.parent == null) {
            if (key.equals("bio-formats.groupId")) {
                return "loci";
            }
            if (key.equals("bio-formats.version")) {
                return "4.4-SNAPSHOT";
            }
            if (key.equals("imagej.groupId")) {
                return "net.imagej";
            }
            return null;
        }
        return this.parent.getProperty(key);
    }

    public MavenProject getParent() {
        return this.parent;
    }

    public MavenProject[] getChildren() {
        if (this.children == null) {
            return new MavenProject[0];
        }
        return this.children;
    }

    public MavenProject getRoot() {
        MavenProject result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    protected Set<String> getRepositories() {
        TreeSet<String> result = new TreeSet<String>();
        this.getRepositories(result);
        return result;
    }

    protected void getRepositories(Set<String> result) {
        if (this.parent == null) {
            result.add("http://maven.imagej.net/service/local/repo_groups/public/content/");
            result.add("http://repo1.maven.org/maven2/");
        }
        result.addAll(this.repositories);
        for (MavenProject child : this.getChildren()) {
            if (child == null) continue;
            child.getRepositories(result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MavenProject findPOM(Coordinate dependency, boolean quiet, boolean downloadAutomatically) throws IOException, ParserConfigurationException, SAXException {
        MavenProject result;
        File file;
        String path;
        String key;
        block45: {
            MavenProject pom;
            if (dependency.version == null && "aopalliance".equals(dependency.artifactId)) {
                dependency.version = "1.0";
            }
            if (dependency.version == null && "provided".equals(dependency.scope)) {
                return null;
            }
            if (dependency.groupId == null && dependency.artifactId != null) {
                if (dependency.artifactId.matches("scijava-common|minimaven")) {
                    dependency.groupId = "org.scijava";
                } else if (dependency.artifactId.matches("imglib2.*")) {
                    dependency.groupId = "net.imglib2";
                } else if (dependency.artifactId.matches("scifio")) {
                    dependency.groupId = "io.scif";
                } else if (dependency.artifactId.matches("jama")) {
                    dependency.groupId = "gov.nist.math";
                } else if (dependency.artifactId.matches("jpedalSTD")) {
                    dependency.groupId = "org.jpedal";
                } else if (dependency.artifactId.equals("jep")) {
                    dependency.groupId = "org.scijava";
                }
            }
            if (dependency.groupId == null) {
                throw new IllegalArgumentException("Need fully qualified GAVs: " + dependency.getGAV());
            }
            if (dependency.artifactId.equals(this.expand(this.coordinate.artifactId)) && dependency.groupId.equals(this.expand(this.coordinate.groupId)) && dependency.version.equals(this.expand(this.coordinate.version))) {
                return this;
            }
            key = dependency.getKey();
            if (this.env.localPOMCache.containsKey(key)) {
                MavenProject result2 = this.env.localPOMCache.get(key);
                if (result2 == null) return result2;
                if (BuildEnvironment.compareVersion(dependency.getVersion(), result2.coordinate.getVersion()) <= 0) {
                    return result2;
                }
            }
            if ((pom = this.findInMultiProjects(dependency)) != null) {
                return pom;
            }
            if (this.env.ignoreMavenRepositories) {
                if (quiet) return this.cacheAndReturn(key, null);
                if (dependency.optional) return this.cacheAndReturn(key, null);
                this.env.err.println("Skipping artifact " + dependency.artifactId + " (for " + this.coordinate.artifactId + "): not in jars/ nor plugins/");
                return this.cacheAndReturn(key, null);
            }
            path = BuildEnvironment.mavenRepository.getPath() + "/" + dependency.groupId.replace('.', '/') + "/" + dependency.artifactId + "/";
            if (dependency.version == null) {
                this.env.err.println("Skipping invalid dependency (version unset): " + dependency);
                return null;
            }
            if (dependency.version.startsWith("[") && dependency.snapshotVersion == null) {
                try {
                    if (!this.maybeDownloadAutomatically(dependency, quiet, downloadAutomatically)) {
                        return null;
                    }
                    if (dependency.version.startsWith("[")) {
                        dependency.snapshotVersion = VersionPOMHandler.parse(new File(path, "maven-metadata-version.xml"));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            path = path + (dependency.version.endsWith("-SNAPSHOT") ? dependency.version : dependency.getVersion()) + "/";
            if (dependency.version.endsWith("-SNAPSHOT")) {
                try {
                    if (!this.maybeDownloadAutomatically(dependency, quiet, downloadAutomatically)) {
                        return null;
                    }
                    if (!dependency.version.endsWith("-SNAPSHOT")) break block45;
                    File xml = new File(path, "maven-metadata-snapshot.xml");
                    if (this.env.verbose) {
                        this.env.err.println("Parsing " + xml);
                    }
                    if (xml.exists()) {
                        try {
                            dependency.setSnapshotVersion(SnapshotPOMHandler.parse(xml));
                        }
                        catch (SAXException e) {
                            this.env.err.println("[WARNING] problem parsing " + xml);
                            e.printStackTrace(this.env.err);
                        }
                    } else {
                        File xml2 = new File(path, "maven-metadata-imagej.snapshots.xml");
                        if (this.env.verbose) {
                            this.env.err.println("Parsing " + xml2);
                        }
                        dependency.setSnapshotVersion(SnapshotPOMHandler.parse(xml2));
                    }
                }
                catch (FileNotFoundException xml) {
                    // empty catch block
                }
            }
        }
        if (!(file = new File(path, dependency.getPOMName())).exists()) {
            if (downloadAutomatically) {
                if (!this.maybeDownloadAutomatically(dependency, quiet, downloadAutomatically)) {
                    return null;
                }
            } else {
                if (!(quiet || dependency.optional || "system".equals(dependency.scope))) {
                    this.env.err.println("Skipping artifact " + dependency.getGAV() + " (for " + this.coordinate.getGAV() + "): not found");
                }
                if (downloadAutomatically) return this.cacheAndReturn(key, null);
                if (!this.env.downloadAutomatically) return this.cacheAndReturn(key, null);
                return null;
            }
        }
        if ((result = this.env.parse(new File(path, dependency.getPOMName()), null, dependency.classifier)) != null) {
            if (result.target.getName().endsWith("-SNAPSHOT.jar")) {
                result.coordinate.version = dependency.version;
                result.target = new File(result.directory, dependency.getJarName());
            }
            if (result.parent == null) {
                result.parent = this.getRoot();
            }
            if (!result.isJAR()) return result;
            if (new File(path, dependency.getJarName()).exists()) return result;
            if (downloadAutomatically) {
                this.download(dependency, quiet);
                return result;
            }
            this.env.localPOMCache.remove(key);
            return null;
        }
        if (quiet) return result;
        if (dependency.optional) return result;
        this.env.err.println("Artifact " + dependency.artifactId + " not found" + (downloadAutomatically ? "" : "; consider 'get-dependencies'"));
        return result;
    }

    protected MavenProject findInMultiProjects(Coordinate dependency) throws IOException, ParserConfigurationException, SAXException {
        this.env.parseMultiProjects();
        String key = dependency.getKey();
        MavenProject result = this.env.localPOMCache.get(key);
        if (result != null && BuildEnvironment.compareVersion(dependency.getVersion(), result.coordinate.getVersion()) <= 0) {
            return result;
        }
        return null;
    }

    protected MavenProject cacheAndReturn(String key, MavenProject pom) {
        this.env.localPOMCache.put(key, pom);
        return pom;
    }

    protected boolean maybeDownloadAutomatically(Coordinate dependency, boolean quiet, boolean downloadAutomatically) {
        if (!downloadAutomatically || this.env.offlineMode) {
            return true;
        }
        try {
            this.download(dependency, quiet);
        }
        catch (Exception e) {
            if (!quiet && !dependency.optional) {
                e.printStackTrace(this.env.err);
                this.env.err.println("Could not download " + dependency.artifactId + ": " + e.getMessage());
            }
            String key = dependency.getKey();
            this.env.localPOMCache.put(key, null);
            return false;
        }
        return true;
    }

    protected String findLocallyCachedVersion(String path) throws IOException {
        String line;
        int tag;
        File file = new File(path, "maven-metadata-local.xml");
        if (!file.exists()) {
            String[] list = new File(path).list();
            return list != null && list.length > 0 ? list[0] : null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        do {
            if ((line = reader.readLine()) != null) continue;
            reader.close();
            throw new RuntimeException("Could not determine version for " + path);
        } while ((tag = line.indexOf("<version>")) < 0);
        reader.close();
        int endTag = line.indexOf("</version>");
        return line.substring(tag + "<version>".length(), endTag);
    }

    protected void checkParentTag(String tag, String string1, String string2) {
        if (!this.env.debug) {
            return;
        }
        String expanded1 = this.expand(string1);
        String expanded2 = this.expand(string2);
        if (expanded1 == null && expanded2 != null || expanded1 != null && !expanded1.equals(expanded2)) {
            this.env.err.println("Warning: " + tag + " mismatch in " + this.directory + "'s parent: " + string1 + " != " + string2);
        }
    }

    @Override
    public int compareTo(MavenProject other) {
        int result = this.coordinate.artifactId.compareTo(other.coordinate.artifactId);
        if (result != 0) {
            return result;
        }
        if (this.coordinate.groupId != null && other.coordinate.groupId != null) {
            result = this.coordinate.groupId.compareTo(other.coordinate.groupId);
        }
        if (result != 0) {
            return result;
        }
        result = BuildEnvironment.compareVersion(this.coordinate.getVersion(), other.coordinate.getVersion());
        if (result != 0) {
            return result;
        }
        if (this.coordinate.classifier == null) {
            if (other.coordinate.classifier != null) {
                return -1;
            }
        } else {
            if (other.coordinate.classifier == null) {
                return 1;
            }
            result = this.coordinate.classifier.compareTo(other.coordinate.classifier);
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof MavenProject) {
            return this.compareTo((MavenProject)other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.coordinate.getKey().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        builder.append(indent + this.coordinate.getKey() + "\n");
        if (this.children != null) {
            for (MavenProject child : this.getChildren()) {
                if (child == null) {
                    builder.append(indent).append("  (null)\n");
                    continue;
                }
                child.append(builder, indent + "  ");
            }
        }
    }

    void parse(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setContentHandler(new XMLHandler());
        reader.parse(new InputSource(in));
        in.close();
    }

    private class XMLHandler
    extends AbstractPOMHandler {
        protected String prefix = "";
        protected Coordinate latestDependency = new Coordinate();
        protected boolean isCurrentProfile;
        protected String currentPluginName;
        private Coordinate latestExclusion = new Coordinate();

        private XMLHandler() {
        }

        @Override
        public void endDocument() {
            if (!MavenProject.this.properties.containsKey("project.groupId")) {
                MavenProject.this.properties.put("project.groupId", MavenProject.this.coordinate.groupId);
            }
            if (!MavenProject.this.properties.containsKey("project.version")) {
                MavenProject.this.properties.put("project.version", MavenProject.this.coordinate.getVersion());
            }
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, org.xml.sax.Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.prefix = this.prefix + ">" + qualifiedName;
            if (MavenProject.this.env.debug) {
                MavenProject.this.env.err.println("start(" + uri + ", " + name + ", " + qualifiedName + ", " + this.toString(attributes) + ")");
            }
        }

        @Override
        public void endElement(String uri, String name, String qualifiedName) throws SAXException {
            super.endElement(uri, name, qualifiedName);
            if (this.prefix.equals(">project>dependencies>dependency") || this.isCurrentProfile && this.prefix.equals(">project>profiles>profile>dependencies>dependency")) {
                if (MavenProject.this.env.debug) {
                    MavenProject.this.env.err.println("Adding dependendency " + this.latestDependency + " to " + this);
                }
                if (MavenProject.this.coordinate.artifactId.equals("javassist") && this.latestDependency.artifactId.equals("tools")) {
                    this.latestDependency.optional = false;
                }
                MavenProject.this.dependencies.add(this.latestDependency);
                this.latestDependency = new Coordinate();
            } else if (this.prefix.equals(">project>dependencyManagement>dependencies>dependency") || this.isCurrentProfile && this.prefix.equals(">project>profiles>profile>dependencyManagement>dependencies>dependency")) {
                if (MavenProject.this.env.debug) {
                    MavenProject.this.env.err.println("Adding dependendency " + this.latestDependency + " to " + this);
                }
                MavenProject.this.dependencyManagement.add(this.latestDependency);
                this.latestDependency = new Coordinate();
            } else if (this.prefix.equals(">project>dependencies>dependency>exclusions>exclusion") || this.isCurrentProfile && this.prefix.equals(">project>profiles>profile>dependencies>dependency>exclusions>exclusion")) {
                if (this.latestDependency.exclusions == null) {
                    this.latestDependency.exclusions = new HashSet<String>();
                }
                String groupId = this.latestExclusion.getGroupId();
                String artifactId = this.latestExclusion.getArtifactId();
                if (groupId != null && artifactId != null) {
                    this.latestDependency.exclusions.add(groupId + ":" + artifactId);
                }
                this.latestExclusion = new Coordinate();
            } else if (this.prefix.equals(">project>profiles>profile")) {
                this.isCurrentProfile = false;
            }
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1 - qualifiedName.length());
            if (MavenProject.this.env.debug) {
                MavenProject.this.env.err.println("end(" + uri + ", " + name + ", " + qualifiedName + ")");
            }
        }

        @Override
        protected void processCharacters(StringBuilder sb) {
            String string = sb.toString();
            if (MavenProject.this.env.debug) {
                MavenProject.this.env.err.println("characters: " + string + " (prefix: " + this.prefix + ")");
            }
            String prefix = this.prefix;
            if (this.isCurrentProfile) {
                prefix = ">project" + prefix.substring(">project>profiles>profile".length());
            }
            if (prefix.equals(">project>groupId")) {
                MavenProject.this.coordinate.groupId = string;
            } else if (prefix.equals(">project>artifactId")) {
                MavenProject.this.coordinate.artifactId = string;
            } else if (prefix.equals(">project>version")) {
                MavenProject.this.coordinate.version = string;
            } else if (prefix.equals(">project>packaging")) {
                MavenProject.this.packaging = string;
            } else if (prefix.equals(">project>modules")) {
                MavenProject.this.buildFromSource = true;
            } else if (prefix.equals(">project>modules>module")) {
                MavenProject.this.modules.add(string);
            } else if (prefix.startsWith(">project>properties>")) {
                MavenProject.this.properties.put(prefix.substring(">project>properties>".length()), string);
            } else if (prefix.equals(">project>dependencies>dependency>groupId") || prefix.equals(">project>dependencyManagement>dependencies>dependency>groupId")) {
                this.latestDependency.groupId = string;
            } else if (prefix.equals(">project>dependencies>dependency>artifactId") || prefix.equals(">project>dependencyManagement>dependencies>dependency>artifactId")) {
                this.latestDependency.artifactId = string;
            } else if (prefix.equals(">project>dependencies>dependency>version") || prefix.equals(">project>dependencyManagement>dependencies>dependency>version")) {
                this.latestDependency.version = string;
            } else if (prefix.equals(">project>dependencies>dependency>scope") || prefix.equals(">project>dependencyManagement>dependencies>dependency>scope")) {
                this.latestDependency.scope = string;
            } else if (prefix.equals(">project>dependencies>dependency>optional") || prefix.equals(">project>dependencyManagement>dependencies>dependency>optional")) {
                this.latestDependency.optional = string.equalsIgnoreCase("true");
            } else if (prefix.equals(">project>dependencies>dependency>systemPath") || prefix.equals(">project>dependencyManagement>dependencies>dependency>systemPath")) {
                this.latestDependency.systemPath = string;
            } else if (prefix.equals(">project>dependencies>dependency>classifier") || prefix.equals(">project>dependencyManagement>dependencies>dependency>classifier")) {
                this.latestDependency.classifier = string;
            } else if (prefix.equals(">project>dependencies>dependency>exclusions>exclusion>groupId")) {
                this.latestExclusion.groupId = string;
            } else if (prefix.equals(">project>dependencies>dependency>exclusions>exclusion>artifactId")) {
                this.latestExclusion.artifactId = string;
            } else if (prefix.equals(">project>profiles>profile>id")) {
                boolean bl = this.isCurrentProfile = !System.getProperty("os.name").equals("Mac OS X") && "javac".equals(string) || MavenProject.this.coordinate.artifactId.equals("javassist") && (string.equals("jdk16") || string.equals("default-tools"));
                if (MavenProject.this.env.debug) {
                    MavenProject.this.env.err.println((this.isCurrentProfile ? "Activating" : "Ignoring") + " profile " + string);
                }
            } else if (!this.isCurrentProfile && prefix.equals(">project>profiles>profile>activation>os>name")) {
                this.isCurrentProfile = string.equalsIgnoreCase(System.getProperty("os.name"));
            } else if (!this.isCurrentProfile && prefix.equals(">project>profiles>profile>activation>os>family")) {
                String osName = System.getProperty("os.name").toLowerCase();
                if (string.equalsIgnoreCase("windows")) {
                    this.isCurrentProfile = osName.startsWith("win");
                } else if (string.toLowerCase().startsWith("mac")) {
                    this.isCurrentProfile = osName.startsWith("mac");
                } else if (string.equalsIgnoreCase("unix")) {
                    this.isCurrentProfile = !osName.startsWith("win") && !osName.startsWith("mac");
                } else {
                    MavenProject.this.env.err.println("Ignoring unknown OS family: " + string);
                    this.isCurrentProfile = false;
                }
            } else if (!this.isCurrentProfile && prefix.equals(">project>profiles>profile>activation>file>exists")) {
                this.isCurrentProfile = new File(MavenProject.this.directory, string).exists();
            } else if (!this.isCurrentProfile && prefix.equals(">project>profiles>profile>activation>activeByDefault")) {
                this.isCurrentProfile = "true".equalsIgnoreCase(string);
            } else if (!this.isCurrentProfile && prefix.equals(">project>profiles>profile>activation>property>name")) {
                boolean negate = false;
                if (string.startsWith("!")) {
                    negate = true;
                    string = string.substring(1);
                }
                this.isCurrentProfile = negate ^ MavenProject.this.expand("${" + string + "}") != null;
            } else if (prefix.equals(">project>repositories>repository>url")) {
                MavenProject.this.repositories.add(string);
            } else if (prefix.equals(">project>build>sourceDirectory")) {
                MavenProject.this.sourceDirectory = string;
            } else if (prefix.startsWith(">project>parent>")) {
                if (MavenProject.this.parentCoordinate == null) {
                    MavenProject.this.parentCoordinate = new Coordinate();
                }
                if (prefix.equals(">project>parent>groupId")) {
                    if (MavenProject.this.coordinate.groupId == null) {
                        MavenProject.this.coordinate.groupId = string;
                    }
                    if (MavenProject.this.parentCoordinate.groupId == null) {
                        MavenProject.this.parentCoordinate.groupId = string;
                    } else {
                        MavenProject.this.checkParentTag("groupId", MavenProject.this.parentCoordinate.groupId, string);
                    }
                } else if (prefix.equals(">project>parent>artifactId")) {
                    if (MavenProject.this.parentCoordinate.artifactId == null) {
                        MavenProject.this.parentCoordinate.artifactId = string;
                    } else {
                        MavenProject.this.checkParentTag("artifactId", MavenProject.this.parentCoordinate.artifactId, string);
                    }
                } else if (prefix.equals(">project>parent>version")) {
                    if (MavenProject.this.coordinate.version == null) {
                        MavenProject.this.coordinate.version = string;
                    }
                    if (MavenProject.this.parentCoordinate.version == null) {
                        MavenProject.this.parentCoordinate.version = string;
                    } else {
                        MavenProject.this.checkParentTag("version", MavenProject.this.parentCoordinate.version, string);
                    }
                }
            } else if (prefix.equals(">project>build>plugins>plugin>artifactId")) {
                this.currentPluginName = string;
                if (string.equals("buildnumber-maven-plugin")) {
                    MavenProject.this.includeImplementationBuild = true;
                }
            } else if (prefix.equals(">project>build>plugins>plugin>configuration>source") && "maven-compiler-plugin".equals(this.currentPluginName)) {
                MavenProject.this.sourceVersion = string;
            } else if (prefix.equals(">project>build>plugins>plugin>configuration>target") && "maven-compiler-plugin".equals(this.currentPluginName)) {
                MavenProject.this.targetVersion = string;
            } else if (prefix.equals(">project>build>plugins>plugin>configuration>archive>manifest>mainClass") && "maven-jar-plugin".equals(this.currentPluginName)) {
                MavenProject.this.mainClass = string;
            } else if (MavenProject.this.env.debug) {
                MavenProject.this.env.err.println("Ignoring " + prefix);
            }
        }

        private String toString(org.xml.sax.Attributes attributes) {
            StringBuilder builder = new StringBuilder();
            builder.append("[ ");
            for (int i = 0; i < attributes.getLength(); ++i) {
                builder.append(attributes.getQName(i)).append("='").append(attributes.getValue(i)).append("' ");
            }
            builder.append("]");
            return builder.toString();
        }
    }

    private static interface DependencyManagementCallback {
        public boolean coordinate(MavenProject var1, Coordinate var2);
    }

    private static enum BooleanState {
        UNKNOWN,
        YES,
        NO;

    }
}

