/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.scijava.parse.Group;
import org.scijava.parse.Operator;

public final class Operators {
    public static final Operator DOT = Operators.op(".", 2, Operator.Associativity.LEFT, 16.0);
    public static final Group PARENS = Operators.group("(", ")", 16.0);
    public static final Group BRACKETS = Operators.group("[", "]", 16.0);
    public static final Group BRACES = Operators.group("{", "}", 16.0);
    public static final Operator TRANSPOSE = Operators.op("'", 1, Operator.Associativity.LEFT, 15.0);
    public static final Operator DOT_TRANSPOSE = Operators.op(".'", 1, Operator.Associativity.LEFT, 15.0);
    public static final Operator POW = Operators.op("^", 2, Operator.Associativity.RIGHT, 15.0);
    public static final Operator DOT_POW = Operators.op(".^", 2, Operator.Associativity.RIGHT, 15.0);
    public static final Operator POST_INC = Operators.op("++", 1, Operator.Associativity.LEFT, 14.0);
    public static final Operator POST_DEC = Operators.op("--", 1, Operator.Associativity.LEFT, 14.0);
    public static final Operator PRE_INC = Operators.op("++", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator PRE_DEC = Operators.op("--", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator POS = Operators.op("+", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator NEG = Operators.op("-", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator COMPLEMENT = Operators.op("~", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator NOT = Operators.op("!", 1, Operator.Associativity.RIGHT, 13.0);
    public static final Operator MUL = Operators.op("*", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator DIV = Operators.op("/", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator MOD = Operators.op("%", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator RIGHT_DIV = Operators.op("\\", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator DOT_MUL = Operators.op(".*", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator DOT_DIV = Operators.op("./", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator DOT_RIGHT_DIV = Operators.op(".\\", 2, Operator.Associativity.LEFT, 12.0);
    public static final Operator ADD = Operators.op("+", 2, Operator.Associativity.LEFT, 11.0);
    public static final Operator SUB = Operators.op("-", 2, Operator.Associativity.LEFT, 11.0);
    public static final Operator LEFT_SHIFT = Operators.op("<<", 2, Operator.Associativity.LEFT, 10.0);
    public static final Operator RIGHT_SHIFT = Operators.op(">>", 2, Operator.Associativity.LEFT, 10.0);
    public static final Operator UNSIGNED_RIGHT_SHIFT = Operators.op(">>>", 2, Operator.Associativity.LEFT, 10.0);
    public static final Operator COLON = Operators.op(":", 2, Operator.Associativity.LEFT, 9.0);
    public static final Operator LESS_THAN = Operators.op("<", 2, Operator.Associativity.LEFT, 8.0);
    public static final Operator GREATER_THAN = Operators.op(">", 2, Operator.Associativity.LEFT, 8.0);
    public static final Operator LESS_THAN_OR_EQUAL = Operators.op("<=", 2, Operator.Associativity.LEFT, 8.0);
    public static final Operator GREATER_THAN_OR_EQUAL = Operators.op(">=", 2, Operator.Associativity.LEFT, 8.0);
    public static final Operator INSTANCEOF = Operators.op("instanceof", 2, Operator.Associativity.LEFT, 8.0);
    public static final Operator EQUAL = Operators.op("==", 2, Operator.Associativity.LEFT, 7.0);
    public static final Operator NOT_EQUAL = Operators.op("!=", 2, Operator.Associativity.LEFT, 7.0);
    public static final Operator BITWISE_AND = Operators.op("&", 2, Operator.Associativity.LEFT, 6.0);
    public static final Operator BITWISE_OR = Operators.op("|", 2, Operator.Associativity.LEFT, 4.0);
    public static final Operator LOGICAL_AND = Operators.op("&&", 2, Operator.Associativity.LEFT, 3.0);
    public static final Operator LOGICAL_OR = Operators.op("||", 2, Operator.Associativity.LEFT, 2.0);
    public static final Operator ASSIGN = Operators.op("=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator POW_ASSIGN = Operators.op("^=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator DOT_POW_ASSIGN = Operators.op(".^=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator MUL_ASSIGN = Operators.op("*=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator DIV_ASSIGN = Operators.op("/=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator MOD_ASSIGN = Operators.op("%=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator RIGHT_DIV_ASSIGN = Operators.op("\\=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator DOT_DIV_ASSIGN = Operators.op("./=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator DOT_RIGHT_DIV_ASSIGN = Operators.op(".\\=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator ADD_ASSIGN = Operators.op("+=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator SUB_ASSIGN = Operators.op("-=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator AND_ASSIGN = Operators.op("&=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator OR_ASSIGN = Operators.op("|=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator LEFT_SHIFT_ASSIGN = Operators.op("<<=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator RIGHT_SHIFT_ASSIGN = Operators.op(">>=", 2, Operator.Associativity.RIGHT, 0.0);
    public static final Operator UNSIGNED_RIGHT_SHIFT_ASSIGN = Operators.op(">>>=", 2, Operator.Associativity.RIGHT, 0.0);

    private Operators() {
    }

    public static List<Operator> standardList() {
        ArrayList<Operator> ops = new ArrayList<Operator>();
        for (Field f : Operators.class.getFields()) {
            if (!Operators.isOperator(f)) continue;
            try {
                ops.add((Operator)f.get(null));
            }
            catch (IllegalAccessException exc) {
                throw new IllegalStateException(exc);
            }
        }
        return ops;
    }

    private static Operator op(String symbol, int arity, Operator.Associativity associativity, double precedence) {
        return new Operator(symbol, arity, associativity, precedence);
    }

    private static Group group(String leftSymbol, String rightSymbol, double precedence) {
        return new Group(leftSymbol, rightSymbol, precedence);
    }

    private static boolean isOperator(Field f) {
        int mods = f.getModifiers();
        return Modifier.isStatic(mods) && Modifier.isFinal(mods) && Operator.class.isAssignableFrom(f.getType());
    }
}

