/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.scijava.parse.Operator;
import org.scijava.parse.Tokens;

public class SyntaxTree
implements Iterable<SyntaxTree> {
    private final Object token;
    private SyntaxTree[] children;

    public SyntaxTree(LinkedList<Object> tokens) {
        Operator op;
        int arity;
        this.token = tokens.removeLast();
        if (Tokens.isOperator(this.token) && (arity = (op = (Operator)this.token).getArity()) > 0) {
            this.children = new SyntaxTree[arity];
            for (int i = this.children.length - 1; i >= 0; --i) {
                this.children[i] = new SyntaxTree(tokens);
            }
        }
    }

    public Object token() {
        return this.token;
    }

    public SyntaxTree child(int index) {
        return this.children[index];
    }

    public int count() {
        return this.children == null ? 0 : this.children.length;
    }

    public LinkedList<Object> postfix() {
        LinkedList<Object> queue = new LinkedList<Object>();
        this.postfix(queue);
        return queue;
    }

    public String toString() {
        return this.toString("");
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyntaxTree)) {
            return false;
        }
        SyntaxTree tree = (SyntaxTree)o;
        return this.token.equals(tree.token) && Arrays.equals(this.children, tree.children);
    }

    public int hashCode() {
        return this.token.hashCode() ^ this.children.hashCode();
    }

    @Override
    public Iterator<SyntaxTree> iterator() {
        return new Iterator<SyntaxTree>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < SyntaxTree.this.count();
            }

            @Override
            public SyntaxTree next() {
                return SyntaxTree.this.child(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void postfix(LinkedList<Object> queue) {
        for (SyntaxTree child : this) {
            child.postfix(queue);
        }
        queue.add(this.token());
    }

    private String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + " '" + this.token + "'\n");
        String deeperPrefix = " " + prefix + "-";
        for (int i = 0; i < this.count(); ++i) {
            sb.append(this.child(i).toString(deeperPrefix));
        }
        return sb.toString();
    }
}

