/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington.eval;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.scijava.parsington.ExpressionParser;
import org.scijava.parsington.Literals;
import org.scijava.parsington.Tokens;
import org.scijava.parsington.Variable;
import org.scijava.parsington.eval.AbstractStandardTreeEvaluator;

public class DefaultTreeEvaluator
extends AbstractStandardTreeEvaluator {
    public DefaultTreeEvaluator() {
    }

    public DefaultTreeEvaluator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public Object function(Object a, Object b) {
        String name;
        Object result;
        Object element = this.listElement(a, b);
        if (element != null) {
            return element;
        }
        if (Tokens.isVariable(a) && (result = this.callFunction(name = ((Variable)a).getToken(), b)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public Object dot(Object a, Object b) {
        return null;
    }

    @Override
    public Object parens(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return Arrays.asList(args);
    }

    @Override
    public Object brackets(Object[] args) {
        return Arrays.asList(args);
    }

    @Override
    public Object braces(Object[] args) {
        return Arrays.asList(args);
    }

    @Override
    public Object transpose(Object a) {
        return null;
    }

    @Override
    public Object dotTranspose(Object a) {
        return null;
    }

    @Override
    public Object pow(Object a, Object b) {
        if (this.isD(a) && this.isD(b)) {
            return this.pow(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isI(b)) {
            return this.pow(this.bi(a), this.i(b));
        }
        if (this.isBD(a) && this.isI(b)) {
            return this.pow(this.bd(a), this.i(b));
        }
        return null;
    }

    public double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public BigInteger pow(BigInteger a, int b) {
        return a.pow(b);
    }

    public BigDecimal pow(BigDecimal a, int b) {
        return a.pow(b);
    }

    @Override
    public Object dotPow(Object a, Object b) {
        return null;
    }

    @Override
    public Object pos(Object a) {
        if (this.isI(a)) {
            return this.pos(this.i(a));
        }
        if (this.isL(a)) {
            return this.pos(this.l(a));
        }
        if (this.isF(a)) {
            return Float.valueOf(this.pos(this.f(a)));
        }
        if (this.isD(a)) {
            return this.pos(this.d(a));
        }
        return this.value(a);
    }

    public int pos(int num) {
        return num;
    }

    public long pos(long num) {
        return num;
    }

    public float pos(float num) {
        return num;
    }

    public double pos(double num) {
        return num;
    }

    @Override
    public Object neg(Object a) {
        if (this.isI(a)) {
            return this.neg(this.i(a));
        }
        if (this.isL(a)) {
            return this.neg(this.l(a));
        }
        if (this.isF(a)) {
            return Float.valueOf(this.neg(this.f(a)));
        }
        if (this.isD(a)) {
            return this.neg(this.d(a));
        }
        if (this.isBI(a)) {
            return this.neg(this.bi(a));
        }
        if (this.isBD(a)) {
            return this.neg(this.bd(a));
        }
        return this.sub((Object)0, a);
    }

    public int neg(int num) {
        return -num;
    }

    public long neg(long num) {
        return -num;
    }

    public float neg(float num) {
        return -num;
    }

    public double neg(double num) {
        return -num;
    }

    public BigInteger neg(BigInteger num) {
        return num.negate();
    }

    public BigDecimal neg(BigDecimal num) {
        return num.negate();
    }

    @Override
    public Object complement(Object a) {
        if (this.isI(a)) {
            return this.complement(this.i(a));
        }
        if (this.isL(a)) {
            return this.complement(this.l(a));
        }
        return null;
    }

    public int complement(int a) {
        return ~a;
    }

    public long complement(long a) {
        return a ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public Object not(Object a) {
        return this.not(this.bool(a));
    }

    public boolean not(boolean a) {
        return !a;
    }

    @Override
    public Object mul(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.mul(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.mul(this.l(a), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return Float.valueOf(this.mul(this.f(a), this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.mul(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.mul(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.mul(this.bd(a), this.bd(b));
        }
        return null;
    }

    public int mul(int a, int b) {
        return a * b;
    }

    public long mul(long a, long b) {
        return a * b;
    }

    public float mul(float a, float b) {
        return a * b;
    }

    public double mul(double a, double b) {
        return a * b;
    }

    public BigInteger mul(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    public BigDecimal mul(BigDecimal a, BigDecimal b) {
        return a.multiply(b);
    }

    @Override
    public Object div(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.div(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.div(this.l(a), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return Float.valueOf(this.div(this.f(a), this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.div(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.div(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.div(this.bd(a), this.bd(b));
        }
        return null;
    }

    public int div(int a, int b) {
        return a / b;
    }

    public long div(long a, long b) {
        return a / b;
    }

    public float div(float a, float b) {
        return a / b;
    }

    public double div(double a, double b) {
        return a / b;
    }

    public BigInteger div(BigInteger a, BigInteger b) {
        return a.divide(b);
    }

    public BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b);
    }

    @Override
    public Object mod(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.mod(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.mod(this.l(a), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return Float.valueOf(this.mod(this.f(a), this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.mod(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.mod(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.mod(this.bd(a), this.bd(b));
        }
        return null;
    }

    public int mod(int a, int b) {
        return a % b;
    }

    public long mod(long a, long b) {
        return a % b;
    }

    public float mod(float a, float b) {
        return a % b;
    }

    public double mod(double a, double b) {
        return a % b;
    }

    public BigInteger mod(BigInteger a, BigInteger b) {
        return a.remainder(b);
    }

    public BigDecimal mod(BigDecimal a, BigDecimal b) {
        return a.remainder(b);
    }

    @Override
    public Object rightDiv(Object a, Object b) {
        return null;
    }

    @Override
    public Object dotMul(Object a, Object b) {
        return null;
    }

    @Override
    public Object dotDiv(Object a, Object b) {
        return null;
    }

    @Override
    public Object dotRightDiv(Object a, Object b) {
        return null;
    }

    @Override
    public Object add(Object a, Object b) {
        if (this.isStr(a)) {
            return this.add(this.str(a), this.str(b));
        }
        if (this.isI(a) && this.isI(b)) {
            return this.add(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.add(this.l(a), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return Float.valueOf(this.add(this.f(a), this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.add(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.add(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.add(this.bd(a), this.bd(b));
        }
        return null;
    }

    public String add(String a, String b) {
        return a + b;
    }

    public int add(int a, int b) {
        return a + b;
    }

    public long add(long a, long b) {
        return a + b;
    }

    public float add(float a, float b) {
        return a + b;
    }

    public double add(double a, double b) {
        return a + b;
    }

    public BigInteger add(BigInteger a, BigInteger b) {
        return a.add(b);
    }

    public BigDecimal add(BigDecimal a, BigDecimal b) {
        return a.add(b);
    }

    @Override
    public Object sub(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.sub(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.sub(this.l(a), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return Float.valueOf(this.sub(this.f(a), this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.sub(this.d(a), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.sub(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.sub(this.bd(a), this.bd(b));
        }
        return null;
    }

    public int sub(int a, int b) {
        return a - b;
    }

    public long sub(long a, long b) {
        return a - b;
    }

    public float sub(float a, float b) {
        return a - b;
    }

    public double sub(double a, double b) {
        return a - b;
    }

    public BigInteger sub(BigInteger a, BigInteger b) {
        return a.subtract(b);
    }

    public BigDecimal sub(BigDecimal a, BigDecimal b) {
        return a.subtract(b);
    }

    @Override
    public Object leftShift(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.leftShift(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.leftShift(this.l(a), this.l(b));
        }
        if (this.isBI(a) && this.isI(b)) {
            return this.leftShift(this.bi(a), this.i(b));
        }
        return null;
    }

    public int leftShift(int a, int b) {
        return a << b;
    }

    public long leftShift(long a, long b) {
        return a << (int)b;
    }

    public BigInteger leftShift(BigInteger a, int b) {
        return a.shiftLeft(b);
    }

    @Override
    public Object rightShift(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.rightShift(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.rightShift(this.l(a), this.l(b));
        }
        if (this.isBI(a) && this.isI(b)) {
            return this.rightShift(this.bi(a), this.i(b));
        }
        return null;
    }

    public int rightShift(int a, int b) {
        return a >> b;
    }

    public long rightShift(long a, long b) {
        return a >> (int)b;
    }

    public BigInteger rightShift(BigInteger a, int b) {
        return a.shiftRight(b);
    }

    @Override
    public Object unsignedRightShift(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.unsignedRightShift(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.unsignedRightShift(this.l(a), this.l(b));
        }
        return null;
    }

    public int unsignedRightShift(int a, int b) {
        return a >>> b;
    }

    public long unsignedRightShift(long a, long b) {
        return a >>> (int)b;
    }

    @Override
    public Object lessThan(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.lessThan(Boolean.valueOf(this.bool(a)), this.bool(b));
        }
        if (this.isStr(a) && this.isStr(b)) {
            return this.lessThan((Comparable)((Object)this.str(a)), (Object)this.str(b));
        }
        if (this.isI(a) && this.isI(b)) {
            return this.lessThan(Integer.valueOf(this.i(a)), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.lessThan(Long.valueOf(this.l(a)), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return this.lessThan(Float.valueOf(this.f(a)), Float.valueOf(this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.lessThan(Double.valueOf(this.d(a)), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.lessThan(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.lessThan(this.bd(a), this.bd(b));
        }
        return null;
    }

    public <T> boolean lessThan(Comparable<T> a, T b) {
        return a.compareTo(b) < 0;
    }

    @Override
    public Object greaterThan(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.greaterThan(Boolean.valueOf(this.bool(a)), this.bool(b));
        }
        if (this.isStr(a) && this.isStr(b)) {
            return this.greaterThan((Comparable)((Object)this.str(a)), (Object)this.str(b));
        }
        if (this.isI(a) && this.isI(b)) {
            return this.greaterThan(Integer.valueOf(this.i(a)), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.greaterThan(Long.valueOf(this.l(a)), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return this.greaterThan(Float.valueOf(this.f(a)), Float.valueOf(this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.greaterThan(Double.valueOf(this.d(a)), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.greaterThan(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.greaterThan(this.bd(a), this.bd(b));
        }
        return null;
    }

    public <T> boolean greaterThan(Comparable<T> a, T b) {
        return a.compareTo(b) > 0;
    }

    @Override
    public Object lessThanOrEqual(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.lessThanOrEqual(Boolean.valueOf(this.bool(a)), this.bool(b));
        }
        if (this.isStr(a) && this.isStr(b)) {
            return this.lessThanOrEqual((Comparable)((Object)this.str(a)), (Object)this.str(b));
        }
        if (this.isI(a) && this.isI(b)) {
            return this.lessThanOrEqual(Integer.valueOf(this.i(a)), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.lessThanOrEqual(Long.valueOf(this.l(a)), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return this.lessThanOrEqual(Float.valueOf(this.f(a)), Float.valueOf(this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.lessThanOrEqual(Double.valueOf(this.d(a)), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.lessThanOrEqual(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.lessThanOrEqual(this.bd(a), this.bd(b));
        }
        return null;
    }

    public <T> boolean lessThanOrEqual(Comparable<T> a, T b) {
        return a.compareTo(b) <= 0;
    }

    @Override
    public Object greaterThanOrEqual(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.greaterThanOrEqual(Boolean.valueOf(this.bool(a)), this.bool(b));
        }
        if (this.isStr(a) && this.isStr(b)) {
            return this.greaterThanOrEqual((Comparable)((Object)this.str(a)), (Object)this.str(b));
        }
        if (this.isI(a) && this.isI(b)) {
            return this.greaterThanOrEqual(Integer.valueOf(this.i(a)), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.greaterThanOrEqual(Long.valueOf(this.l(a)), this.l(b));
        }
        if (this.isF(a) && this.isF(b)) {
            return this.greaterThanOrEqual(Float.valueOf(this.f(a)), Float.valueOf(this.f(b)));
        }
        if (this.isD(a) && this.isD(b)) {
            return this.greaterThanOrEqual(Double.valueOf(this.d(a)), this.d(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.greaterThanOrEqual(this.bi(a), this.bi(b));
        }
        if (this.isBD(a) && this.isBD(b)) {
            return this.greaterThanOrEqual(this.bd(a), this.bd(b));
        }
        return null;
    }

    public <T> boolean greaterThanOrEqual(Comparable<T> a, T b) {
        return a.compareTo(b) >= 0;
    }

    @Override
    public Object instanceOf(Object a, Object b) {
        return null;
    }

    @Override
    public Object equal(Object a, Object b) {
        return this.value(a).equals(this.value(b));
    }

    @Override
    public Object notEqual(Object a, Object b) {
        return !this.value(a).equals(this.value(b));
    }

    @Override
    public Object bitwiseAnd(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.bitwiseAnd(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.bitwiseAnd(this.l(a), this.l(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.bitwiseAnd(this.bi(a), this.bi(b));
        }
        return null;
    }

    public int bitwiseAnd(int a, int b) {
        return a & b;
    }

    public long bitwiseAnd(long a, long b) {
        return a & b;
    }

    public BigInteger bitwiseAnd(BigInteger a, BigInteger b) {
        return a.and(b);
    }

    @Override
    public Object bitwiseOr(Object a, Object b) {
        if (this.isI(a) && this.isI(b)) {
            return this.bitwiseOr(this.i(a), this.i(b));
        }
        if (this.isL(a) && this.isL(b)) {
            return this.bitwiseOr(this.l(a), this.l(b));
        }
        if (this.isBI(a) && this.isBI(b)) {
            return this.bitwiseOr(this.bi(a), this.bi(b));
        }
        return null;
    }

    public int bitwiseOr(int a, int b) {
        return a | b;
    }

    public long bitwiseOr(long a, long b) {
        return a | b;
    }

    public BigInteger bitwiseOr(BigInteger a, BigInteger b) {
        return a.or(b);
    }

    @Override
    public Object logicalAnd(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.logicalAnd(this.bool(a), this.bool(b));
        }
        return null;
    }

    public boolean logicalAnd(boolean a, boolean b) {
        return a && b;
    }

    @Override
    public Object logicalOr(Object a, Object b) {
        if (this.isBool(a) && this.isBool(b)) {
            return this.logicalOr(this.bool(a), this.bool(b));
        }
        return null;
    }

    public boolean logicalOr(boolean a, boolean b) {
        return a || b;
    }

    private boolean is(Object o, Class<?> c) {
        return c.isInstance(this.value(o));
    }

    private boolean isBool(Object o) {
        return this.is(o, Boolean.class);
    }

    private boolean isStr(Object o) {
        return this.is(o, String.class);
    }

    private boolean isB(Object o) {
        return this.is(o, Byte.class);
    }

    private boolean isS(Object o) {
        return this.is(o, Short.class) || this.isB(o);
    }

    private boolean isI(Object o) {
        return this.is(o, Integer.class) || this.isS(o);
    }

    private boolean isL(Object o) {
        return this.is(o, Long.class) || this.isI(o);
    }

    private boolean isF(Object o) {
        return this.is(o, Float.class) || this.isL(o);
    }

    private boolean isD(Object o) {
        return this.is(o, Double.class) || this.isF(o);
    }

    private boolean isBI(Object o) {
        return this.is(o, BigInteger.class) || this.isL(o);
    }

    private boolean isBD(Object o) {
        return this.is(o, BigDecimal.class) || this.isBI(o) || this.isD(o);
    }

    private <T> T cast(Object token, Class<T> type) {
        if (type.isInstance(token)) {
            Object result = token;
            return (T)result;
        }
        return null;
    }

    private boolean bool(Object token) {
        Boolean b = this.cast(this.value(token), Boolean.class);
        return b != null ? b : Boolean.valueOf(token.toString());
    }

    private String str(Object token) {
        String s = this.cast(this.value(token), String.class);
        return s != null ? s : token.toString();
    }

    private Number num(Object token) {
        Number n = this.cast(this.value(token), Number.class);
        return n != null ? (Number)n : (Number)Literals.parseNumber(token.toString());
    }

    private int i(Object o) {
        return this.num(o).intValue();
    }

    private long l(Object o) {
        return this.num(o).longValue();
    }

    private float f(Object o) {
        return this.num(o).floatValue();
    }

    private double d(Object o) {
        return this.num(o).doubleValue();
    }

    private BigInteger bi(Object o) {
        BigInteger bi = this.cast(o, BigInteger.class);
        return bi != null ? bi : new BigInteger("" + this.value(o));
    }

    private BigDecimal bd(Object o) {
        BigDecimal bd = this.cast(o, BigDecimal.class);
        return bd != null ? bd : new BigDecimal("" + this.value(o));
    }

    private Object listElement(Object a, Object b) {
        Object value;
        try {
            value = this.value(a);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
        if (!(value instanceof List)) {
            return null;
        }
        List list = (List)value;
        if (!(b instanceof List)) {
            return null;
        }
        List indices = (List)b;
        if (indices.size() != 1) {
            return null;
        }
        return list.get(this.i(indices.get(0)));
    }

    private Object callFunction(String name, Object b) {
        if (name.equals("postfix") && b instanceof String) {
            return this.getParser().parsePostfix((String)b);
        }
        if (name.equals("tree") && b instanceof String) {
            return this.getParser().parseTree((String)b);
        }
        return null;
    }
}

