/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import org.scijava.parsington.Operator;
import org.scijava.parsington.Operators;
import org.scijava.parsington.ParseOperation;
import org.scijava.parsington.SyntaxTree;

public class ExpressionParser {
    private final List<Operator> operators;
    private final String elementSeparator;
    private final String statementSeparator;
    private final BiFunction<ExpressionParser, String, ParseOperation> parseOperationFactory;

    public ExpressionParser() {
        this(Operators.standardList());
    }

    public ExpressionParser(Collection<? extends Operator> operators) {
        this(operators, ",", ";");
    }

    public ExpressionParser(Collection<? extends Operator> operators, String elementSeparator, String statementSeparator) {
        this(operators, elementSeparator, statementSeparator, ParseOperation::new);
    }

    public ExpressionParser(Collection<? extends Operator> operators, String elementSeparator, String statementSeparator, BiFunction<ExpressionParser, String, ParseOperation> parseOperationFactory) {
        ArrayList<? extends Operator> operatorsList = new ArrayList<Operator>(operators);
        Collections.sort(operatorsList, (o1, o2) -> {
            int len2;
            String t1 = o1.getToken();
            String t2 = o2.getToken();
            int len1 = t1.length();
            if (len1 > (len2 = t2.length())) {
                return -1;
            }
            if (len1 < len2) {
                return 1;
            }
            return t1.compareTo(t2);
        });
        this.operators = Collections.unmodifiableList(operatorsList);
        this.elementSeparator = elementSeparator;
        this.statementSeparator = statementSeparator;
        this.parseOperationFactory = parseOperationFactory;
    }

    public SyntaxTree parseTree(String expression) {
        return new SyntaxTree(this.parsePostfix(expression));
    }

    public LinkedList<Object> parsePostfix(String expression) {
        return this.parseOperationFactory.apply(this, expression).parsePostfix();
    }

    public List<Operator> operators() {
        return this.operators;
    }

    public String elementSeparator() {
        return this.elementSeparator;
    }

    public String statementSeparator() {
        return this.statementSeparator;
    }
}

