/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import org.scijava.parsington.ExpressionParser;
import org.scijava.parsington.Function;
import org.scijava.parsington.Group;
import org.scijava.parsington.Literals;
import org.scijava.parsington.Operator;
import org.scijava.parsington.Position;
import org.scijava.parsington.Tokens;
import org.scijava.parsington.Variable;

public class ParseOperation {
    protected final ExpressionParser parser;
    protected final String expression;
    protected final Position pos = new Position();
    protected final Deque<Object> stack = new ArrayDeque<Object>();
    protected final LinkedList<Object> outputQueue = new LinkedList();
    protected boolean infix;

    public ParseOperation(ExpressionParser parser, String expression) {
        this.parser = parser;
        this.expression = expression;
    }

    public LinkedList<Object> parsePostfix() {
        while (true) {
            this.parseWhitespace();
            if (this.pos.get() == this.expression.length()) break;
            Object literal = this.parseLiteral();
            if (literal != null) {
                this.outputQueue.add(literal);
                this.infix = true;
                continue;
            }
            if (this.parseElementSeparator() != null) {
                this.handleElementSeparator();
                continue;
            }
            if (this.parseStatementSeparator() != null) {
                this.flushStack();
                this.infix = false;
                continue;
            }
            Operator o1 = this.parseOperator();
            if (o1 != null) {
                if (Tokens.isGroup(o1) && this.infix) {
                    this.handleOperator(new Function(o1.getPrecedence()));
                }
                this.handleOperator(o1);
                continue;
            }
            Group group = this.parseGroupTerminator();
            if (group != null) {
                this.handleGroupTerminator(group);
                continue;
            }
            Variable variable = this.parseVariable();
            if (variable != null) {
                this.outputQueue.add(variable);
                this.infix = true;
                continue;
            }
            this.pos.die("Invalid character");
        }
        this.flushStack();
        return this.outputQueue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expression);
        sb.append("\n");
        for (int i = 0; i < this.pos.get(); ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }

    protected char currentChar() {
        return this.futureChar(0);
    }

    protected char futureChar(int offset) {
        return this.pos.ch(this.expression, offset);
    }

    protected void parseWhitespace() {
        while (Character.isWhitespace(this.currentChar())) {
            this.pos.inc();
        }
    }

    protected Object parseLiteral() {
        if (this.infix) {
            return null;
        }
        return Literals.parseLiteral(this.expression, this.pos);
    }

    protected Variable parseVariable() {
        int length = this.parseIdentifier();
        if (length == 0) {
            return null;
        }
        return new Variable(this.parseToken(length));
    }

    protected int parseIdentifier() {
        char next;
        if (this.infix) {
            return 0;
        }
        if (!Character.isUnicodeIdentifierStart(this.currentChar())) {
            return 0;
        }
        int length = 0;
        while ((next = this.futureChar(length)) != '\u0000' && Character.isUnicodeIdentifierPart(next)) {
            ++length;
        }
        return length;
    }

    protected Operator parseOperator() {
        for (Operator op : this.parser.operators()) {
            String symbol;
            if (!this.operatorMatches(op, symbol = op.getToken())) continue;
            return op;
        }
        return null;
    }

    protected Group parseGroupTerminator() {
        for (Operator op : this.parser.operators()) {
            Group group;
            String symbol;
            if (!(op instanceof Group) || !this.operatorMatches(op, symbol = (group = (Group)op).getTerminator())) continue;
            return group;
        }
        return null;
    }

    protected String parseElementSeparator() {
        if (!this.infix) {
            return null;
        }
        return this.parseChars(this.parser.elementSeparator());
    }

    protected String parseStatementSeparator() {
        return this.parseChars(this.parser.statementSeparator());
    }

    protected Character parseChar(char c) {
        if (this.currentChar() == c) {
            this.pos.inc();
            return Character.valueOf(c);
        }
        return null;
    }

    protected <CS extends CharSequence> CS parseChars(CS cs) {
        for (int i = 0; i < cs.length(); ++i) {
            if (this.futureChar(i) == cs.charAt(i)) continue;
            return null;
        }
        this.pos.inc(cs.length());
        return cs;
    }

    protected String parseToken(int length) {
        int offset = this.pos.get();
        String token = this.expression.substring(offset, offset + length);
        this.pos.inc(length);
        return token;
    }

    private void handleOperator(Operator o1) {
        double p1 = o1.getPrecedence();
        while (!this.stack.isEmpty() && Tokens.isOperator(this.stack.peek()) && !Tokens.isGroup(this.stack.peek())) {
            Operator o2 = (Operator)this.stack.peek();
            double p2 = o2.getPrecedence();
            if (!(o1.isLeftAssociative() && p1 <= p2) && (!o1.isRightAssociative() || !(p1 < p2))) break;
            this.outputQueue.add(this.stack.pop());
        }
        this.stack.push(o1.instance());
        if (o1.isPrefix() || o1.isInfix()) {
            this.infix = false;
        } else if (o1.isPostfix()) {
            this.infix = true;
        } else {
            this.pos.fail("Impenetrable operator '" + o1 + "'");
        }
    }

    private void handleElementSeparator() {
        while (true) {
            if (this.stack.isEmpty()) {
                this.pos.die("Misplaced separator or mismatched groups");
            }
            if (Tokens.isGroup(this.stack.peek())) break;
            this.outputQueue.add(this.stack.pop());
        }
        ((Group)this.stack.peek()).incArity();
        this.infix = false;
    }

    private void handleGroupTerminator(Group group) {
        while (true) {
            if (this.stack.isEmpty()) {
                this.pos.die("Mismatched group terminator '" + group.getTerminator() + "'");
            }
            if (Tokens.isMatchingGroup(this.stack.peek(), group)) {
                if (this.infix) {
                    ((Group)this.stack.peek()).incArity();
                }
                break;
            }
            this.outputQueue.add(this.stack.pop());
        }
        this.outputQueue.add(this.stack.pop());
        this.infix = true;
    }

    private void flushStack() {
        while (!this.stack.isEmpty()) {
            Object token = this.stack.pop();
            if (Tokens.isGroup(token)) {
                this.pos.die("Mismatched groups");
            }
            this.outputQueue.add(token);
        }
    }

    private boolean operatorMatches(Operator op, String symbol) {
        if (!this.expression.startsWith(symbol, this.pos.get())) {
            return false;
        }
        boolean prefixOK = !this.infix;
        boolean postfixOK = this.infix;
        boolean infixOK = this.infix;
        if (prefixOK && op.isPrefix() || postfixOK && op.isPostfix() || infixOK && op.isInfix()) {
            this.pos.inc(symbol.length());
            return true;
        }
        return false;
    }
}

