/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Map;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidSymbolTypeException;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXSymbolParser;

public class SymbolAtom
extends CharSymbol {
    private final boolean delimiter;
    private final String name;
    public static Map<String, SymbolAtom> symbols = new TeXSymbolParser().readSymbols();
    private static BitSet validSymbolTypes = new BitSet(16);
    private char unicode;

    public SymbolAtom(SymbolAtom s, int type) throws InvalidSymbolTypeException {
        if (!validSymbolTypes.get(type)) {
            throw new InvalidSymbolTypeException("The symbol type was not valid! Use one of the symbol type constants from the class 'TeXConstants'.");
        }
        this.name = s.name;
        this.type = type;
        if (type == 1) {
            this.type_limits = 0;
        }
        this.delimiter = s.delimiter;
    }

    public SymbolAtom(String name, int type, boolean del) {
        this.name = name;
        this.type = type;
        if (type == 1) {
            this.type_limits = 0;
        }
        this.delimiter = del;
    }

    public SymbolAtom setUnicode(char c) {
        this.unicode = c;
        return this;
    }

    public char getUnicode() {
        return this.unicode;
    }

    public static void addSymbolAtom(String file) {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceParseException(file, e);
        }
        SymbolAtom.addSymbolAtom(in, file);
    }

    public static void addSymbolAtom(InputStream in, String name) {
        TeXSymbolParser tsp = new TeXSymbolParser(in, name);
        symbols.putAll(tsp.readSymbols());
    }

    public static void addSymbolAtom(SymbolAtom sym) {
        symbols.put(sym.name, sym);
    }

    public static SymbolAtom get(String name) throws SymbolNotFoundException {
        SymbolAtom obj = symbols.get(name);
        if (obj == null) {
            throw new SymbolNotFoundException(name);
        }
        return obj;
    }

    public boolean isDelimiter() {
        return this.delimiter;
    }

    public String getName() {
        return this.name;
    }

    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(this.name, style);
        Box cb = new CharBox(c);
        if (env.getSmallCap() && this.unicode != '\u0000' && Character.isLowerCase(this.unicode)) {
            try {
                cb = new ScaleBox(new CharBox(tf.getChar(TeXFormula.symbolTextMappings[Character.toUpperCase(this.unicode)], style)), 0.8, 0.8);
            }
            catch (SymbolMappingNotFoundException symbolMappingNotFoundException) {
                // empty catch block
            }
        }
        if (this.type == 1) {
            if (style < 2 && tf.hasNextLarger(c)) {
                c = tf.getNextLarger(c, style);
            }
            cb = new CharBox(c);
            cb.setShift(-(cb.getHeight() + cb.getDepth()) / 2.0f - env.getTeXFont().getAxisHeight(env.getStyle()));
            float delta = c.getItalic();
            HorizontalBox hb = new HorizontalBox(cb);
            if (delta > 1.0E-7f) {
                hb.add(new StrutBox(delta, 0.0f, 0.0f, 0.0f));
            }
            return hb;
        }
        return cb;
    }

    public CharFont getCharFont(TeXFont tf) {
        return tf.getChar(this.name, 0).getCharFont();
    }

    static {
        validSymbolTypes.set(0);
        validSymbolTypes.set(1);
        validSymbolTypes.set(2);
        validSymbolTypes.set(3);
        validSymbolTypes.set(4);
        validSymbolTypes.set(5);
        validSymbolTypes.set(6);
        validSymbolTypes.set(10);
    }
}

