/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.UUID;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.Bases;
import scodec.bits.Bases$;
import scodec.bits.Bases$Alphabets$Base32$;
import scodec.bits.Bases$Alphabets$Base58$;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexBinCommentChar$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.Bases$Alphabets$HexUppercase$;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$AtEmpty$;
import scodec.bits.ByteVectorCompanionCrossPlatform;

public final class ByteVector$
implements ByteVectorCompanionCrossPlatform,
Serializable {
    public static final ByteVector$ MODULE$ = new ByteVector$();
    private static final ByteVector empty = new ByteVector.Chunk(new ByteVector.View(ByteVector$AtEmpty$.MODULE$, 0L, 0L));
    private static final Left<String, Nothing$> Base64PaddingError = new Left((Object)"Malformed padding - final quantum may optionally be padded with one or two padding characters such that the quantum is completed");

    public ByteVector empty() {
        return empty;
    }

    public <A> ByteVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$1);
        byte[] buf = new byte[bytes.size()];
        IntRef i = IntRef.create((int)0);
        bytes.foreach((Function1 & Serializable)b -> {
            ByteVector$.$anonfun$apply$1(buf, i, integral, b);
            return BoxedUnit.UNIT;
        });
        return this.view(buf);
    }

    public ByteVector apply(Vector<Object> bytes) {
        return this.viewAt((Function1<Object, Object>)(Function1 & Serializable)idx -> BoxesRunTime.boxToByte((byte)ByteVector$.$anonfun$apply$2(bytes, BoxesRunTime.unboxToLong((Object)idx))), bytes.size());
    }

    public ByteVector apply(byte[] bytes) {
        byte[] copy = (byte[])bytes.clone();
        return this.view(copy);
    }

    public ByteVector apply(byte[] bytes, int offset, int length) {
        byte[] fresh = new byte[length];
        System.arraycopy(bytes, offset, fresh, 0, length);
        return this.view(fresh);
    }

    public ByteVector apply(ByteBuffer buffer) {
        ByteBuffer c = buffer.duplicate();
        byte[] arr = new byte[c.remaining()];
        c.get(arr);
        return this.view(arr);
    }

    public ByteVector apply(IterableOnce<Object> bs) {
        return this.view((byte[])bs.iterator().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    public ByteVector view(byte[] bytes) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtArray(bytes), 0L, bytes.length));
    }

    public ByteVector view(byte[] bytes, int offset, int size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtArray(bytes), offset, size));
    }

    public ByteVector view(ByteBuffer bytes) {
        ByteBuffer slice = bytes.slice();
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtByteBuffer(slice), 0L, slice.remaining()));
    }

    public ByteVector viewAt(Function1<Object, Object> at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(at){
            private final Function1 at$1;

            public byte apply(long i) {
                return BoxesRunTime.unboxToByte((Object)this.at$1.apply((Object)BoxesRunTime.boxToLong((long)i)));
            }
            {
                this.at$1 = at$1;
            }
        }, 0L, size));
    }

    public ByteVector view(ByteVector.At at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(at, 0L, size));
    }

    public ByteVector viewI(Function1<Object, Object> at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(at){
            private final Function1 at$2;

            public byte apply(long i) {
                return (byte)this.at$2.apply$mcIJ$sp(i);
            }
            {
                this.at$2 = at$2;
            }
        }, 0L, size));
    }

    public <A> ByteVector fill(long size, A b, Integral<A> evidence$2) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$2);
        byte value = (byte)integral.toInt(b);
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(value){
            private final byte value$1;

            public byte apply(long i) {
                return this.value$1;
            }
            {
                this.value$1 = value$1;
            }
        }, 0L, size));
    }

    public ByteVector low(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)0), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector high(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)255), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector fromByte(byte b) {
        return BitVector$.MODULE$.fromByte(b, 8).bytes();
    }

    public ByteVector fromShort(short s, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromShort(s, size * 8, ordering).bytes();
    }

    public int fromShort$default$2() {
        return 2;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromInt(int i, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromInt(i, size * 8, ordering).bytes();
    }

    public int fromInt$default$2() {
        return 4;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromLong(long l, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromLong(l, size * 8, ordering).bytes();
    }

    public int fromLong$default$2() {
        return 8;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final ByteVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, ByteVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        Right right;
        try {
            right = new Right(this.fromHexInternal(str, alphabet)._1());
        }
        catch (IllegalArgumentException t) {
            right = new Left((Object)t.getMessage());
        }
        return right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<ByteVector, Object> fromHexInternal(String str, Bases.HexAlphabet alphabet) {
        ByteVector byteVector;
        int idx;
        char second;
        boolean prefixed = str.length() >= 2 && str.charAt(0) == '0' && ((second = str.charAt(1)) == 'x' || second == 'X');
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int hi = 0;
        int count = 0;
        boolean midByte = false;
        int length = withoutPrefix.length();
        byte[] out = new byte[(length + 1) / 2];
        int j = 0;
        boolean defaults = alphabet == Bases$Alphabets$HexLowercase$.MODULE$ || alphabet == Bases$Alphabets$HexUppercase$.MODULE$;
        try {
            for (idx = 0; idx < length; ++idx) {
                int nibble;
                int n;
                char c = withoutPrefix.charAt(idx);
                if (defaults) {
                    int i = Character.digit(c, 16);
                    if (i >= 0) {
                        n = i;
                    } else if (Character.isWhitespace(c) || c == '_') {
                        n = Bases$.MODULE$.IgnoreChar();
                    } else {
                        if (!Bases$Alphabets$HexBinCommentChar$.MODULE$.unapply(c).isDefined()) throw new IllegalArgumentException();
                        n = Bases$.MODULE$.IgnoreRestOfLine();
                    }
                } else {
                    n = nibble = alphabet.toIndex(c);
                }
                if (nibble >= 0) {
                    if (midByte) {
                        out[j] = (byte)(hi | nibble);
                        ++j;
                        midByte = false;
                    } else {
                        hi = nibble << 4;
                        midByte = true;
                    }
                    ++count;
                    continue;
                }
                if (nibble != Bases$.MODULE$.IgnoreRestOfLine()) continue;
                while (idx < length && withoutPrefix.charAt(idx) != '\n') {
                    ++idx;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            char c = withoutPrefix.charAt(idx);
            throw new IllegalArgumentException(new StringBuilder(42).append("Invalid hexadecimal character '").append(c).append("' at index ").append(idx + (prefixed ? 2 : 0)).toString());
        }
        if (midByte) {
            out[j] = (byte)hi;
            byteVector = this.view(out).take(++j).shiftRight(4L, false);
        } else {
            byteVector = this.view(out).take(j);
        }
        ByteVector result = byteVector;
        return new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)count));
    }

    public Option<ByteVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        Some some;
        try {
            some = new Some(this.fromHexInternal(str, alphabet)._1());
        }
        catch (IllegalArgumentException t) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public ByteVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (ByteVector)this.fromHexDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, ByteVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        Right right;
        try {
            right = new Right(this.fromBinInternal(str, alphabet)._1());
        }
        catch (IllegalArgumentException t) {
            right = new Left((Object)t.getMessage());
        }
        return right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<ByteVector, Object> fromBinInternal(String str, Bases.BinaryAlphabet alphabet) {
        ByteVector byteVector;
        int idx;
        char second;
        boolean prefixed = str.length() >= 2 && str.charAt(0) == '0' && ((second = str.charAt(1)) == 'b' || second == 'B');
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int n = 0;
        int bits = 0;
        int count = 0;
        int length = withoutPrefix.length();
        byte[] out = new byte[(length + 7) / 8];
        int j = 0;
        boolean defaults = alphabet == Bases$Alphabets$Binary$.MODULE$;
        try {
            for (idx = 0; idx < length; ++idx) {
                int bit;
                int n2;
                char c = withoutPrefix.charAt(idx);
                if (defaults) {
                    char c2 = c;
                    if ('0' == c2) {
                        n2 = 0;
                    } else if ('1' == c2) {
                        n2 = 1;
                    } else if (Character.isWhitespace(c) || c == '_') {
                        n2 = Bases$.MODULE$.IgnoreChar();
                    } else {
                        Option<Object> option = Bases$Alphabets$HexBinCommentChar$.MODULE$.unapply(c2);
                        if (option.isEmpty()) throw new IllegalArgumentException();
                        n2 = Bases$.MODULE$.IgnoreRestOfLine();
                    }
                } else {
                    n2 = bit = alphabet.toIndex(c);
                }
                if (bit >= 0) {
                    n = n << 1 | bit;
                    ++count;
                    if (++bits != 8) continue;
                    out[j] = (byte)n;
                    ++j;
                    bits = 0;
                    n = 0;
                    continue;
                }
                if (bit != Bases$.MODULE$.IgnoreRestOfLine()) continue;
                while (idx < length && withoutPrefix.charAt(idx) != '\n') {
                    ++idx;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            char c = withoutPrefix.charAt(idx);
            throw new IllegalArgumentException(new StringBuilder(37).append("Invalid binary character '").append(c).append("' at index ").append(idx + (prefixed ? 2 : 0)).toString());
        }
        if (bits > 0) {
            out[j] = (byte)(n << 8 - bits);
            ++j;
            byteVector = this.view(out).shiftRight(8 - bits, false);
        } else {
            byteVector = this.view(out).take(j);
        }
        ByteVector result = byteVector;
        return new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)count));
    }

    public Option<ByteVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).toOption();
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public ByteVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (ByteVector)this.fromBinDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, ByteVector> fromBase32Descriptive(String str, Bases.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int padding = 0;
        ByteBuffer acc = ByteBuffer.allocate((str.length() + charsPerGroup - 1) / charsPerGroup * bytesPerGroup);
        for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            if (Pad != '\u0000' && c == Pad) {
                ++padding;
                continue;
            }
            if (alphabet.ignore(c)) continue;
            if (padding > 0) {
                return new Left((Object)new StringBuilder(131).append("Unexpected character '").append(c).append("' at index ").append(idx).append(" after padding character; only '=' and whitespace characters allowed after first padding character").toString());
            }
            try {
                n = alphabet.toIndex(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new Left((Object)new StringBuilder(38).append("Invalid base 32 character '").append(c).append("' at index ").append(idx).toString());
            }
            int index = n;
            buffer |= index << 8 - bitsPerChar >>> bidx & 0xFF;
            if ((bidx += bitsPerChar) < 8) continue;
            acc.put((byte)buffer);
            buffer = index << 8 - (bidx -= 8) & 0xFF;
        }
        Object object = bidx >= bitsPerChar ? acc.put((byte)buffer) : BoxedUnit.UNIT;
        acc.flip();
        ByteVector bytes = this.view(acc);
        long expectedPadding = ((bytes.length() + (long)bitsPerChar - 1L) / (long)bitsPerChar * (long)bitsPerChar - bytes.length()) * 8L / (long)bitsPerChar;
        if (padding != 0 && (long)padding != expectedPadding) {
            return new Left((Object)new StringBuilder(94).append("Malformed padding - optionally expected ").append(expectedPadding).append(" padding characters such that the quantum is completed").toString());
        }
        return new Right((Object)bytes);
    }

    public Option<ByteVector> fromBase32(String str, Bases.Base32Alphabet alphabet) {
        return this.fromBase32Descriptive(str, alphabet).toOption();
    }

    public Bases.Base32Alphabet fromBase32Descriptive$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Bases.Base32Alphabet fromBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public ByteVector fromValidBase32(String str, Bases.Base32Alphabet alphabet) {
        return (ByteVector)this.fromBase32Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base32Alphabet fromValidBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Either<String, ByteVector> fromBase58Descriptive(String str, Bases.Alphabet alphabet) {
        Left left;
        block3: {
            int zeroLength = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ByteVector$.$anonfun$fromBase58Descriptive$1(BoxesRunTime.unboxToChar((Object)x$9)))).length();
            ByteVector zeroes = this.fill(zeroLength, (Object)BoxesRunTime.boxToInteger((int)0), (Integral)Numeric.IntIsIntegral$.MODULE$);
            List trim = Predef$.MODULE$.wrapString((String)StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(str), zeroLength)._2()).toList();
            BigInt RADIX = package$.MODULE$.BigInt().apply(58L);
            try {
                BigInt decoded = (BigInt)trim.foldLeft((Object)package$.MODULE$.BigInt().apply(0), (Function2 & Serializable)(a, c) -> ByteVector$.$anonfun$fromBase58Descriptive$2(RADIX, alphabet, trim, a, BoxesRunTime.unboxToChar((Object)c)));
                if (trim.isEmpty()) {
                    left = new Right((Object)zeroes);
                    break block3;
                }
                left = new Right((Object)zeroes.$plus$plus(this.apply((byte[])ArrayOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.byteArrayOps(decoded.toByteArray()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ByteVector$.$anonfun$fromBase58Descriptive$4(BoxesRunTime.unboxToByte((Object)x$11)))))));
            }
            catch (IllegalArgumentException e) {
                left = new Left((Object)e.getMessage());
            }
        }
        return left;
    }

    public Option<ByteVector> fromBase58(String str, Bases.Alphabet alphabet) {
        return this.fromBase58Descriptive(str, alphabet).toOption();
    }

    public Bases.Alphabet fromBase58Descriptive$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public Bases.Alphabet fromBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public ByteVector fromValidBase58(String str, Bases.Alphabet alphabet) {
        return (ByteVector)this.fromBase58Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Alphabet fromValidBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    private Left<String, Nothing$> Base64PaddingError() {
        return Base64PaddingError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, ByteVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int mod = 0;
        int padding = 0;
        byte[] acc = new byte[(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(str)) + 3) / 4 * 3];
        block16: for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            switch (c) {
                default: 
            }
            if (alphabet.ignore(c)) continue;
            if (padding == 0) {
                if (c == Pad) {
                    if (mod != 2 && mod != 3) return this.Base64PaddingError();
                    ++padding;
                    n = 0;
                } else {
                    try {
                        n = alphabet.toIndex(c);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return new Left((Object)new StringBuilder(38).append("Invalid base 64 character '").append(c).append("' at index ").append(idx).toString());
                    }
                }
            } else {
                if (c != Pad) return new Left((Object)new StringBuilder(131).append("Unexpected character '").append(c).append("' at index ").append(idx).append(" after padding character; only '=' and whitespace characters allowed after first padding character").toString());
                if (padding != 1 || mod != 3) return this.Base64PaddingError();
                ++padding;
                n = 0;
            }
            int cidx = n;
            int n2 = mod++;
            switch (n2) {
                case 0: {
                    buffer = cidx & 0x3F;
                    continue block16;
                }
                case 1: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block16;
                }
                case 2: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block16;
                }
                case 3: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    mod = 0;
                    int c2 = buffer & 0xFF;
                    int b = buffer >> 8 & 0xFF;
                    int a = buffer >> 16 & 0xFF;
                    acc[bidx] = (byte)a;
                    acc[bidx + 1] = (byte)b;
                    acc[bidx + 2] = (byte)c2;
                    bidx += 3;
                    continue block16;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
            }
        }
        if (padding != 0 && mod != 0) {
            return this.Base64PaddingError();
        }
        int n = mod;
        switch (n) {
            case 0: {
                return new Right((Object)this.apply(acc).take(bidx - padding));
            }
            case 1: {
                return new Left((Object)"Final base 64 quantum had only 1 digit - must have at least 2 digits");
            }
            case 2: {
                acc[bidx] = (byte)(buffer >> 4 & 0xFF);
                return new Right((Object)this.apply(acc).take(++bidx));
            }
            case 3: {
                acc[bidx] = (byte)(buffer >> 10 & 0xFF);
                acc[bidx + 1] = (byte)(buffer >> 2 & 0xFF);
                return new Right((Object)this.apply(acc).take(bidx += 2));
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public Option<ByteVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).toOption();
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public ByteVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (ByteVector)this.fromBase64Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, ByteVector> encodeString(String str, Charset charset) {
        Right right;
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer buffer = CharBuffer.wrap(str);
        try {
            right = new Right((Object)this.apply(encoder.encode(buffer)));
        }
        catch (CharacterCodingException e) {
            right = new Left((Object)e);
        }
        return right;
    }

    public Either<CharacterCodingException, ByteVector> encodeUtf8(String str) {
        return this.encodeString(str, Charset.forName("UTF-8"));
    }

    public Either<CharacterCodingException, ByteVector> encodeAscii(String str) {
        return this.encodeString(str, Charset.forName("US-ASCII"));
    }

    public ByteVector concat(IterableOnce<ByteVector> bvs) {
        return ((ByteVector)bvs.iterator().foldLeft((Object)this.empty(), (Function2 & Serializable)(x$12, x$13) -> x$12.$plus$plus((ByteVector)x$13))).unbuffer();
    }

    public int toIntSize(long size) {
        if (size <= Integer.MAX_VALUE) {
            return (int)size;
        }
        throw new IllegalArgumentException(new StringBuilder(36).append("size must be <= Int.MaxValue but is ").append(size).toString());
    }

    public Some<Seq<Object>> unapplySeq(ByteVector b) {
        return new Some(b.toIndexedSeq());
    }

    public ByteVector GroupedOp(ByteVector self) {
        return self;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ByteVector$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(byte[] buf$1, IntRef i$4, Integral integral$1, Object b) {
        buf$1[i$4.elem] = (byte)integral$1.toInt(b);
        ++i$4.elem;
    }

    public static final /* synthetic */ byte $anonfun$apply$2(Vector bytes$1, long idx) {
        return BoxesRunTime.unboxToByte((Object)bytes$1.apply((int)idx));
    }

    public static final /* synthetic */ boolean $anonfun$fromBase58Descriptive$1(char x$9) {
        return x$9 == '1';
    }

    public static final /* synthetic */ boolean $anonfun$fromBase58Descriptive$3(char c$1, char x$10) {
        return x$10 != c$1;
    }

    public static final /* synthetic */ BigInt $anonfun$fromBase58Descriptive$2(BigInt RADIX$2, Bases.Alphabet alphabet$4, List trim$1, BigInt a, char c) {
        BigInt bigInt;
        try {
            bigInt = a.$times(RADIX$2).$plus(package$.MODULE$.BigInt().apply(alphabet$4.toIndex(c)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int idx = trim$1.takeWhile((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ByteVector$.$anonfun$fromBase58Descriptive$3(c, BoxesRunTime.unboxToChar((Object)x$10)))).length();
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid base 58 character '").append(c).append("' at index ").append(idx).toString());
        }
        return bigInt;
    }

    public static final /* synthetic */ boolean $anonfun$fromBase58Descriptive$4(byte x$11) {
        return x$11 == 0;
    }

    private ByteVector$() {
    }
}

