/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.UUID;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right$;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base32$;
import scodec.bits.Bases$Alphabets$Base58$;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$Append$;
import scodec.bits.ByteVector$AtEmpty$;
import scodec.bits.ByteVector$Buffer$;
import scodec.bits.ByteVector$Chunk$;
import scodec.bits.ByteVector$Chunks$;
import scodec.bits.ByteVector$GroupedOp$;
import scodec.bits.ByteVector$View$;
import scodec.bits.ByteVectorCompanionCrossPlatform;

public final class ByteVector$
implements ByteVectorCompanionCrossPlatform,
Serializable {
    public static final ByteVector$AtEmpty$ scodec$bits$ByteVector$$$AtEmpty;
    public static final ByteVector$View$ View;
    public static final ByteVector$Chunk$ Chunk;
    public static final ByteVector$Append$ Append;
    private static final ByteVector empty;
    private static final Left<String, Nothing$> Base64PaddingError;
    public static final ByteVector$Chunks$ Chunks;
    public static final ByteVector$Buffer$ scodec$bits$ByteVector$$$Buffer;
    public static final ByteVector$GroupedOp$ GroupedOp;
    public static final ByteVector$ MODULE$;

    private ByteVector$() {
    }

    static {
        MODULE$ = new ByteVector$();
        empty = ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(ByteVector$AtEmpty$.MODULE$, 0L, 0L));
        Base64PaddingError = package$.MODULE$.Left().apply((Object)"Malformed padding - final quantum may optionally be padded with one or two padding characters such that the quantum is completed");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ByteVector$.class);
    }

    public ByteVector empty() {
        return empty;
    }

    public <A> ByteVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$1);
        byte[] buf = new byte[bytes.size()];
        IntRef i = IntRef.create((int)0);
        bytes.foreach((Function1)(JProcedure1 & Serializable)b -> {
            int n;
            buf$1[i$3.elem] = (byte)integral.toInt(b);
            i$3.elem = n = i$3.elem + 1;
        });
        return this.view(buf);
    }

    public ByteVector apply(Vector<Object> bytes) {
        return this.viewAt((Function1<Object, Object>)(Function1 & Serializable)idx -> this.apply$$anonfun$2(bytes, BoxesRunTime.unboxToLong((Object)idx)), bytes.size());
    }

    public ByteVector apply(byte[] bytes) {
        byte[] copy = (byte[])bytes.clone();
        return this.view(copy);
    }

    public ByteVector apply(byte[] bytes, int offset, int length) {
        byte[] fresh = new byte[length];
        System.arraycopy(bytes, offset, fresh, 0, length);
        return this.view(fresh);
    }

    public ByteVector apply(ByteBuffer buffer) {
        ByteBuffer c = buffer.duplicate();
        byte[] arr = new byte[c.remaining()];
        c.get(arr);
        return this.view(arr);
    }

    public ByteVector apply(IterableOnce<Object> bs) {
        return this.view((byte[])bs.iterator().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteVector view(byte[] bytes) {
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.AtArray(bytes), 0L, bytes.length));
    }

    public ByteVector view(byte[] bytes, int offset, int size) {
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.AtArray(bytes), offset, size));
    }

    public ByteVector view(ByteBuffer bytes) {
        ByteBuffer slice = bytes.slice();
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.AtByteBuffer(slice), 0L, slice.remaining()));
    }

    public ByteVector viewAt(Function1<Object, Object> at, long size) {
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.At(at){
            private final Function1 at$1;
            {
                this.at$1 = at$3;
            }

            public byte apply(long i) {
                return BoxesRunTime.unboxToByte((Object)this.at$1.apply((Object)BoxesRunTime.boxToLong((long)i)));
            }
        }, 0L, size));
    }

    public ByteVector view(ByteVector.At at, long size) {
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(at, 0L, size));
    }

    public ByteVector viewI(Function1<Object, Object> at, long size) {
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.At(at){
            private final Function1 at$2;
            {
                this.at$2 = at$4;
            }

            public byte apply(long i) {
                return (byte)this.at$2.apply$mcIJ$sp(i);
            }
        }, 0L, size));
    }

    public <A> ByteVector fill(long size, A b, Integral<A> evidence$2) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$2);
        byte value = (byte)integral.toInt(b);
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new ByteVector.At(value){
            private final byte value$1;
            {
                this.value$1 = value$2;
            }

            public byte apply(long i) {
                return this.value$1;
            }
        }, 0L, size));
    }

    public ByteVector low(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)0), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector high(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)255), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector fromByte(byte b) {
        return BitVector$.MODULE$.fromByte(b, 8).bytes();
    }

    public ByteVector fromShort(short s, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromShort(s, size * 8, ordering).bytes();
    }

    public int fromShort$default$2() {
        return 2;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromInt(int i, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromInt(i, size * 8, ordering).bytes();
    }

    public int fromInt$default$2() {
        return 4;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromLong(long l, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromLong(l, size * 8, ordering).bytes();
    }

    public int fromLong$default$2() {
        return 8;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final ByteVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, ByteVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexInternal(str, alphabet).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteVector res = (ByteVector)tuple2._1();
            return res;
        });
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, Tuple2<ByteVector, Object>> fromHexInternal(String str, Bases.HexAlphabet alphabet) {
        Left left;
        boolean prefixed = str.startsWith("0x") || str.startsWith("0X");
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int hi = 0;
        int count = 0;
        boolean midByte = false;
        String err = null;
        ByteBuffer bldr = ByteBuffer.allocate((StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(str)) + 1) / 2);
        for (int idx = 0; idx < withoutPrefix.length() && err == null; ++idx) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(withoutPrefix), idx);
            if (alphabet.ignore(c)) continue;
            try {
                int nibble = alphabet.toIndex(c);
                if (midByte) {
                    bldr.put((byte)(hi | nibble));
                    midByte = false;
                } else {
                    hi = (byte)(nibble << 4);
                    midByte = true;
                }
                ++count;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                err = new StringBuilder(42).append("Invalid hexadecimal character '").append(c).append("' at index ").append(idx + (prefixed ? 2 : 0)).toString();
            }
        }
        if (err == null) {
            ByteVector byteVector;
            Right$ right$ = package$.MODULE$.Right();
            if (midByte) {
                bldr.put((byte)hi);
                bldr.flip();
                byteVector = this.apply(bldr).shiftRight(4L, false);
            } else {
                bldr.flip();
                byteVector = this.apply(bldr);
            }
            left = right$.apply((Object)Tuple2$.MODULE$.apply((Object)byteVector, (Object)BoxesRunTime.boxToInteger((int)count)));
        } else {
            left = package$.MODULE$.Left().apply(err);
        }
        return left;
    }

    public Option<ByteVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).toOption();
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public ByteVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (ByteVector)this.fromHexDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, ByteVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinInternal(str, alphabet).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteVector res = (ByteVector)tuple2._1();
            return res;
        });
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, Tuple2<ByteVector, Object>> fromBinInternal(String str, Bases.BinaryAlphabet alphabet) {
        Left left;
        boolean prefixed = str.startsWith("0b") || str.startsWith("0B");
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int n = 0;
        int bits = 0;
        int count = 0;
        String err = null;
        ByteBuffer bldr = ByteBuffer.allocate((StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(str)) + 7) / 8);
        for (int idx = 0; idx < withoutPrefix.length() && err == null; ++idx) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(withoutPrefix), idx);
            if (!alphabet.ignore(c)) {
                try {
                    n = n << 1 | 1 & alphabet.toIndex(c);
                    ++bits;
                    ++count;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    err = new StringBuilder(37).append("Invalid binary character '").append(c).append("' at index ").append(idx + (prefixed ? 2 : 0)).toString();
                }
            }
            if (bits != 8) continue;
            bldr.put((byte)n);
            n = 0;
            bits = 0;
        }
        if (err == null) {
            ByteVector byteVector;
            Right$ right$ = package$.MODULE$.Right();
            if (bits > 0) {
                bldr.put((byte)(n << 8 - bits));
                bldr.flip();
                byteVector = this.apply(bldr).shiftRight(8 - bits, false);
            } else {
                bldr.flip();
                byteVector = this.apply(bldr);
            }
            left = right$.apply((Object)Tuple2$.MODULE$.apply((Object)byteVector, (Object)BoxesRunTime.boxToInteger((int)count)));
        } else {
            left = package$.MODULE$.Left().apply(err);
        }
        return left;
    }

    public Bases.BinaryAlphabet fromBinInternal$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Option<ByteVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).toOption();
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public ByteVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (ByteVector)this.fromBinDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, ByteVector> fromBase32Descriptive(String str, Bases.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int padding = 0;
        ByteBuffer acc = ByteBuffer.allocate((str.length() + charsPerGroup - 1) / charsPerGroup * bytesPerGroup);
        for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            if (Pad != (char)0 && c == Pad) {
                ++padding;
                continue;
            }
            if (alphabet.ignore(c)) continue;
            if (padding > 0) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(131).append("Unexpected character '").append(c).append("' at index ").append(idx).append(" after padding character; only '=' and whitespace characters allowed after first padding character").toString());
            }
            try {
                n = alphabet.toIndex(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(38).append("Invalid base 32 character '").append(c).append("' at index ").append(idx).toString());
            }
            int index = n;
            buffer |= index << 8 - bitsPerChar >>> bidx & 0xFF;
            if ((bidx += bitsPerChar) < 8) continue;
            acc.put((byte)buffer);
            buffer = index << 8 - (bidx -= 8) & 0xFF;
        }
        if (bidx >= bitsPerChar) {
            acc.put((byte)buffer);
        }
        acc.flip();
        ByteVector bytes = this.view(acc);
        long expectedPadding = ((bytes.length() + (long)bitsPerChar - 1L) / (long)bitsPerChar * (long)bitsPerChar - bytes.length()) * 8L / (long)bitsPerChar;
        if (padding != 0 && (long)padding != expectedPadding) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(94).append("Malformed padding - optionally expected ").append(expectedPadding).append(" padding characters such that the quantum is completed").toString());
        }
        return package$.MODULE$.Right().apply((Object)bytes);
    }

    public Bases.Base32Alphabet fromBase32Descriptive$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Option<ByteVector> fromBase32(String str, Bases.Base32Alphabet alphabet) {
        return this.fromBase32Descriptive(str, alphabet).toOption();
    }

    public Bases.Base32Alphabet fromBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public ByteVector fromValidBase32(String str, Bases.Base32Alphabet alphabet) {
        return (ByteVector)this.fromBase32Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base32Alphabet fromValidBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Either<String, ByteVector> fromBase58Descriptive(String str, Bases.Alphabet alphabet) {
        Left left;
        block3: {
            int zeroLength = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)_$8 -> this.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$8))).length();
            ByteVector zeroes = this.fill(zeroLength, (Object)BoxesRunTime.boxToInteger((int)0), (Integral)Numeric.IntIsIntegral$.MODULE$);
            List trim = Predef$.MODULE$.wrapString((String)StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(str), zeroLength)._2()).toList();
            BigInt RADIX = package$.MODULE$.BigInt().apply(58L);
            try {
                BigInt decoded = (BigInt)trim.foldLeft((Object)package$.MODULE$.BigInt().apply(0), (Function2 & Serializable)(a, c) -> this.$anonfun$4(alphabet, trim, RADIX, (BigInt)a, BoxesRunTime.unboxToChar((Object)c)));
                if (trim.isEmpty()) {
                    left = package$.MODULE$.Right().apply((Object)zeroes);
                    break block3;
                }
                Object object = Predef$.MODULE$.byteArrayOps(decoded.toByteArray());
                left = package$.MODULE$.Right().apply((Object)zeroes.$plus$plus(this.apply((byte[])ArrayOps$.MODULE$.dropWhile$extension(object, (Function1 & Serializable)_$10 -> this.fromBase58Descriptive$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$10))))));
            }
            catch (IllegalArgumentException e) {
                left = package$.MODULE$.Left().apply((Object)e.getMessage());
            }
        }
        return left;
    }

    public Bases.Alphabet fromBase58Descriptive$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public Option<ByteVector> fromBase58(String str, Bases.Alphabet alphabet) {
        return this.fromBase58Descriptive(str, alphabet).toOption();
    }

    public Bases.Alphabet fromBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public ByteVector fromValidBase58(String str, Bases.Alphabet alphabet) {
        return (ByteVector)this.fromBase58Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Alphabet fromValidBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, ByteVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        Left left;
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int mod = 0;
        int padding = 0;
        byte[] acc = new byte[(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(str)) + 3) / 4 * 3];
        block14: for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            char c2 = c;
            if (alphabet.ignore(c2)) continue;
            char c3 = c;
            if (padding == 0) {
                if (c3 == Pad) {
                    if (mod != 2 && mod != 3) return Base64PaddingError;
                    ++padding;
                    n = 0;
                } else {
                    try {
                        n = alphabet.toIndex(c3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(38).append("Invalid base 64 character '").append(c3).append("' at index ").append(idx).toString());
                    }
                }
            } else {
                if (c3 != Pad) return package$.MODULE$.Left().apply((Object)new StringBuilder(131).append("Unexpected character '").append(c3).append("' at index ").append(idx).append(" after padding character; only '=' and whitespace characters allowed after first padding character").toString());
                if (padding != 1 || mod != 3) return Base64PaddingError;
                ++padding;
                n = 0;
            }
            int cidx = n;
            int n2 = mod++;
            switch (n2) {
                case 0: {
                    buffer = cidx & 0x3F;
                    continue block14;
                }
                case 1: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block14;
                }
                case 2: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block14;
                }
                case 3: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    mod = 0;
                    int c4 = buffer & 0xFF;
                    int b = buffer >> 8 & 0xFF;
                    int a = buffer >> 16 & 0xFF;
                    acc[bidx] = (byte)a;
                    acc[bidx + 1] = (byte)b;
                    acc[bidx + 2] = (byte)c4;
                    bidx += 3;
                    continue block14;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
            }
        }
        if (padding != 0 && mod != 0) {
            left = Base64PaddingError;
            return left;
        } else {
            int n = mod;
            switch (n) {
                case 0: {
                    left = package$.MODULE$.Right().apply((Object)this.apply(acc).take(bidx - padding));
                    return left;
                }
                case 1: {
                    left = package$.MODULE$.Left().apply((Object)"Final base 64 quantum had only 1 digit - must have at least 2 digits");
                    return left;
                }
                case 2: {
                    acc[bidx] = (byte)(buffer >> 4 & 0xFF);
                    left = package$.MODULE$.Right().apply((Object)this.apply(acc).take(++bidx));
                    return left;
                }
                case 3: {
                    acc[bidx] = (byte)(buffer >> 10 & 0xFF);
                    acc[bidx + 1] = (byte)(buffer >> 2 & 0xFF);
                    left = package$.MODULE$.Right().apply((Object)this.apply(acc).take(bidx += 2));
                    return left;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Option<ByteVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).toOption();
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public ByteVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (ByteVector)this.fromBase64Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, ByteVector> encodeString(String str, Charset charset) {
        Left left;
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer buffer = CharBuffer.wrap(str);
        try {
            left = package$.MODULE$.Right().apply((Object)this.apply(encoder.encode(buffer)));
        }
        catch (CharacterCodingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Either<CharacterCodingException, ByteVector> encodeUtf8(String str) {
        return this.encodeString(str, Charset.forName("UTF-8"));
    }

    public Either<CharacterCodingException, ByteVector> encodeAscii(String str) {
        return this.encodeString(str, Charset.forName("US-ASCII"));
    }

    public ByteVector concat(IterableOnce<ByteVector> bvs) {
        return ((ByteVector)bvs.iterator().foldLeft((Object)this.empty(), (Function2 & Serializable)(_$11, _$12) -> _$11.$plus$plus((ByteVector)_$12))).unbuffer();
    }

    public int toIntSize(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(36).append("size must be <= Int.MaxValue but is ").append(size).toString());
        }
        return (int)size;
    }

    public Some<Seq<Object>> unapplySeq(ByteVector b) {
        return Some$.MODULE$.apply(b.toIndexedSeq());
    }

    public final ByteVector GroupedOp(ByteVector self) {
        return self;
    }

    private final /* synthetic */ byte apply$$anonfun$2(Vector bytes$1, long idx) {
        return BoxesRunTime.unboxToByte((Object)bytes$1.apply((int)idx));
    }

    private final /* synthetic */ boolean $anonfun$3(char _$8) {
        return _$8 == '1';
    }

    private final /* synthetic */ boolean $anonfun$5(char c$1, char _$9) {
        return _$9 != c$1;
    }

    private final /* synthetic */ BigInt $anonfun$4(Bases.Alphabet alphabet$4, List trim$1, BigInt RADIX$2, BigInt a, char c) {
        BigInt bigInt;
        try {
            bigInt = a.$times(RADIX$2).$plus(package$.MODULE$.BigInt().apply(alphabet$4.toIndex(c)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int idx = trim$1.takeWhile((Function1 & Serializable)_$9 -> this.$anonfun$5(c, BoxesRunTime.unboxToChar((Object)_$9))).length();
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid base 58 character '").append(c).append("' at index ").append(idx).toString());
        }
        return bigInt;
    }

    private final /* synthetic */ boolean fromBase58Descriptive$$anonfun$1(byte _$10) {
        return _$10 == 0;
    }
}

