/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichBoolean;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base32$;
import scodec.bits.Bases$Alphabets$Base58$;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector$;
import scodec.bits.BitVector$Append$;
import scodec.bits.BitVector$Bytes$;
import scodec.bits.BitVector$Chunks$;
import scodec.bits.BitVector$Drop$;
import scodec.bits.BitVector$GroupedOp$;
import scodec.bits.BitVector$Suspend$;
import scodec.bits.BitVectorCrossPlatform;
import scodec.bits.BitwiseOperations;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteOrdering$LittleEndian$;
import scodec.bits.ByteVector;
import scodec.bits.HexDumpFormat$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BitVector
implements BitwiseOperations<BitVector, Object>,
BitVectorCrossPlatform,
Ordered<BitVector>,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BitVector.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    public int hashCode$lzy1;

    public static BitVector GroupedOp(BitVector bitVector) {
        return BitVector$.MODULE$.GroupedOp(bitVector);
    }

    public static BitVector bit(boolean bl) {
        return BitVector$.MODULE$.bit(bl);
    }

    public static BitVector bits(Iterable<Object> iterable) {
        return BitVector$.MODULE$.bits(iterable);
    }

    public static BitVector concat(IterableOnce<BitVector> iterableOnce) {
        return BitVector$.MODULE$.concat(iterableOnce);
    }

    public static BitVector concat(Vector<BitVector> vector) {
        return BitVector$.MODULE$.concat(vector);
    }

    public static BitVector empty() {
        return BitVector$.MODULE$.empty();
    }

    public static Either<CharacterCodingException, BitVector> encodeAscii(String string) {
        return BitVector$.MODULE$.encodeAscii(string);
    }

    public static Either<CharacterCodingException, BitVector> encodeString(String string, Charset charset) {
        return BitVector$.MODULE$.encodeString(string, charset);
    }

    public static Either<CharacterCodingException, BitVector> encodeUtf8(String string) {
        return BitVector$.MODULE$.encodeUtf8(string);
    }

    public static BitVector fill(long l, boolean bl) {
        return BitVector$.MODULE$.fill(l, bl);
    }

    public static Option<BitVector> fromBase32(String string, Bases.Base32Alphabet base32Alphabet) {
        return BitVector$.MODULE$.fromBase32(string, base32Alphabet);
    }

    public static Either<String, BitVector> fromBase32Descriptive(String string, Bases.Base32Alphabet base32Alphabet) {
        return BitVector$.MODULE$.fromBase32Descriptive(string, base32Alphabet);
    }

    public static Option<BitVector> fromBase58(String string, Bases.Alphabet alphabet) {
        return BitVector$.MODULE$.fromBase58(string, alphabet);
    }

    public static Either<String, BitVector> fromBase58Descriptive(String string, Bases.Alphabet alphabet) {
        return BitVector$.MODULE$.fromBase58Descriptive(string, alphabet);
    }

    public static Option<BitVector> fromBase64(String string, Bases.Base64Alphabet base64Alphabet) {
        return BitVector$.MODULE$.fromBase64(string, base64Alphabet);
    }

    public static Either<String, BitVector> fromBase64Descriptive(String string, Bases.Base64Alphabet base64Alphabet) {
        return BitVector$.MODULE$.fromBase64Descriptive(string, base64Alphabet);
    }

    public static Option<BitVector> fromBin(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return BitVector$.MODULE$.fromBin(string, binaryAlphabet);
    }

    public static Either<String, BitVector> fromBinDescriptive(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return BitVector$.MODULE$.fromBinDescriptive(string, binaryAlphabet);
    }

    public static BitVector fromByte(byte by, int n) {
        return BitVector$.MODULE$.fromByte(by, n);
    }

    public static BitVector fromChannel(ReadableByteChannel readableByteChannel, int n, boolean bl) {
        return BitVector$.MODULE$.fromChannel(readableByteChannel, n, bl);
    }

    public static Option<BitVector> fromHex(String string, Bases.HexAlphabet hexAlphabet) {
        return BitVector$.MODULE$.fromHex(string, hexAlphabet);
    }

    public static Either<String, BitVector> fromHexDescriptive(String string, Bases.HexAlphabet hexAlphabet) {
        return BitVector$.MODULE$.fromHexDescriptive(string, hexAlphabet);
    }

    public static BitVector fromInputStream(InputStream inputStream, int n) {
        return BitVector$.MODULE$.fromInputStream(inputStream, n);
    }

    public static BitVector fromInt(int n, int n2, ByteOrdering byteOrdering) {
        return BitVector$.MODULE$.fromInt(n, n2, byteOrdering);
    }

    public static BitVector fromLong(long l, int n, ByteOrdering byteOrdering) {
        return BitVector$.MODULE$.fromLong(l, n, byteOrdering);
    }

    public static BitVector fromMmap(FileChannel fileChannel, int n) {
        return BitVector$.MODULE$.fromMmap(fileChannel, n);
    }

    public static BitVector fromShort(short s, int n, ByteOrdering byteOrdering) {
        return BitVector$.MODULE$.fromShort(s, n, byteOrdering);
    }

    public static BitVector fromUUID(UUID uUID) {
        return BitVector$.MODULE$.fromUUID(uUID);
    }

    public static BitVector fromValidBase32(String string, Bases.Base32Alphabet base32Alphabet) {
        return BitVector$.MODULE$.fromValidBase32(string, base32Alphabet);
    }

    public static BitVector fromValidBase58(String string, Bases.Alphabet alphabet) {
        return BitVector$.MODULE$.fromValidBase58(string, alphabet);
    }

    public static BitVector fromValidBase64(String string, Bases.Base64Alphabet base64Alphabet) {
        return BitVector$.MODULE$.fromValidBase64(string, base64Alphabet);
    }

    public static BitVector fromValidBin(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return BitVector$.MODULE$.fromValidBin(string, binaryAlphabet);
    }

    public static BitVector fromValidHex(String string, Bases.HexAlphabet hexAlphabet) {
        return BitVector$.MODULE$.fromValidHex(string, hexAlphabet);
    }

    public static BitVector high(long l) {
        return BitVector$.MODULE$.high(l);
    }

    public static BitVector highByte() {
        return BitVector$.MODULE$.highByte();
    }

    public static BitVector low(long l) {
        return BitVector$.MODULE$.low(l);
    }

    public static BitVector lowByte() {
        return BitVector$.MODULE$.lowByte();
    }

    public static BitVector one() {
        return BitVector$.MODULE$.one();
    }

    public static int ordinal(BitVector bitVector) {
        return BitVector$.MODULE$.ordinal(bitVector);
    }

    public static <A> A reduceBalanced(Iterable<A> iterable, Function1<A, Object> function1, Function2<A, A, A> function2) {
        return BitVector$.MODULE$.reduceBalanced(iterable, function1, function2);
    }

    public static byte reverseBitsInByte(byte by) {
        return BitVector$.MODULE$.reverseBitsInByte(by);
    }

    public static Bytes toBytes(ByteVector byteVector, long l) {
        return BitVector$.MODULE$.toBytes(byteVector, l);
    }

    public static <S> BitVector unfold(S s, Function1<S, Option<Tuple2<BitVector, S>>> function1) {
        return BitVector$.MODULE$.unfold(s, function1);
    }

    public static BitVector view(ByteBuffer byteBuffer) {
        return BitVector$.MODULE$.view(byteBuffer);
    }

    public static BitVector view(ByteBuffer byteBuffer, long l) {
        return BitVector$.MODULE$.view(byteBuffer, l);
    }

    public static BitVector view(byte[] byArray) {
        return BitVector$.MODULE$.view(byArray);
    }

    public static BitVector view(byte[] byArray, long l) {
        return BitVector$.MODULE$.view(byArray, l);
    }

    public static BitVector zero() {
        return BitVector$.MODULE$.zero();
    }

    public static Bases.Base32Alphabet fromBase32$default$2() {
        return BitVector$.MODULE$.fromBase32$default$2();
    }

    public static Bases.Base32Alphabet fromBase32Descriptive$default$2() {
        return BitVector$.MODULE$.fromBase32Descriptive$default$2();
    }

    public static Bases.Alphabet fromBase58$default$2() {
        return BitVector$.MODULE$.fromBase58$default$2();
    }

    public static Bases.Alphabet fromBase58Descriptive$default$2() {
        return BitVector$.MODULE$.fromBase58Descriptive$default$2();
    }

    public static Bases.Base64Alphabet fromBase64$default$2() {
        return BitVector$.MODULE$.fromBase64$default$2();
    }

    public static Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return BitVector$.MODULE$.fromBase64Descriptive$default$2();
    }

    public static Bases.BinaryAlphabet fromBin$default$2() {
        return BitVector$.MODULE$.fromBin$default$2();
    }

    public static Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return BitVector$.MODULE$.fromBinDescriptive$default$2();
    }

    public static int fromByte$default$2() {
        return BitVector$.MODULE$.fromByte$default$2();
    }

    public static int fromChannel$default$2() {
        return BitVector$.MODULE$.fromChannel$default$2();
    }

    public static Bases.HexAlphabet fromHex$default$2() {
        return BitVector$.MODULE$.fromHex$default$2();
    }

    public static Bases.HexAlphabet fromHexDescriptive$default$2() {
        return BitVector$.MODULE$.fromHexDescriptive$default$2();
    }

    public static int fromInputStream$default$2() {
        return BitVector$.MODULE$.fromInputStream$default$2();
    }

    public static int fromInt$default$2() {
        return BitVector$.MODULE$.fromInt$default$2();
    }

    public static int fromLong$default$2() {
        return BitVector$.MODULE$.fromLong$default$2();
    }

    public static int fromMmap$default$2() {
        return BitVector$.MODULE$.fromMmap$default$2();
    }

    public static int fromShort$default$2() {
        return BitVector$.MODULE$.fromShort$default$2();
    }

    public static Bases.Base32Alphabet fromValidBase32$default$2() {
        return BitVector$.MODULE$.fromValidBase32$default$2();
    }

    public static Bases.Alphabet fromValidBase58$default$2() {
        return BitVector$.MODULE$.fromValidBase58$default$2();
    }

    public static Bases.Base64Alphabet fromValidBase64$default$2() {
        return BitVector$.MODULE$.fromValidBase64$default$2();
    }

    public static Bases.BinaryAlphabet fromValidBin$default$2() {
        return BitVector$.MODULE$.fromValidBin$default$2();
    }

    public static Bases.HexAlphabet fromValidHex$default$2() {
        return BitVector$.MODULE$.fromValidHex$default$2();
    }

    public static boolean fromChannel$default$3() {
        return BitVector$.MODULE$.fromChannel$default$3();
    }

    public static ByteOrdering fromInt$default$3() {
        return BitVector$.MODULE$.fromInt$default$3();
    }

    public static ByteOrdering fromLong$default$3() {
        return BitVector$.MODULE$.fromLong$default$3();
    }

    public static ByteOrdering fromShort$default$3() {
        return BitVector$.MODULE$.fromShort$default$3();
    }

    public BitVector() {
        Ordered.$init$((Ordered)this);
    }

    public abstract long size();

    public final long length() {
        return this.size();
    }

    public final boolean isEmpty() {
        return this.sizeLessThan(1L);
    }

    public final boolean nonEmpty() {
        return !this.isEmpty();
    }

    public final boolean sizeGreaterThan(long n) {
        return n < 0L || !this.sizeLessThanOrEqual(n);
    }

    public final boolean sizeGreaterThanOrEqual(long n) {
        return n < 0L || !this.sizeLessThanOrEqual(n - 1L);
    }

    public abstract boolean sizeLessThan(long var1);

    public final boolean sizeLessThanOrEqual(long n) {
        return n == Long.MAX_VALUE || this.sizeLessThan(n + 1L);
    }

    public final Option<Object> intSize() {
        if (this.size() <= Integer.MAX_VALUE) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.size())));
        }
        return None$.MODULE$;
    }

    public abstract boolean get(long var1);

    public abstract byte getByte(long var1);

    public final boolean apply(long n) {
        return this.get(n);
    }

    public final Option<Object> lift(long n) {
        if (this.sizeGreaterThan(n)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.get(n)));
        }
        return None$.MODULE$;
    }

    public BitVector unchunk() {
        return this;
    }

    public abstract BitVector update(long var1, boolean var3);

    public final BitVector insert(long idx, boolean b) {
        return this.take(idx).$colon$plus(b).$plus$plus(this.drop(idx));
    }

    public final BitVector splice(long idx, BitVector b) {
        return this.take(idx).$plus$plus(b).$plus$plus(this.drop(idx));
    }

    public final BitVector patch(long idx, BitVector b) {
        return this.take(idx).$plus$plus(b).$plus$plus(this.drop(idx + b.size()));
    }

    public final BitVector set(long n) {
        return this.update(n, true);
    }

    public final BitVector clear(long n) {
        return this.update(n, false);
    }

    public BitVector $plus$plus(BitVector b2) {
        if (this.isEmpty()) {
            return b2;
        }
        return BitVector$Chunks$.MODULE$.apply(BitVector$Append$.MODULE$.apply(this, b2));
    }

    public final BitVector $plus$colon(boolean b) {
        return BitVector$.MODULE$.bit(b).$plus$plus(this);
    }

    public final BitVector $colon$plus(boolean b) {
        return this.$plus$plus(BitVector$.MODULE$.bit(b));
    }

    public int depth() {
        BitVector bitVector = this;
        if (bitVector instanceof Append) {
            Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
            BitVector bitVector2 = append._1();
            BitVector bitVector3 = append._2();
            BitVector l = bitVector2;
            BitVector r = bitVector3;
            return 1 + RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(l.depth()), r.depth());
        }
        if (bitVector instanceof Chunks) {
            Chunks c = (Chunks)bitVector;
            return 1 + c.chunks().depth();
        }
        return 0;
    }

    public abstract BitVector drop(long var1);

    public final BitVector dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= this.size()) {
            return BitVector$.MODULE$.empty();
        }
        return this.take(this.size() - n);
    }

    public abstract BitVector take(long var1);

    public final BitVector takeRight(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(new StringBuilder(11).append("takeRight(").append(n).append(")").toString());
        }
        if (n >= this.size()) {
            return this;
        }
        return this.drop(this.size() - n);
    }

    public final Tuple2<BitVector, BitVector> splitAt(long n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    public final BitVector slice(long from, long until) {
        return this.drop(from).take(until - RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(from), 0L));
    }

    public Either<String, BitVector> acquire(long n) {
        if (this.sizeGreaterThanOrEqual(n)) {
            return package$.MODULE$.Right().apply((Object)this.take(n));
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(54).append("cannot acquire ").append(n).append(" bits from a vector that contains ").append(this.size()).append(" bits").toString());
    }

    public final <R> R acquireThen(long n, Function1<String, R> err, Function1<BitVector, R> f) {
        if (this.sizeGreaterThanOrEqual(n)) {
            return (R)f.apply((Object)this.take(n));
        }
        return (R)err.apply((Object)new StringBuilder(54).append("cannot acquire ").append(n).append(" bits from a vector that contains ").append(this.size()).append(" bits").toString());
    }

    public final <A> Either<String, Tuple2<BitVector, A>> consume(long n, Function1<BitVector, Either<String, A>> decode) {
        return this.acquire(n).flatMap((Function1 & Serializable)toDecode -> ((Either)decode.apply(toDecode)).map((Function1 & Serializable)decoded -> Tuple2$.MODULE$.apply((Object)this.drop(n), decoded)));
    }

    public final <R> R consumeThen(long n, Function1<String, R> err, Function2<BitVector, BitVector, R> f) {
        if (this.sizeGreaterThanOrEqual(n)) {
            return (R)f.apply((Object)this.take(n), (Object)this.drop(n));
        }
        return (R)err.apply((Object)new StringBuilder(54).append("cannot acquire ").append(n).append(" bits from a vector that contains ").append(this.size()).append(" bits").toString());
    }

    public final boolean startsWith(BitVector b) {
        return this.take(b.size()).$eq$eq$eq(b);
    }

    public final boolean endsWith(BitVector b) {
        return this.takeRight(b.size()).$eq$eq$eq(b);
    }

    public final long indexOfSlice(BitVector slice) {
        return this.indexOfSlice(slice, 0L);
    }

    public final long indexOfSlice(BitVector slice, long from) {
        return BitVector.go$1(slice, this.drop(from), from);
    }

    public final boolean containsSlice(BitVector slice) {
        return this.indexOfSlice(slice) >= 0L;
    }

    public final Stream<BitVector> grouped(long n) {
        return this.scodec$bits$BitVector$$groupedIterator(n).toStream();
    }

    public final Iterator<BitVector> scodec$bits$BitVector$$groupedIterator(long n) {
        if (this.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        return package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BitVector[]{this.take(n)})).$plus$plus(() -> this.groupedIterator$$anonfun$1(n));
    }

    public final boolean head() {
        return this.get(0L);
    }

    public final Option<Object> headOption() {
        return this.lift(0L);
    }

    public final BitVector tail() {
        return this.drop(1L);
    }

    public final BitVector init() {
        return this.dropRight(1L);
    }

    public final boolean last() {
        return this.apply(this.size() - 1L);
    }

    public final Option<Object> lastOption() {
        return this.lift(this.size() - 1L);
    }

    public final BitVector padTo(long n) {
        return this.padRight(n);
    }

    public final BitVector padRight(long n) {
        if (n < this.size()) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Trying to right-pad a vector of ").append(this.size()).append(" bits to only ").append(n).append(" bits.").toString());
        }
        return this.$plus$plus(BitVector$.MODULE$.fill(n - this.size(), false));
    }

    public final BitVector padLeft(long n) {
        if (n < this.size()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Trying to left-pad a vector of ").append(this.size()).append(" bits to only ").append(n).append(" bits.").toString());
        }
        return BitVector$.MODULE$.fill(n - this.size(), false).$plus$plus(this);
    }

    public final BitVector reverse() {
        return BitVector$.MODULE$.apply(this.compact().underlying().reverse().map((Function1<Object, Object>)(Function1 & Serializable)b -> BitVector$.MODULE$.reverseBitsInByte(BoxesRunTime.unboxToByte((Object)b)))).drop(8L - BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size()));
    }

    public final BitVector reverseByteOrder() {
        if (this.size() % 8L == 0L) {
            return BitVector$.MODULE$.toBytes(this.compact().underlying().reverse(), this.size());
        }
        long validFinalBits = BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size());
        Bytes last = this.take(validFinalBits).compact();
        ByteVector b = this.drop(validFinalBits).toByteVector().reverse();
        Bytes init = BitVector$.MODULE$.toBytes(b, this.size() - last.size());
        return init.$plus$plus(last);
    }

    public final BitVector invertReverseByteOrder() {
        if (this.size() % 8L == 0L) {
            return this.reverseByteOrder();
        }
        long validFinalBits = BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size());
        Tuple2<BitVector, BitVector> tuple2 = this.splitAt(this.size() - validFinalBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BitVector init = (BitVector)tuple2._1();
        BitVector last = (BitVector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)init, (Object)last);
        BitVector init2 = (BitVector)tuple22._1();
        BitVector last2 = (BitVector)tuple22._2();
        return last2.$plus$plus(init2.bytes().reverse().bits());
    }

    public final BitVector reverseBitOrder() {
        return BitVector$.MODULE$.apply(this.compact().underlying().map((Function1<Object, Object>)(Function1 & Serializable)b -> BitVector$.MODULE$.reverseBitsInByte(BoxesRunTime.unboxToByte((Object)b)))).dropRight(8L - BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size()));
    }

    public final long populationCount() {
        return BitVector.go$2(this, 0L);
    }

    @Override
    public final BitVector not() {
        return this.mapBytes((Function1<ByteVector, ByteVector>)(Function1 & Serializable)_$1 -> _$1.not());
    }

    @Override
    public final BitVector and(BitVector other) {
        return this.zipBytesWith(other, (Function2<Object, Object, Object>)(Function2 & Serializable)(_$2, _$3) -> BitVector.and$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$2), BoxesRunTime.unboxToByte((Object)_$3)));
    }

    @Override
    public final BitVector or(BitVector other) {
        return this.zipBytesWith(other, (Function2<Object, Object, Object>)(Function2 & Serializable)(_$4, _$5) -> BitVector.or$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$4), BoxesRunTime.unboxToByte((Object)_$5)));
    }

    @Override
    public final BitVector xor(BitVector other) {
        return this.zipBytesWith(other, (Function2<Object, Object, Object>)(Function2 & Serializable)(_$6, _$7) -> BitVector.xor$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$6), BoxesRunTime.unboxToByte((Object)_$7)));
    }

    @Override
    public final BitVector shiftLeft(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= this.size()) {
            return BitVector$.MODULE$.low(this.size());
        }
        return this.drop(n).$plus$plus(BitVector$.MODULE$.low(n));
    }

    @Override
    public final BitVector shiftRight(long n, boolean signExtension) {
        boolean extensionHigh;
        if (this.isEmpty() || n <= 0L) {
            return this;
        }
        boolean bl = extensionHigh = signExtension && this.head();
        if (n >= this.size()) {
            if (extensionHigh) {
                return BitVector$.MODULE$.high(this.size());
            }
            return BitVector$.MODULE$.low(this.size());
        }
        return (extensionHigh ? BitVector$.MODULE$.high(n) : BitVector$.MODULE$.low(n)).$plus$plus(this.dropRight(n));
    }

    @Override
    public final BitVector rotateLeft(long n) {
        if (n <= 0L) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        long n0 = n % this.size();
        if (n0 == 0L) {
            return this;
        }
        return this.drop(n0).$plus$plus(this.take(n0));
    }

    @Override
    public final BitVector rotateRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        long n0 = n % this.size();
        if (n0 == 0L) {
            return this;
        }
        return this.takeRight(n0).$plus$plus(this.dropRight(n0));
    }

    public final Bytes compact() {
        if (BitVector$.MODULE$.scodec$bits$BitVector$$$bytesNeededForBits(this.size()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(37).append("cannot compact bit vector of size ").append((double)this.size() / (double)8 / 1.0E9).append(" GB").toString());
        }
        BitVector bitVector = this;
        if (bitVector instanceof Bytes) {
            Bytes bytes = (Bytes)bitVector;
            Bytes bytes2 = BitVector$Bytes$.MODULE$.unapply(bytes);
            ByteVector byteVector = bytes2._1();
            long l = bytes2._2();
            ByteVector b = byteVector;
            long n = l;
            Bytes bs = bytes;
            ByteVector b2 = b.compact();
            if (b2 == b) {
                return bs;
            }
            return BitVector$Bytes$.MODULE$.apply(b2, n);
        }
        if (bitVector instanceof Drop) {
            Drop d = (Drop)bitVector;
            Bytes bs = d.interpretDrop();
            ByteVector b2 = bs.underlying().compact();
            if (b2 == bs.underlying()) {
                return bs;
            }
            return BitVector$Bytes$.MODULE$.apply(b2, bs.size());
        }
        Bytes bytes = (Bytes)BitVector$.MODULE$.reduceBalanced(BitVector.go$3((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BitVector[]{this})), (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), (Function1 & Serializable)_$8 -> _$8.size(), (Function2 & Serializable)(_$9, _$10) -> _$9.combine((Bytes)_$10));
        if (bytes != null) {
            Bytes bytes3 = BitVector$Bytes$.MODULE$.unapply(bytes);
            ByteVector byteVector = bytes3._1();
            long l = bytes3._2();
            ByteVector b = byteVector;
            long n = l;
            return BitVector$Bytes$.MODULE$.apply(b.compact(), n);
        }
        throw new MatchError((Object)bytes);
    }

    public abstract Bytes align();

    public final Bytes copy() {
        BitVector bitVector = this;
        if (bitVector instanceof Bytes) {
            Bytes bytes = BitVector$Bytes$.MODULE$.unapply((Bytes)bitVector);
            ByteVector byteVector = bytes._1();
            long l = bytes._2();
            ByteVector b = byteVector;
            long n = l;
            return BitVector$Bytes$.MODULE$.apply(b.copy(), n);
        }
        return this.compact();
    }

    public final BitVector force() {
        return BitVector.go$4((Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BitVector[]{this})));
    }

    public final scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return (scala.collection.immutable.IndexedSeq)this.intSize().map((Function1 & Serializable)n -> this.toIndexedSeq$$anonfun$1(BoxesRunTime.unboxToInt((Object)n))).getOrElse(this::toIndexedSeq$$anonfun$2);
    }

    public final ByteVector toByteVector() {
        return BitVector$.MODULE$.scodec$bits$BitVector$$$clearUnneededBits(this.size(), this.compact().underlying());
    }

    public final ByteVector bytes() {
        return this.toByteVector();
    }

    public final byte[] toByteArray() {
        return this.toByteVector().toArray();
    }

    public final ByteBuffer toByteBuffer() {
        return this.toByteVector().toByteBuffer();
    }

    public final String toBin() {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.toByteVector().toBin()), (int)this.size());
    }

    public final String toBin(Bases.BinaryAlphabet alphabet) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.toByteVector().toBin(alphabet)), (int)this.size());
    }

    public final String toHex() {
        return this.toHex(Bases$Alphabets$HexLowercase$.MODULE$);
    }

    public final String toHex(Bases.HexAlphabet alphabet) {
        String full = this.toByteVector().toHex(alphabet);
        long l = this.size() % 8L;
        if (0L == l) {
            return full;
        }
        long n = l;
        if (n <= 4L) {
            return StringOps$.MODULE$.init$extension(Predef$.MODULE$.augmentString(full));
        }
        return full;
    }

    public final String toHexDump() {
        return HexDumpFormat$.MODULE$.NoAnsi().render((Function0<BitVector>)((Function0 & Serializable)this::toHexDump$$anonfun$1));
    }

    public final String toHexDumpColorized() {
        return HexDumpFormat$.MODULE$.Default().render((Function0<BitVector>)((Function0 & Serializable)this::toHexDumpColorized$$anonfun$1));
    }

    public final void printHexDump() {
        HexDumpFormat$.MODULE$.Default().print((Function0<BitVector>)((Function0 & Serializable)this::printHexDump$$anonfun$1));
    }

    public final String toBase16() {
        return this.toHex();
    }

    public final String toBase16(Bases.HexAlphabet alphabet) {
        return this.toHex(alphabet);
    }

    public final String toBase32() {
        return this.toBase32(Bases$Alphabets$Base32$.MODULE$);
    }

    public final String toBase32(Bases.Base32Alphabet alphabet) {
        return this.toByteVector().toBase32(alphabet);
    }

    public final String toBase58() {
        return this.toBase58(Bases$Alphabets$Base58$.MODULE$);
    }

    public final String toBase58(Bases.Alphabet alphabet) {
        return this.toByteVector().toBase58(alphabet);
    }

    public final String toBase64() {
        return this.toBase64(Bases$Alphabets$Base64$.MODULE$);
    }

    public final String toBase64(Bases.Base64Alphabet alphabet) {
        return this.toByteVector().toBase64(alphabet);
    }

    public final String toBase64NoPad() {
        return this.toByteVector().toBase64NoPad();
    }

    public final String toBase64Url() {
        return this.toByteVector().toBase64Url();
    }

    public final String toBase64UrlNoPad() {
        return this.toByteVector().toBase64UrlNoPad();
    }

    public final byte sliceToByte(long start, int bits, boolean signed) {
        while (start % 8L != 0L) {
            BitVector bitVector = this_.drop(start);
            long l = 0L;
            BitVector this_ = bitVector;
            start = l;
        }
        if (this_.isEmpty() || bits == 0) {
            return (byte)0;
        }
        return this_.getByte(start, bits, signed);
    }

    public boolean sliceToByte$default$3() {
        return true;
    }

    private byte getByte(long start, int bits, boolean signed) {
        Predef$.MODULE$.require(this.sizeGreaterThanOrEqual(start + (long)bits) && bits >= 0 && bits <= 8);
        int result = 0xFF & this.getByte(start / 8L);
        if (bits != 0) {
            result >>>= 8 - bits;
        }
        if (signed && bits != 8 && (1 << bits - 1 & result) != 0) {
            int toShift = 32 - bits;
            result = result << toShift >> toShift;
        }
        return (byte)result;
    }

    public final byte toByte(boolean signed) {
        Predef$.MODULE$.require(this.sizeLessThanOrEqual(8L));
        if (this.isEmpty()) {
            return (byte)0;
        }
        return this.getByte(0L, (int)this.size(), signed);
    }

    public boolean toByte$default$1() {
        return true;
    }

    public final short sliceToShort(long start, int bits, boolean signed, ByteOrdering ordering) {
        while (true) {
            BitVector this_;
            if (start % 8L != 0L) {
                BitVector bitVector = this_.drop(start);
                long l = 0L;
                this_ = bitVector;
                start = l;
                continue;
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = this_.drop(start).invertReverseByteOrder();
            long l = 0L;
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            this_ = bitVector;
            start = l;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianShort(start, bits, signed);
    }

    public boolean sliceToShort$default$3() {
        return true;
    }

    public ByteOrdering sliceToShort$default$4() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    private short getBigEndianShort(long start, int bits, boolean signed) {
        Predef$.MODULE$.require(this.sizeGreaterThanOrEqual(start + (long)bits) && bits >= 0 && bits <= 16);
        int mod = bits % 8;
        IntRef result = IntRef.create((int)0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$$bytesNeededForBits(bits);
        long base = start / 8L;
        this.go$5(result, bytesNeeded, base, 0);
        if (mod != 0) {
            int n;
            result.elem = n = result.elem >>> 8 - mod;
        }
        if (signed && bits != 16 && (1 << bits - 1 & result.elem) != 0) {
            int n;
            int toShift = 32 - bits;
            result.elem = n = result.elem << toShift >> toShift;
        }
        return (short)result.elem;
    }

    public final short toShort(boolean signed, ByteOrdering ordering) {
        while (true) {
            Predef$.MODULE$.require(this_.sizeLessThanOrEqual(16L));
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = this_.invertReverseByteOrder();
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            BitVector this_ = bitVector;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianShort(0L, (int)this_.size(), signed);
    }

    public boolean toShort$default$1() {
        return true;
    }

    public ByteOrdering toShort$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final int sliceToInt(long start, int bits, boolean signed, ByteOrdering ordering) {
        while (true) {
            BitVector this_;
            if (start % 8L != 0L) {
                BitVector bitVector = this_.drop(start);
                long l = 0L;
                this_ = bitVector;
                start = l;
                continue;
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = this_.drop(start).invertReverseByteOrder();
            long l = 0L;
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            this_ = bitVector;
            start = l;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianInt(start, bits, signed);
    }

    public boolean sliceToInt$default$3() {
        return true;
    }

    public ByteOrdering sliceToInt$default$4() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    private int getBigEndianInt(long start, int bits, boolean signed) {
        Predef$.MODULE$.require(this.sizeGreaterThanOrEqual(start + (long)bits) && bits >= 0 && bits <= 32);
        int mod = bits % 8;
        IntRef result = IntRef.create((int)0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$$bytesNeededForBits(bits);
        long base = start / 8L;
        this.go$6(result, bytesNeeded, base, 0);
        if (mod != 0) {
            int n;
            result.elem = n = result.elem >>> 8 - mod;
        }
        if (signed && bits != 32 && (1 << bits - 1 & result.elem) != 0) {
            int n;
            int toShift = 32 - bits;
            result.elem = n = result.elem << toShift >> toShift;
        }
        return result.elem;
    }

    public final int toInt(boolean signed, ByteOrdering ordering) {
        while (true) {
            BitVector this_;
            Predef$.MODULE$.require(this_.sizeLessThanOrEqual(32L));
            BitVector bitVector = this_;
            if (bitVector instanceof Bytes) {
                Bytes bytes = (Bytes)bitVector;
                int n = (int)this_.size();
                if (32 == n && signed) {
                    return bytes.underlying().toByteBuffer().order(ordering.toJava()).getInt();
                }
                if (16 == n) {
                    short sh = bytes.underlying().toByteBuffer().order(ordering.toJava()).getShort();
                    if (signed) {
                        return sh;
                    }
                    return sh & 0xFFFF;
                }
                if (8 == n) {
                    byte b = bytes.underlying().toByteBuffer().get();
                    if (signed) {
                        return b;
                    }
                    return b & 0xFF;
                }
                int bits = n;
                ByteOrdering byteOrdering = ordering;
                ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
                if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null)) {
                    BitVector bitVector2 = this_.invertReverseByteOrder();
                    ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
                    this_ = bitVector2;
                    ordering = byteOrdering$BigEndian$;
                    continue;
                }
                return this_.getBigEndianInt(0L, bits, signed);
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector3 = this_.invertReverseByteOrder();
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            this_ = bitVector3;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianInt(0L, (int)this_.size(), signed);
    }

    public boolean toInt$default$1() {
        return true;
    }

    public ByteOrdering toInt$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final long sliceToLong(long start, int bits, boolean signed, ByteOrdering ordering) {
        while (true) {
            BitVector this_;
            if (start % 8L != 0L) {
                BitVector bitVector = this_.drop(start);
                long l = 0L;
                this_ = bitVector;
                start = l;
                continue;
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = this_.drop(start).invertReverseByteOrder();
            long l = 0L;
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            this_ = bitVector;
            start = l;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianLong(start, bits, signed);
    }

    public boolean sliceToLong$default$3() {
        return true;
    }

    public ByteOrdering sliceToLong$default$4() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    private long getBigEndianLong(long start, int bits, boolean signed) {
        Predef$.MODULE$.require(this.sizeGreaterThanOrEqual(start + (long)bits) && bits >= 0 && bits <= 64);
        int mod = bits % 8;
        LongRef result = LongRef.create((long)0L);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$$bytesNeededForBits(bits);
        long base = start / 8L;
        this.go$7(result, bytesNeeded, base, 0);
        if (mod != 0) {
            long l;
            result.elem = l = result.elem >>> 8 - mod;
        }
        if (signed && bits != 64 && (1L << bits - 1 & result.elem) != 0L) {
            long l;
            int toShift = 64 - bits;
            result.elem = l = result.elem << toShift >> toShift;
        }
        return result.elem;
    }

    public final long toLong(boolean signed, ByteOrdering ordering) {
        while (true) {
            BitVector this_;
            Predef$.MODULE$.require(this_.sizeLessThanOrEqual(64L));
            BitVector bitVector = this_;
            if (bitVector instanceof Bytes) {
                Bytes bytes = (Bytes)bitVector;
                int n = (int)this_.size();
                if (64 == n && signed) {
                    return bytes.underlying().toByteBuffer().order(ordering.toJava()).getLong();
                }
                switch (n) {
                    case 32: {
                        int i = bytes.underlying().toByteBuffer().order(ordering.toJava()).getInt();
                        if (signed) {
                            return i;
                        }
                        return (long)i & 0xFFFFFFFFL;
                    }
                    case 16: {
                        short sh = bytes.underlying().toByteBuffer().order(ordering.toJava()).getShort();
                        if (signed) {
                            return sh;
                        }
                        return (long)sh & 0xFFFFL;
                    }
                    case 8: {
                        byte b = bytes.underlying().toByteBuffer().get();
                        if (signed) {
                            return b;
                        }
                        return (long)b & 0xFFL;
                    }
                }
                int bits = n;
                ByteOrdering byteOrdering = ordering;
                ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
                if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null)) {
                    BitVector bitVector2 = this_.invertReverseByteOrder();
                    ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
                    this_ = bitVector2;
                    ordering = byteOrdering$BigEndian$;
                    continue;
                }
                return this_.getBigEndianLong(0L, bits, signed);
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector3 = this_.invertReverseByteOrder();
            ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
            this_ = bitVector3;
            ordering = byteOrdering$BigEndian$;
        }
        return this_.getBigEndianLong(0L, (int)this_.size(), signed);
    }

    public boolean toLong$default$1() {
        return true;
    }

    public ByteOrdering toLong$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final UUID toUUID() {
        if (this.size() != 128L) {
            throw new IllegalArgumentException(new StringBuilder(59).append("Cannot convert BitVector of size ").append(this.size()).append(" to UUID; must be 128 bits").toString());
        }
        ByteBuffer byteBuffer = this.toByteBuffer();
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public final Either<CharacterCodingException, String> decodeString(Charset charset) {
        return this.bytes().decodeString(charset);
    }

    public final Either<CharacterCodingException, String> decodeUtf8() {
        return this.bytes().decodeUtf8();
    }

    public final Either<CharacterCodingException, String> decodeAscii() {
        return this.bytes().decodeAscii();
    }

    public final boolean $eq$eq$eq(BitVector other) {
        if (this == other) {
            return true;
        }
        if (this.length() != other.length()) {
            return false;
        }
        long chunkSize = 524288L;
        return BitVector.go$8(chunkSize, this, other);
    }

    public final boolean equals(Object other) {
        Object object = other;
        if (object instanceof BitVector) {
            BitVector o = (BitVector)object;
            return this.$eq$eq$eq(o);
        }
        return false;
    }

    public final int hashCode() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    int n;
                    long chunkSize = 524288L;
                    this.hashCode$lzy1 = n = BitVector.go$9(chunkSize, this, MurmurHash3$.MODULE$.stringHash("BitVector"), 1);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return n;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.hashCode$lzy1;
    }

    public final String toString() {
        if (this.isEmpty()) {
            return "BitVector(empty)";
        }
        if (this.sizeLessThan(513L)) {
            return new StringBuilder(20).append("BitVector(").append(this.size()).append(" bits, 0x").append(this.toHex()).append(")").toString();
        }
        return new StringBuilder(19).append("BitVector(").append(this.size()).append(" bits, #").append(this.hashCode()).append(")").toString();
    }

    public final void checkBounds(long n) {
        if (!this.sizeGreaterThan(n)) {
            throw this.outOfBounds(n);
        }
    }

    public final Nothing$ outOfBounds(long n) {
        throw new NoSuchElementException(new StringBuilder(19).append("invalid index: ").append(n).append(" of ").append(this.size()).toString());
    }

    public final BitVector mapBytes(Function1<ByteVector, ByteVector> f) {
        BitVector bitVector;
        BitVector bitVector2 = this;
        if (bitVector2 instanceof Bytes) {
            Bytes bytes = BitVector$Bytes$.MODULE$.unapply((Bytes)bitVector2);
            ByteVector byteVector = bytes._1();
            long l = bytes._2();
            ByteVector bs = byteVector;
            long n = l;
            bitVector = BitVector$.MODULE$.toBytes((ByteVector)f.apply((Object)bs), n);
        } else if (bitVector2 instanceof Append) {
            Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector2);
            BitVector bitVector3 = append._1();
            BitVector bitVector4 = append._2();
            BitVector l = bitVector3;
            BitVector r = bitVector4;
            bitVector = BitVector$Append$.MODULE$.apply(l.mapBytes(f), r.mapBytes(f));
        } else if (bitVector2 instanceof Drop) {
            Drop drop = BitVector$Drop$.MODULE$.unapply((Drop)bitVector2);
            Bytes bytes = drop._1();
            long l = drop._2();
            Bytes b = bytes;
            long n = l;
            bitVector = BitVector$Drop$.MODULE$.apply(b.mapBytes(f).compact(), n);
        } else if (bitVector2 instanceof Suspend) {
            Suspend suspend = BitVector$Suspend$.MODULE$.unapply((Suspend)bitVector2);
            Function0<BitVector> function0 = suspend._1();
            Suspend s = (Suspend)bitVector2;
            bitVector = BitVector$Suspend$.MODULE$.apply((Function0<BitVector>)(Function0 & Serializable)() -> s.underlying().mapBytes(f));
        } else if (bitVector2 instanceof Chunks) {
            Chunks c = (Chunks)bitVector2;
            bitVector = BitVector$Chunks$.MODULE$.apply(BitVector$Append$.MODULE$.apply(c.chunks().left().mapBytes(f), c.chunks().right().mapBytes(f)));
        } else {
            throw new MatchError((Object)bitVector2);
        }
        return bitVector;
    }

    public String internalPretty(String prefix) {
        BitVector bitVector = this;
        if (bitVector instanceof Append) {
            Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
            BitVector bitVector2 = append._1();
            BitVector bitVector3 = append._2();
            BitVector l = bitVector2;
            BitVector r = bitVector3;
            return new StringBuilder(8).append(prefix).append("append\n").append(l.internalPretty(new StringBuilder(2).append(prefix).append("  ").toString())).append("\n").append(r.internalPretty(new StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (bitVector instanceof Bytes) {
            Bytes bytes = BitVector$Bytes$.MODULE$.unapply((Bytes)bitVector);
            ByteVector byteVector = bytes._1();
            long l = bytes._2();
            ByteVector b = byteVector;
            long n = l;
            return new StringBuilder(0).append(prefix).append(new StringBuilder(6).append("bits ").append(n).append("\n").toString()).append(b.pretty(new StringBuilder(2).append("  ").append(prefix).toString())).toString();
        }
        if (bitVector instanceof Drop) {
            Drop drop = BitVector$Drop$.MODULE$.unapply((Drop)bitVector);
            Bytes bytes = drop._1();
            long l = drop._2();
            Bytes u = bytes;
            long n = l;
            return new StringBuilder(0).append(prefix).append(new StringBuilder(6).append("drop ").append(n).append("\n").toString()).append(u.internalPretty(new StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (bitVector instanceof Suspend) {
            Suspend suspend = BitVector$Suspend$.MODULE$.unapply((Suspend)bitVector);
            Function0<BitVector> function0 = suspend._1();
            Suspend s = (Suspend)bitVector;
            return new StringBuilder(8).append(prefix).append("suspend\n").append(s.underlying().internalPretty(new StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (bitVector instanceof Chunks) {
            Chunks c = (Chunks)bitVector;
            return new StringBuilder(8).append(prefix).append("chunks\n").append(c.chunks().left().internalPretty("  ")).append("\n").append(c.chunks().right().internalPretty("  ")).toString();
        }
        throw new MatchError((Object)bitVector);
    }

    private BitVector zipBytesWith(BitVector other, Function2<Object, Object, Object> op) {
        return BitVector$.MODULE$.toBytes(this.compact().underlying().zipWithI(other.compact().underlying(), op), RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), other.size()));
    }

    public final Object writeReplace() {
        return new SerializationProxy(this.toByteArray(), this.size());
    }

    public int compare(BitVector that) {
        if (this == that) {
            return 0;
        }
        long thisLength = this.length();
        long thatLength = that.length();
        long commonLength = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(thisLength), thatLength);
        int i = 0;
        while ((long)i < commonLength) {
            int cmp = new RichBoolean(Predef$.MODULE$.booleanWrapper(this.apply(i))).compare((Object)BoxesRunTime.boxToBoolean((boolean)that.apply(i)));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (thisLength < thatLength) {
            return -1;
        }
        if (thisLength > thatLength) {
            return 1;
        }
        return 0;
    }

    private static final long go$1(BitVector slice$1, BitVector b, long idx) {
        while (!b.startsWith(slice$1)) {
            if (b.isEmpty()) {
                return -1L;
            }
            BitVector bitVector = b.tail();
            long l = idx + 1L;
            b = bitVector;
            idx = l;
        }
        return idx;
    }

    private final IterableOnce groupedIterator$$anonfun$1(long n$3) {
        return this.drop(n$3).scodec$bits$BitVector$$groupedIterator(n$3);
    }

    private static final long go$2(BitVector b, long acc) {
        while (!b.isEmpty()) {
            BitVector bitVector = b.tail();
            long l = b.head() ? acc + 1L : acc;
            b = bitVector;
            acc = l;
        }
        return acc;
    }

    private static final /* synthetic */ int and$$anonfun$1(byte _$2, byte _$3) {
        return (byte)(_$2 & _$3);
    }

    private static final /* synthetic */ int or$$anonfun$1(byte _$4, byte _$5) {
        return (byte)(_$4 | _$5);
    }

    private static final /* synthetic */ int xor$$anonfun$1(byte _$6, byte _$7) {
        return (byte)(_$6 ^ _$7);
    }

    private static final Vector go$3(List b, Vector acc) {
        List list;
        while ((list = b) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BitVector bitVector = (BitVector)colon2.head();
            List list2 = colon2.next$access$1();
            if (bitVector instanceof Suspend) {
                Suspend suspend = BitVector$Suspend$.MODULE$.unapply((Suspend)bitVector);
                Function0<BitVector> function0 = suspend._1();
                Suspend s = (Suspend)bitVector;
                List rem = list2;
                BitVector bitVector2 = s.underlying();
                b = rem.$colon$colon((Object)bitVector2);
                continue;
            }
            if (bitVector instanceof Bytes) {
                List rem;
                Bytes bytes = BitVector$Bytes$.MODULE$.unapply((Bytes)bitVector);
                ByteVector byteVector = bytes._1();
                long l = bytes._2();
                Bytes b2 = (Bytes)bitVector;
                List list3 = rem = list2;
                Vector vector = (Vector)acc.$colon$plus((Object)b2);
                b = list3;
                acc = vector;
                continue;
            }
            if (bitVector instanceof Append) {
                Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                BitVector bitVector3 = append._1();
                BitVector bitVector4 = append._2();
                BitVector l = bitVector3;
                BitVector r = bitVector4;
                List rem = list2;
                b = rem.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (bitVector instanceof Drop) {
                List rem;
                Drop d = (Drop)bitVector;
                List list4 = rem = list2;
                Vector vector = (Vector)acc.$colon$plus((Object)d.interpretDrop());
                b = list4;
                acc = vector;
                continue;
            }
            if (!(bitVector instanceof Chunks)) break;
            Chunks c = (Chunks)bitVector;
            List rem = list2;
            b = rem.$colon$colon((Object)c.chunks().right()).$colon$colon((Object)c.chunks().left());
        }
        return acc;
    }

    private static final BitVector go$4(Vector cont) {
        while (cont.nonEmpty()) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(cont.head(), (Object)cont.tail());
            if (tuple2 != null) {
                BitVector cur = (BitVector)tuple2._1();
                Vector cont2 = (Vector)tuple2._2();
                BitVector bitVector = cur;
                if (bitVector instanceof Bytes) {
                    Bytes bytes = BitVector$Bytes$.MODULE$.unapply((Bytes)bitVector);
                    ByteVector byteVector = bytes._1();
                    long l = bytes._2();
                    Bytes b = (Bytes)bitVector;
                    return (BitVector)cont2.foldLeft((Object)b, (Function2 & Serializable)(_$11, _$12) -> _$11.$plus$plus((BitVector)_$12));
                }
                if (bitVector instanceof Append) {
                    Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                    BitVector bitVector2 = append._1();
                    BitVector bitVector3 = append._2();
                    BitVector l = bitVector2;
                    BitVector r = bitVector3;
                    cont = (Vector)((SeqOps)cont2.$plus$colon((Object)r)).$plus$colon((Object)l);
                    continue;
                }
                if (bitVector instanceof Drop) {
                    Drop drop = BitVector$Drop$.MODULE$.unapply((Drop)bitVector);
                    Bytes bytes = drop._1();
                    long l = drop._2();
                    Drop d = (Drop)bitVector;
                    return (BitVector)cont2.foldLeft((Object)d, (Function2 & Serializable)(_$13, _$14) -> _$13.$plus$plus((BitVector)_$14));
                }
                if (bitVector instanceof Suspend) {
                    Suspend suspend = BitVector$Suspend$.MODULE$.unapply((Suspend)bitVector);
                    Function0<BitVector> function0 = suspend._1();
                    Suspend s = (Suspend)bitVector;
                    BitVector bitVector4 = s.underlying();
                    cont = (Vector)cont2.$plus$colon((Object)bitVector4);
                    continue;
                }
                if (bitVector instanceof Chunks) {
                    Chunks b = (Chunks)bitVector;
                    cont = (Vector)cont2.$plus$colon((Object)b.chunks());
                    continue;
                }
                throw new MatchError((Object)bitVector);
            }
            throw new MatchError((Object)tuple2);
        }
        return (BitVector)cont.foldLeft((Object)BitVector$.MODULE$.empty(), (Function2 & Serializable)(_$15, _$16) -> _$15.$plus$plus((BitVector)_$16));
    }

    private final /* synthetic */ scala.collection.immutable.IndexedSeq toIndexedSeq$$anonfun$1(int n) {
        return new scala.collection.immutable.IndexedSeq<Object>(n, this){
            private final int n$4;
            private final /* synthetic */ BitVector $outer;
            {
                this.n$4 = n$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
                scala.collection.immutable.Iterable.$init$((scala.collection.immutable.Iterable)this);
                PartialFunction.$init$((PartialFunction)this);
                SeqOps.$init$((SeqOps)this);
                Seq.$init$((Seq)this);
                scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
                scala.collection.IndexedSeqOps.$init$((scala.collection.IndexedSeqOps)this);
                IndexedSeq.$init$((IndexedSeq)this);
                IndexedSeqOps.$init$((IndexedSeqOps)this);
                scala.collection.immutable.IndexedSeq.$init$((scala.collection.immutable.IndexedSeq)this);
            }

            public scala.collection.immutable.IndexedSeq scala$collection$SeqOps$$super$concat(IterableOnce suffix) {
                return (scala.collection.immutable.IndexedSeq)IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public int scala$collection$SeqOps$$super$sizeCompare(Iterable that) {
                return IterableOps.sizeCompare$((IterableOps)this, (Iterable)that);
            }

            public scala.collection.immutable.IndexedSeq scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
                return (scala.collection.immutable.IndexedSeq)scala.collection.IndexedSeqOps.slice$((scala.collection.IndexedSeqOps)this, (int)from, (int)until);
            }

            public boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
                return Seq.canEqual$((Seq)this, (Object)that);
            }

            public boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
                return SeqOps.sameElements$((SeqOps)this, (IterableOnce)that);
            }

            public int length() {
                return this.n$4;
            }

            public boolean apply(int idx) {
                return this.apply$mcZI$sp(idx);
            }

            public boolean apply$mcZI$sp(int idx) {
                return this.$outer.get(idx);
            }

            public Object foldRight(Object z, Function2 op) {
                Iterator it = this.reverseIterator();
                Object b = z;
                while (it.hasNext()) {
                    b = op.apply(it.next(), b);
                }
                return b;
            }
        };
    }

    private final scala.collection.immutable.IndexedSeq toIndexedSeq$$anonfun$2() {
        throw new IllegalArgumentException(new StringBuilder(27).append("BitVector too big for Seq: ").append(this.size()).toString());
    }

    private final BitVector toHexDump$$anonfun$1() {
        return this;
    }

    private final BitVector toHexDumpColorized$$anonfun$1() {
        return this;
    }

    private final BitVector printHexDump$$anonfun$1() {
        return this;
    }

    private final void go$5(IntRef result$1, long bytesNeeded$1, long base$1, int i) {
        while ((long)i < bytesNeeded$1) {
            int n;
            result$1.elem = n = result$1.elem << 8 | 0xFF & this.getByte(base$1 + (long)i);
            ++i;
        }
    }

    private final void go$6(IntRef result$2, long bytesNeeded$2, long base$2, int i) {
        while ((long)i < bytesNeeded$2) {
            int n;
            result$2.elem = n = result$2.elem << 8 | 0xFF & this.getByte(base$2 + (long)i);
            ++i;
        }
    }

    private final void go$7(LongRef result$3, long bytesNeeded$3, long base$3, int i) {
        while ((long)i < bytesNeeded$3) {
            long l;
            result$3.elem = l = result$3.elem << 8 | 0xFFL & (long)this.getByte(base$3 + (long)i);
            ++i;
        }
    }

    private static final boolean go$8(long chunkSize$1, BitVector x, BitVector y) {
        while (true) {
            if (x.isEmpty()) {
                return y.isEmpty();
            }
            BitVector chunkX = x.take(chunkSize$1);
            BitVector chunkY = y.take(chunkSize$1);
            if (!chunkX.toByteVector().$eq$eq$eq(chunkY.toByteVector())) break;
            BitVector bitVector = x.drop(chunkSize$1);
            BitVector bitVector2 = y.drop(chunkSize$1);
            x = bitVector;
            y = bitVector2;
        }
        return false;
    }

    private static final int go$9(long chunkSize$2, BitVector bits, int h, int iter) {
        while (!bits.isEmpty()) {
            BitVector bitVector = bits.drop(chunkSize$2);
            int n = MurmurHash3$.MODULE$.mix(h, MurmurHash3$.MODULE$.bytesHash(bits.take(chunkSize$2).toByteArray()));
            int n2 = iter + 1;
            bits = bitVector;
            h = n;
            iter = n2;
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, iter);
    }

    public static class Append
    extends BitVector
    implements Product {
        private final BitVector left;
        private final BitVector right;
        private volatile long knownSize;
        private long sizeLowerBound;

        public static Append fromProduct(Product product) {
            return BitVector$Append$.MODULE$.fromProduct(product);
        }

        public static Append unapply(Append append) {
            return BitVector$Append$.MODULE$.unapply(append);
        }

        public Append(BitVector left, BitVector right) {
            long sz;
            this.left = left;
            this.right = right;
            BitVector bitVector = right;
            this.knownSize = bitVector instanceof Suspend ? -1L : (sz = left.size() + right.size());
            this.sizeLowerBound = left.size();
        }

        public boolean canEqual(Object that) {
            return that instanceof Append;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Append";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "left";
            }
            if (1 == n2) {
                return "right";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BitVector left() {
            return this.left;
        }

        public BitVector right() {
            return this.right;
        }

        @Override
        public boolean get(long n) {
            if (n < this.left().size()) {
                return this.left().get(n);
            }
            return this.right().get(n - this.left().size());
        }

        @Override
        public byte getByte(long n) {
            if (n < this.left().size() / 8L) {
                return this.left().getByte(n);
            }
            if (this.left().size() % 8L == 0L && n > this.left().size() / 8L) {
                return this.right().getByte(n - this.left().size() / 8L);
            }
            return this.drop(n * 8L).take(8L).align().getByte(0L);
        }

        @Override
        public BitVector update(long n, boolean high) {
            if (n < this.left().size()) {
                return BitVector$Append$.MODULE$.apply(this.left().update(n, high), this.right());
            }
            return BitVector$Append$.MODULE$.apply(this.left(), this.right().update(n - this.left().size(), high));
        }

        @Override
        public Bytes align() {
            return this.left().align().combine(this.right().align());
        }

        public long knownSize() {
            return this.knownSize;
        }

        public void knownSize_$eq(long x$1) {
            this.knownSize = x$1;
        }

        public long sizeLowerBound() {
            return this.sizeLowerBound;
        }

        public void sizeLowerBound_$eq(long x$1) {
            this.sizeLowerBound = x$1;
        }

        @Override
        public long size() {
            if (this.knownSize() != -1L) {
                return this.knownSize();
            }
            long sz = this.go$10((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BitVector[]{this.left(), this.right()})), 0L);
            this.knownSize_$eq(sz);
            return sz;
        }

        @Override
        public BitVector take(long n) {
            long npos = scala.math.package$.MODULE$.max(0L, n);
            if (npos == 0L) {
                return BitVector$.MODULE$.empty();
            }
            if (npos <= this.left().size()) {
                return this.left().take(npos);
            }
            return this.go$11(this.left(), this.right(), npos - this.left().size());
        }

        @Override
        public BitVector drop(long n) {
            long npos = scala.math.package$.MODULE$.max(0L, n);
            if (npos == 0L) {
                return this;
            }
            if (npos >= this.left().size()) {
                return this.go$12(this.right(), npos - this.left().size());
            }
            return BitVector$Append$.MODULE$.apply(this.left().drop(npos), this.right());
        }

        @Override
        public boolean sizeLessThan(long n) {
            if (this.knownSize() != -1L) {
                return this.knownSize() < n;
            }
            if (this.sizeLowerBound() >= n) {
                return false;
            }
            return this.go$13(this, n, 0L);
        }

        public Append copy(BitVector left, BitVector right) {
            return new Append(left, right);
        }

        public BitVector copy$default$1() {
            return this.left();
        }

        public BitVector copy$default$2() {
            return this.right();
        }

        public BitVector _1() {
            return this.left();
        }

        public BitVector _2() {
            return this.right();
        }

        private final long go$10(List rem, long acc) {
            List list;
            while (true) {
                List t;
                Chunks chunks;
                Append append;
                list = rem;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return acc;
                }
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                BitVector bitVector = (BitVector)colon2.head();
                List list3 = colon2.next$access$1();
                if (bitVector instanceof Append) {
                    Append append2 = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                    BitVector bitVector2 = append2._1();
                    BitVector bitVector3 = append2._2();
                    BitVector x = bitVector2;
                    BitVector y = bitVector3;
                    List t2 = list3;
                    rem = t2.$colon$colon((Object)y).$colon$colon((Object)x);
                    continue;
                }
                if (bitVector instanceof Chunks && (append = (chunks = BitVector$Chunks$.MODULE$.unapply((Chunks)bitVector))._1()) != null) {
                    Append append3 = BitVector$Append$.MODULE$.unapply(append);
                    BitVector bitVector4 = append3._1();
                    BitVector bitVector5 = append3._2();
                    BitVector x = bitVector4;
                    BitVector y = bitVector5;
                    List t3 = list3;
                    rem = t3.$colon$colon((Object)y).$colon$colon((Object)x);
                    continue;
                }
                if (bitVector instanceof Suspend) {
                    Suspend s = (Suspend)bitVector;
                    List t4 = list3;
                    BitVector bitVector6 = s.underlying();
                    rem = t4.$colon$colon((Object)bitVector6);
                    continue;
                }
                BitVector h = bitVector;
                List list4 = t = list3;
                long l = acc + h.size();
                rem = list4;
                acc = l;
            }
            throw new MatchError((Object)list);
        }

        private final BitVector go$11(BitVector accL, BitVector cur, long n) {
            while (true) {
                BitVector bitVector;
                if ((bitVector = cur) instanceof Append) {
                    Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                    BitVector bitVector2 = append._1();
                    BitVector bitVector3 = append._2();
                    BitVector left = bitVector2;
                    BitVector right = bitVector3;
                    if (n <= left.size()) {
                        return accL.$plus$plus(left.take(n));
                    }
                    BitVector bitVector4 = accL.$plus$plus(left);
                    BitVector bitVector5 = right;
                    long l = n - left.size();
                    accL = bitVector4;
                    cur = bitVector5;
                    n = l;
                    continue;
                }
                if (!(bitVector instanceof Suspend)) break;
                Suspend s = (Suspend)bitVector;
                cur = s.underlying();
            }
            return accL.$plus$plus(cur.take(n));
        }

        private final BitVector go$12(BitVector cur, long n) {
            while (true) {
                BitVector bitVector;
                if ((bitVector = cur) instanceof Append) {
                    Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                    BitVector bitVector2 = append._1();
                    BitVector bitVector3 = append._2();
                    BitVector left = bitVector2;
                    BitVector right = bitVector3;
                    if (n >= left.size()) {
                        BitVector bitVector4 = right;
                        long l = n - left.size();
                        cur = bitVector4;
                        n = l;
                        continue;
                    }
                    return BitVector$Append$.MODULE$.apply(left.drop(n), right);
                }
                if (!(bitVector instanceof Suspend)) break;
                Suspend s = (Suspend)bitVector;
                cur = s.underlying();
            }
            return cur.drop(n);
        }

        private final boolean go$13(BitVector cur, long n, long seen) {
            while (true) {
                BitVector bitVector;
                if ((bitVector = cur) instanceof Append) {
                    Append append = BitVector$Append$.MODULE$.unapply((Append)bitVector);
                    BitVector bitVector2 = append._1();
                    BitVector bitVector3 = append._2();
                    BitVector l = bitVector2;
                    BitVector r = bitVector3;
                    if (l.size() >= n) {
                        this.sizeLowerBound_$eq(scala.math.package$.MODULE$.max(seen + l.size(), this.sizeLowerBound()));
                        return false;
                    }
                    BitVector bitVector4 = r;
                    long l2 = n - l.size();
                    long l3 = seen + l.size();
                    cur = bitVector4;
                    n = l2;
                    seen = l3;
                    continue;
                }
                if (!(bitVector instanceof Suspend)) break;
                Suspend s = (Suspend)bitVector;
                cur = s.underlying();
            }
            this.sizeLowerBound_$eq(scala.math.package$.MODULE$.max(seen, this.sizeLowerBound()));
            return cur.size() < n;
        }
    }

    public static class Bytes
    extends BitVector
    implements Product {
        private final ByteVector underlying;
        private final long size;

        public static Bytes fromProduct(Product product) {
            return BitVector$Bytes$.MODULE$.fromProduct(product);
        }

        public static Bytes unapply(Bytes bytes) {
            return BitVector$Bytes$.MODULE$.unapply(bytes);
        }

        public Bytes(ByteVector underlying, long size) {
            this.underlying = underlying;
            this.size = size;
        }

        public boolean canEqual(Object that) {
            return that instanceof Bytes;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Bytes";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "underlying";
            }
            if (1 == n2) {
                return "size";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteVector underlying() {
            return this.underlying;
        }

        @Override
        public long size() {
            return this.size;
        }

        private long invalidBits() {
            return 8L - BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size());
        }

        @Override
        public Bytes align() {
            return this;
        }

        @Override
        public boolean sizeLessThan(long n) {
            return this.size() < n;
        }

        @Override
        public Bytes take(long n) {
            return BitVector$.MODULE$.toBytes(this.underlying(), scala.math.package$.MODULE$.max(0L, scala.math.package$.MODULE$.min(this.size(), n)));
        }

        @Override
        public BitVector drop(long n) {
            if (n >= this.size()) {
                return BitVector$.MODULE$.empty();
            }
            if (n <= 0L) {
                return this;
            }
            return n % 8L == 0L ? BitVector$Bytes$.MODULE$.apply(this.underlying().drop(n / 8L), this.size() - n) : BitVector$Drop$.MODULE$.apply(this, n);
        }

        @Override
        public boolean get(long n) {
            this.checkBounds(n);
            return BitVector$.MODULE$.scodec$bits$BitVector$$$getBit(this.underlying().apply(n / 8L), (int)(n % 8L));
        }

        @Override
        public byte getByte(long n) {
            if (n < this.underlying().size() - 1L) {
                return this.underlying().apply(n);
            }
            long valid = 8L - this.invalidBits();
            return (byte)(this.underlying().apply(n) & BitVector$.MODULE$.scodec$bits$BitVector$$$topNBits((int)valid));
        }

        @Override
        public BitVector update(long n, boolean high) {
            this.checkBounds(n);
            ByteVector b2 = this.underlying().update(n / 8L, BoxesRunTime.unboxToByte((Object)this.underlying().lift(n / 8L).map((Function1 & Serializable)_$25 -> this.$anonfun$1(n, high, BoxesRunTime.unboxToByte((Object)_$25))).getOrElse(() -> this.$anonfun$2(n))));
            return BitVector$Bytes$.MODULE$.apply(b2, this.size());
        }

        public Bytes combine(Bytes other) {
            long invalidBits = this.invalidBits();
            ByteVector otherBytes = other.underlying();
            if (this.isEmpty()) {
                return other;
            }
            if (otherBytes.isEmpty()) {
                return this;
            }
            if (invalidBits == 0L) {
                return BitVector$.MODULE$.toBytes(this.underlying().$plus$plus(otherBytes), this.size() + other.size());
            }
            ByteVector bytesCleared = BitVector$.MODULE$.scodec$bits$BitVector$$$clearUnneededBits(this.size(), this.underlying());
            byte hi = bytesCleared.apply(bytesCleared.size() - 1L);
            byte lo = (byte)(((byte)(otherBytes.head() & BitVector$.MODULE$.scodec$bits$BitVector$$$topNBits((int)invalidBits)) & 0xFF) >>> (int)BitVector$.MODULE$.scodec$bits$BitVector$$$validBitsInLastByte(this.size()));
            ByteVector updatedOurBytes = bytesCleared.update(bytesCleared.size() - 1L, (byte)(hi | lo));
            ByteVector updatedOtherBytes = other.drop(invalidBits).toByteVector();
            return BitVector$.MODULE$.toBytes(updatedOurBytes.$plus$plus(updatedOtherBytes), this.size() + other.size());
        }

        public Bytes copy(ByteVector underlying, long size) {
            return new Bytes(underlying, size);
        }

        public ByteVector copy$default$1() {
            return this.underlying();
        }

        public long copy$default$2() {
            return this.size();
        }

        public ByteVector _1() {
            return this.underlying();
        }

        public long _2() {
            return this.size();
        }

        private final /* synthetic */ byte $anonfun$1(long n$5, boolean high$1, byte _$25) {
            return BitVector$.MODULE$.scodec$bits$BitVector$$$setBit(_$25, (int)(n$5 % 8L), high$1);
        }

        private final byte $anonfun$2(long n$6) {
            throw this.outOfBounds(n$6);
        }
    }

    public static class Chunks
    extends BitVector
    implements Product {
        private final Append chunks;

        public static Chunks fromProduct(Product product) {
            return BitVector$Chunks$.MODULE$.fromProduct(product);
        }

        public static Chunks unapply(Chunks chunks) {
            return BitVector$Chunks$.MODULE$.unapply(chunks);
        }

        public Chunks(Append chunks) {
            this.chunks = chunks;
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunks;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Chunks";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "chunks";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Append chunks() {
            return this.chunks;
        }

        @Override
        public BitVector unchunk() {
            return BitVector$Append$.MODULE$.apply(this.chunks().left(), this.chunks().right().unchunk());
        }

        @Override
        public Bytes align() {
            return this.chunks().align();
        }

        @Override
        public BitVector take(long n) {
            return this.chunks().take(n);
        }

        @Override
        public BitVector drop(long n) {
            return this.chunks().drop(n);
        }

        @Override
        public BitVector $plus$plus(BitVector b) {
            if (b.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return b;
            }
            return this.go$14(this.chunks(), b.unchunk());
        }

        @Override
        public long size() {
            return this.chunks().size();
        }

        @Override
        public boolean sizeLessThan(long n) {
            return this.chunks().sizeLessThan(n);
        }

        @Override
        public BitVector update(long n, boolean high) {
            return this.chunks().update(n, high);
        }

        @Override
        public boolean get(long n) {
            return this.chunks().get(n);
        }

        @Override
        public byte getByte(long n) {
            return this.chunks().getByte(n);
        }

        public Chunks copy(Append chunks) {
            return new Chunks(chunks);
        }

        public Append copy$default$1() {
            return this.chunks();
        }

        public Append _1() {
            return this.chunks();
        }

        private final BitVector go$14(Append chunks, BitVector last) {
            while (true) {
                boolean aligned;
                long lastN;
                if ((lastN = last.size()) >= chunks.size() || lastN * 2L <= chunks.right().size()) {
                    return BitVector$Chunks$.MODULE$.apply(BitVector$Append$.MODULE$.apply(chunks, last));
                }
                BitVector bitVector = chunks.left();
                if (!(bitVector instanceof Append)) break;
                Append left = (Append)bitVector;
                long rN = chunks.right().size();
                boolean bl = aligned = lastN % 8L + rN % 8L == 0L;
                if (rN <= 256L && aligned) {
                    Append append = left;
                    Bytes bytes = chunks.right().align().combine(last.align());
                    chunks = append;
                    last = bytes;
                    continue;
                }
                Append append = left;
                Append append2 = BitVector$Append$.MODULE$.apply(chunks.right(), last);
                chunks = append;
                last = append2;
            }
            return BitVector$Chunks$.MODULE$.apply(BitVector$Append$.MODULE$.apply(chunks, last));
        }
    }

    public static class Drop
    extends BitVector
    implements Product {
        private final Bytes underlying;
        private final long m;

        public static Drop fromProduct(Product product) {
            return BitVector$Drop$.MODULE$.fromProduct(product);
        }

        public static Drop unapply(Drop drop) {
            return BitVector$Drop$.MODULE$.unapply(drop);
        }

        public Drop(Bytes underlying, long m) {
            this.underlying = underlying;
            this.m = m;
        }

        public boolean canEqual(Object that) {
            return that instanceof Drop;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Drop";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "underlying";
            }
            if (1 == n2) {
                return "m";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Bytes underlying() {
            return this.underlying;
        }

        public long m() {
            return this.m;
        }

        @Override
        public long size() {
            return scala.math.package$.MODULE$.max(0L, this.underlying().size() - this.m());
        }

        @Override
        public boolean sizeLessThan(long n) {
            return this.size() < n;
        }

        @Override
        public Bytes align() {
            return this.interpretDrop();
        }

        @Override
        public BitVector drop(long n) {
            if (n >= this.size()) {
                return BitVector$.MODULE$.empty();
            }
            if (n <= 0L) {
                return this;
            }
            long nm = n + this.m();
            Drop d = BitVector$Drop$.MODULE$.apply(this.underlying(), nm);
            return nm > 32768L && nm % 8L == 0L ? d.interpretDrop() : d;
        }

        @Override
        public BitVector take(long n) {
            if (n >= this.size()) {
                return this;
            }
            if (n <= 0L) {
                return BitVector$.MODULE$.empty();
            }
            return this.underlying().take(this.m() + n).drop(this.m());
        }

        @Override
        public boolean get(long n) {
            return this.underlying().get(this.m() + n);
        }

        @Override
        public byte getByte(long n) {
            return this.drop(n * 8L).take(8L).align().getByte(0L);
        }

        @Override
        public BitVector update(long n, boolean high) {
            return BitVector$Drop$.MODULE$.apply(this.underlying().update(this.m() + n, high).compact(), this.m());
        }

        public Bytes interpretDrop() {
            long low = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(this.m()), 0L);
            long newSize = this.size();
            if (newSize == 0L) {
                return BitVector$.MODULE$.empty().align();
            }
            long lowByte = low / 8L;
            ByteVector shiftedByWholeBytes = this.underlying().underlying().slice(lowByte, lowByte + BitVector$.MODULE$.scodec$bits$BitVector$$$bytesNeededForBits(newSize) + 1L);
            int bitsToShiftEachByte = (int)(low % 8L);
            ByteVector newBytes = bitsToShiftEachByte == 0 ? shiftedByWholeBytes : shiftedByWholeBytes.zipWithI(shiftedByWholeBytes.drop(1L).$colon$plus((byte)0), (Function2<Object, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> this.$anonfun$3(bitsToShiftEachByte, BoxesRunTime.unboxToByte((Object)x$1), BoxesRunTime.unboxToByte((Object)x$2)));
            return BitVector$.MODULE$.toBytes(newSize <= (newBytes.size() - 1L) * 8L ? newBytes.dropRight(1L) : newBytes, newSize);
        }

        public Drop copy(Bytes underlying, long m) {
            return new Drop(underlying, m);
        }

        public Bytes copy$default$1() {
            return this.underlying();
        }

        public long copy$default$2() {
            return this.m();
        }

        public Bytes _1() {
            return this.underlying();
        }

        public long _2() {
            return this.m();
        }

        private final /* synthetic */ int $anonfun$3(int bitsToShiftEachByte$1, byte x$1, byte x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x$1), (Object)BoxesRunTime.boxToByte((byte)x$2));
            if (tuple2 != null) {
                byte a = BoxesRunTime.unboxToByte((Object)tuple2._1());
                byte b = BoxesRunTime.unboxToByte((Object)tuple2._2());
                int hi = a << bitsToShiftEachByte$1;
                int low = ((byte)(b & BitVector$.MODULE$.scodec$bits$BitVector$$$topNBits(bitsToShiftEachByte$1)) & 0xFF) >>> 8 - bitsToShiftEachByte$1;
                return hi | low;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    public static final class GroupedOp {
        private final BitVector self;

        public static boolean equals$extension(BitVector bitVector, Object object) {
            return BitVector$GroupedOp$.MODULE$.equals$extension(bitVector, object);
        }

        public static Iterator<BitVector> grouped$extension(BitVector bitVector, long l) {
            return BitVector$GroupedOp$.MODULE$.grouped$extension(bitVector, l);
        }

        public static int hashCode$extension(BitVector bitVector) {
            return BitVector$GroupedOp$.MODULE$.hashCode$extension(bitVector);
        }

        public GroupedOp(BitVector self) {
            this.self = self;
        }

        public int hashCode() {
            return BitVector$GroupedOp$.MODULE$.hashCode$extension(this.self());
        }

        public boolean equals(Object x$0) {
            return BitVector$GroupedOp$.MODULE$.equals$extension(this.self(), x$0);
        }

        public BitVector self() {
            return this.self;
        }

        public final Iterator<BitVector> grouped(long n) {
            return BitVector$GroupedOp$.MODULE$.grouped$extension(this.self(), n);
        }
    }

    public static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;
        private final long size;

        public SerializationProxy(byte[] bytes, long size) {
            this.bytes = bytes;
            this.size = size;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        private long size() {
            return this.size;
        }

        public Object readResolve() {
            return BitVector$.MODULE$.view(this.bytes(), this.size());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Suspend
    extends BitVector
    implements Product {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Suspend.class.getDeclaredField("0bitmap$2"));
        public long 0bitmap$2;
        private final Function0 thunk;
        public BitVector underlying$lzy1;

        public static Suspend fromProduct(Product product) {
            return BitVector$Suspend$.MODULE$.fromProduct(product);
        }

        public static Suspend unapply(Suspend suspend) {
            return BitVector$Suspend$.MODULE$.unapply(suspend);
        }

        public Suspend(Function0<BitVector> thunk) {
            this.thunk = thunk;
        }

        public boolean canEqual(Object that) {
            return that instanceof Suspend;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Suspend";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "thunk";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<BitVector> thunk() {
            return this.thunk;
        }

        public BitVector underlying() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        BitVector bitVector;
                        this.underlying$lzy1 = bitVector = (BitVector)this.thunk().apply();
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return bitVector;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.underlying$lzy1;
        }

        @Override
        public boolean sizeLessThan(long n) {
            return this.underlying().sizeLessThan(n);
        }

        @Override
        public boolean get(long n) {
            return this.underlying().get(n);
        }

        @Override
        public BitVector take(long n) {
            return this.underlying().take(n);
        }

        @Override
        public BitVector drop(long n) {
            return this.underlying().drop(n);
        }

        @Override
        public byte getByte(long n) {
            return this.underlying().getByte(n);
        }

        @Override
        public BitVector update(long n, boolean high) {
            return this.underlying().update(n, high);
        }

        @Override
        public long size() {
            return this.underlying().size();
        }

        @Override
        public Bytes align() {
            return this.underlying().align();
        }

        public Suspend copy(Function0<BitVector> thunk) {
            return new Suspend(thunk);
        }

        public Function0<BitVector> copy$default$1() {
            return this.thunk();
        }

        public Function0<BitVector> _1() {
            return this.thunk();
        }
    }
}

