/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.logging.Logger;
import scala.Option;
import scala.Some;
import scoverage.domain.Constants;
import scoverage.domain.Coverage;
import scoverage.reporter.CoberturaXmlWriter;
import scoverage.reporter.ScoverageHtmlWriter;
import scoverage.reporter.ScoverageXmlWriter;

public class ScoverageWriter {
    private final Logger logger;

    public ScoverageWriter(Logger logger) {
        this.logger = logger;
    }

    public void write(Set<File> sourceDirs, File reportDir, Coverage coverage, String sourceEncoding, Boolean coverageOutputCobertura, Boolean coverageOutputXML, Boolean coverageOutputHTML, Boolean coverageDebug) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        CoberturaXmlWriter writer;
        Constructor cst;
        this.logger.info("[scoverage] Generating scoverage reports...");
        reportDir.mkdirs();
        Object scalaBuffer = Class.forName("scala.collection.JavaConverters").getMethod("asScalaBuffer", List.class).invoke(null, new ArrayList<File>(sourceDirs));
        Object sourceDirsSeq = scalaBuffer.getClass().getMethod("toIndexedSeq", new Class[0]).invoke(scalaBuffer, new Object[0]);
        if (coverageOutputCobertura.booleanValue()) {
            try {
                cst = CoberturaXmlWriter.class.getConstructor(Class.forName("scala.collection.immutable.Seq"), File.class, Class.forName("scala.Option"));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                cst = CoberturaXmlWriter.class.getConstructor(Class.forName("scala.collection.Seq"), File.class, Class.forName("scala.Option"));
            }
            writer = (CoberturaXmlWriter)cst.newInstance(sourceDirsSeq, reportDir, new Some((Object)sourceEncoding));
            writer.write(coverage);
            this.logger.info("[scoverage] Written Cobertura XML report to " + reportDir.getAbsolutePath() + File.separator + "cobertura.xml");
        }
        if (coverageOutputXML.booleanValue()) {
            try {
                cst = ScoverageXmlWriter.class.getConstructor(Class.forName("scala.collection.immutable.Seq"), File.class, Boolean.TYPE, Class.forName("scala.Option"));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                cst = ScoverageXmlWriter.class.getConstructor(Class.forName("scala.collection.Seq"), File.class, Boolean.TYPE, Class.forName("scala.Option"));
            }
            writer = (ScoverageXmlWriter)cst.newInstance(sourceDirsSeq, reportDir, false, new Some((Object)sourceEncoding));
            writer.write(coverage);
            this.logger.info("[scoverage] Written XML report to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilename());
            if (coverageDebug.booleanValue()) {
                ScoverageXmlWriter writerDebug = (ScoverageXmlWriter)cst.newInstance(sourceDirsSeq, reportDir, true, new Some((Object)sourceEncoding));
                writerDebug.write(coverage);
                this.logger.info("[scoverage] Written XML report with debug information to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilenameWithDebug());
            }
        }
        if (coverageOutputHTML.booleanValue()) {
            try {
                cst = ScoverageHtmlWriter.class.getConstructor(Class.forName("scala.collection.immutable.Seq"), File.class, Option.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                cst = ScoverageHtmlWriter.class.getConstructor(Class.forName("scala.collection.Seq"), File.class, Option.class);
            }
            writer = (ScoverageHtmlWriter)cst.newInstance(sourceDirsSeq, reportDir, new Some((Object)sourceEncoding));
            writer.write(coverage);
            this.logger.info("[scoverage] Written HTML report to " + reportDir.getAbsolutePath() + File.separator + "index.html");
        }
        this.logger.info("[scoverage] Coverage reports completed");
    }
}

