/*
 * Decompiled with CFR 0.152.
 */
package scoverage.domain;

import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scoverage.domain.ClassBuilders;
import scoverage.domain.Coverage$;
import scoverage.domain.CoverageMetrics;
import scoverage.domain.DoubleFormat$;
import scoverage.domain.FileBuilders;
import scoverage.domain.MeasuredClass;
import scoverage.domain.MethodBuilders;
import scoverage.domain.PackageBuilders;
import scoverage.domain.Statement;

public class Coverage
implements CoverageMetrics,
MethodBuilders,
Serializable,
ClassBuilders,
PackageBuilders,
FileBuilders,
Product {
    private final Map<Object, Statement> statementsById = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    private final Map<Object, Statement> ignoredStatementsById = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));

    public static Coverage fromProduct(Product product) {
        return Coverage$.MODULE$.fromProduct(product);
    }

    public static boolean unapply(Coverage coverage) {
        return Coverage$.MODULE$.unapply(coverage);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Coverage)) return false;
        Coverage coverage = (Coverage)object;
        boolean bl = coverage.canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Coverage;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "Coverage";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public Iterable<Statement> statements() {
        return this.statementsById.values();
    }

    public void add(Statement stmt) {
        this.statementsById.put((Object)BoxesRunTime.boxToInteger((int)stmt.id()), (Object)stmt);
    }

    @Override
    public Iterable<Statement> ignoredStatements() {
        return this.ignoredStatementsById.values();
    }

    public void addIgnoredStatement(Statement stmt) {
        this.ignoredStatementsById.put((Object)BoxesRunTime.boxToInteger((int)stmt.id()), (Object)stmt);
    }

    public double avgClassesPerPackage() {
        return (double)this.classCount() / (double)this.packageCount();
    }

    public String avgClassesPerPackageFormatted() {
        return DoubleFormat$.MODULE$.twoFractionDigits(this.avgClassesPerPackage());
    }

    public double avgMethodsPerClass() {
        return (double)this.methodCount() / (double)this.classCount();
    }

    public String avgMethodsPerClassFormatted() {
        return DoubleFormat$.MODULE$.twoFractionDigits(this.avgMethodsPerClass());
    }

    public int loc() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.files().map((Function1 & Serializable)_$1 -> _$1.loc())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public double linesPerFile() {
        return (double)this.loc() / (double)this.fileCount();
    }

    public String linesPerFileFormatted() {
        return DoubleFormat$.MODULE$.twoFractionDigits(this.linesPerFile());
    }

    public Seq<MeasuredClass> risks(int limit) {
        return (Seq)((IterableOps)((SeqOps)((SeqOps)this.classes().toSeq().sortBy((Function1 & Serializable)_$2 -> _$2.statementCount(), (Ordering)Ordering.Int$.MODULE$)).reverse()).sortBy((Function1 & Serializable)_$3 -> _$3.statementCoverage(), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).take(limit);
    }

    public void apply(Iterable<Tuple2<Object, String>> ids) {
        ids.foreach((Function1)(JProcedure1 & Serializable)id -> this.invoked((Tuple2<Object, String>)id));
    }

    public void invoked(Tuple2<Object, String> id) {
        this.statementsById.get(id._1()).foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.invoked((String)id._2()));
    }

    public Coverage copy() {
        return new Coverage();
    }
}

