/*
 * Decompiled with CFR 0.152.
 */
package scoverage.domain;

import java.io.Serializable;
import scala.Function1;
import scala.collection.Iterable;
import scoverage.domain.DoubleFormat$;
import scoverage.domain.Statement;

public interface CoverageMetrics {
    public Iterable<Statement> statements();

    public static int statementCount$(CoverageMetrics $this) {
        return $this.statementCount();
    }

    default public int statementCount() {
        return this.statements().size();
    }

    public Iterable<Statement> ignoredStatements();

    public static int ignoredStatementCount$(CoverageMetrics $this) {
        return $this.ignoredStatementCount();
    }

    default public int ignoredStatementCount() {
        return this.ignoredStatements().size();
    }

    public static Iterable invokedStatements$(CoverageMetrics $this) {
        return $this.invokedStatements();
    }

    default public Iterable<Statement> invokedStatements() {
        return (Iterable)this.statements().filter((Function1 & Serializable)_$1 -> _$1.count() > 0);
    }

    public static int invokedStatementCount$(CoverageMetrics $this) {
        return $this.invokedStatementCount();
    }

    default public int invokedStatementCount() {
        return this.invokedStatements().size();
    }

    public static double statementCoverage$(CoverageMetrics $this) {
        return $this.statementCoverage();
    }

    default public double statementCoverage() {
        if (this.statementCount() == 0) {
            return 1.0;
        }
        return (double)this.invokedStatementCount() / (double)this.statementCount();
    }

    public static double statementCoveragePercent$(CoverageMetrics $this) {
        return $this.statementCoveragePercent();
    }

    default public double statementCoveragePercent() {
        return this.statementCoverage() * (double)100;
    }

    public static String statementCoverageFormatted$(CoverageMetrics $this) {
        return $this.statementCoverageFormatted();
    }

    default public String statementCoverageFormatted() {
        return DoubleFormat$.MODULE$.twoFractionDigits(this.statementCoveragePercent());
    }

    public static Iterable branches$(CoverageMetrics $this) {
        return $this.branches();
    }

    default public Iterable<Statement> branches() {
        return (Iterable)this.statements().filter((Function1 & Serializable)_$2 -> _$2.branch());
    }

    public static int branchCount$(CoverageMetrics $this) {
        return $this.branchCount();
    }

    default public int branchCount() {
        return this.branches().size();
    }

    public static double branchCoveragePercent$(CoverageMetrics $this) {
        return $this.branchCoveragePercent();
    }

    default public double branchCoveragePercent() {
        return this.branchCoverage() * (double)100;
    }

    public static Iterable invokedBranches$(CoverageMetrics $this) {
        return $this.invokedBranches();
    }

    default public Iterable<Statement> invokedBranches() {
        return (Iterable)this.branches().filter((Function1 & Serializable)_$3 -> _$3.count() > 0);
    }

    public static int invokedBranchesCount$(CoverageMetrics $this) {
        return $this.invokedBranchesCount();
    }

    default public int invokedBranchesCount() {
        return this.invokedBranches().size();
    }

    public static double branchCoverage$(CoverageMetrics $this) {
        return $this.branchCoverage();
    }

    default public double branchCoverage() {
        if (this.branchCount() == 0) {
            if (this.statementCoverage() > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)this.invokedBranchesCount() / (double)this.branchCount();
    }

    public static String branchCoverageFormatted$(CoverageMetrics $this) {
        return $this.branchCoverageFormatted();
    }

    default public String branchCoverageFormatted() {
        return DoubleFormat$.MODULE$.twoFractionDigits(this.branchCoveragePercent());
    }
}

