/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Utility$;
import scala.xml.XML$;
import scoverage.ClassType;
import scoverage.ClassType$Class$;
import scoverage.ClassType$Object$;
import scoverage.ClassType$Trait$;
import scoverage.Constants$;
import scoverage.Coverage;
import scoverage.Location;
import scoverage.Statement;

public final class Serializer$ {
    public static final Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public void serialize(Coverage coverage, String dataDir) {
        this.serialize(coverage, this.coverageFile(dataDir));
    }

    public void serialize(Coverage coverage, File file) {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.serialize(coverage, writer);
        writer.close();
    }

    public void serialize(Coverage coverage, Writer writer) {
        writer.write("<statements>\n");
        coverage.statements().foreach((Function1)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final Writer writer$1;

            public final void apply(Statement stmt) {
                Serializer$.MODULE$.scoverage$Serializer$$writeStatement$1(stmt, this.writer$1);
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.write("</statements>");
    }

    public File coverageFile(File dataDir) {
        return this.coverageFile(dataDir.getAbsolutePath());
    }

    public File coverageFile(String dataDir) {
        return new File(dataDir, Constants$.MODULE$.CoverageFileName());
    }

    public Coverage deserialize(String str) {
        Elem xml2 = (Elem)XML$.MODULE$.loadString(str);
        scala.collection.immutable.Seq statements = (scala.collection.immutable.Seq)xml2.$bslash("statement").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Statement apply(Node node) {
                ClassType classType;
                String string;
                String source = node.$bslash("source").text();
                int count = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("count").text())).toInt();
                boolean ignored = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("ignored").text())).toBoolean();
                boolean branch = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("branch").text())).toBoolean();
                String _package = node.$bslash("package").text();
                String _class = node.$bslash("class").text();
                String topLevelClass = node.$bslash("topLevelClass").text();
                String method2 = node.$bslash("method").text();
                String path = node.$bslash("path").text();
                String treeName = node.$bslash("treeName").text();
                String symbolName = node.$bslash("symbolName").text();
                int id = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("id").text())).toInt();
                int line = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("line").text())).toInt();
                String desc = node.$bslash("description").text();
                int start = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("start").text())).toInt();
                int end = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("end").text())).toInt();
                String string2 = string = node.$bslash("classType").text();
                if (!("Trait" != null ? !"Trait".equals(string2) : string2 != null)) {
                    classType = ClassType$Trait$.MODULE$;
                } else {
                    String string3 = string;
                    classType = !("Object" != null ? !"Object".equals(string3) : string3 != null) ? ClassType$Object$.MODULE$ : ClassType$Class$.MODULE$;
                }
                ClassType$Trait$ classType2 = classType;
                return new Statement(source, new Location(_package, _class, topLevelClass, classType2, method2, path), id, start, end, line, desc, symbolName, treeName, branch, count, ignored);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Coverage coverage = new Coverage();
        statements.foreach((Function1)new Serializable(coverage){
            public static final long serialVersionUID = 0L;
            private final Coverage coverage$1;

            public final void apply(Statement statement) {
                if (statement.ignored()) {
                    this.coverage$1.addIgnoredStatement(statement);
                } else {
                    this.coverage$1.add(statement);
                }
            }
            {
                this.coverage$1 = coverage$1;
            }
        });
        return coverage;
    }

    public Coverage deserialize(File file) {
        String str = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return this.deserialize(str);
    }

    public String escape(String in) {
        StringBuilder out = new StringBuilder();
        Predef$.MODULE$.charArrayOps(((String)Option$.MODULE$.apply((Object)in).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toCharArray()).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final StringBuilder out$1;

            public final Object apply(char current) {
                return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff' ? this.out$1.append(current) : BoxedUnit.UNIT;
            }
            {
                this.out$1 = out$1;
            }
        });
        return out.mkString();
    }

    public final void scoverage$Serializer$$writeStatement$1(Statement stmt, Writer writer) {
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n            "));
        $buf2.$amp$plus((Object)stmt.source());
        $buf2.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)stmt.location().packageName());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "package", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            "));
        $buf4.$amp$plus((Object)stmt.location().className());
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "class", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)stmt.location().classType().toString());
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "classType", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)stmt.location().topLevelClass());
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "topLevelClass", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)stmt.location().method());
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "method", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf8.$amp$plus((Object)stmt.location().sourcePath());
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "path", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$8, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.id())).toString());
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf10.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.start())).toString());
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$10, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$11 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.end())).toString());
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$11, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.line())).toString());
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "line", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, false, (Seq)$buf12));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf13.$amp$plus((Object)this.escape(stmt.desc()));
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "description", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$13, false, (Seq)$buf13));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$14 = Predef$.MODULE$.$scope();
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf14.$amp$plus((Object)this.escape(stmt.symbolName()));
        $buf14.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "symbolName", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$14, false, (Seq)$buf14));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$15 = Predef$.MODULE$.$scope();
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n            "));
        $buf15.$amp$plus((Object)this.escape(stmt.treeName()));
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "treeName", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$15, false, (Seq)$buf15));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$16 = Predef$.MODULE$.$scope();
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n            "));
        $buf16.$amp$plus((Object)((Object)BoxesRunTime.boxToBoolean((boolean)stmt.branch())).toString());
        $buf16.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "branch", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$16, false, (Seq)$buf16));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$17 = Predef$.MODULE$.$scope();
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n            "));
        $buf17.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.count())).toString());
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "count", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$17, false, (Seq)$buf17));
        $buf.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$18 = Predef$.MODULE$.$scope();
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n            "));
        $buf18.$amp$plus((Object)((Object)BoxesRunTime.boxToBoolean((boolean)stmt.ignored())).toString());
        $buf18.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "ignored", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$18, false, (Seq)$buf18));
        $buf.$amp$plus((Object)new Text("\n        "));
        Elem xml2 = new Elem(null, "statement", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf);
        writer.write(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Utility$.MODULE$.trim((Node)xml2)), "\n"));
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

