/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scoverage.ClassType$;
import scoverage.Constants$;
import scoverage.Coverage;
import scoverage.Location;
import scoverage.Statement;

public final class Serializer$ {
    public static final Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public void serialize(Coverage coverage, String dataDir) {
        this.serialize(coverage, this.coverageFile(dataDir));
    }

    public void serialize(Coverage coverage, File file) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Codec$.MODULE$.UTF8().name()));
        try {
            this.serialize(coverage, writer);
            return;
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    public void serialize(Coverage coverage, Writer writer) {
        this.writeHeader$1(writer);
        ((IterableLike)coverage.statements().toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Statement x$1) {
                return x$1.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final Writer writer$1;

            public final void apply(Statement stmt) {
                Serializer$.MODULE$.scoverage$Serializer$$writeStatement$1(stmt, this.writer$1);
            }
            {
                this.writer$1 = writer$1;
            }
        });
    }

    public File coverageFile(File dataDir) {
        return this.coverageFile(dataDir.getAbsolutePath());
    }

    public File coverageFile(String dataDir) {
        return new File(dataDir, Constants$.MODULE$.CoverageFileName());
    }

    public Coverage deserialize(File file) {
        return this.deserialize((Iterator<String>)Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8()).getLines());
    }

    /*
     * WARNING - void declaration
     */
    public Coverage deserialize(Iterator<String> lines) {
        String headerFirstLine;
        String string = headerFirstLine = (String)lines.next();
        String string2 = "# Coverage data, format version: 2.0";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong file format";
            }
        });
        Iterator linesWithoutHeader = lines.dropWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.startsWith("#");
            }
        });
        Coverage coverage = new Coverage();
        while (!linesWithoutHeader.isEmpty()) {
            void var5_5;
            void var4_4;
            Iterator oneStatementLines = var4_4.takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$3) {
                    String string = x$3;
                    String string2 = "\f";
                    return string != null ? !string.equals(string2) : string2 != null;
                }
            });
            Statement statement = this.toStatement$1(oneStatementLines);
            if (statement.ignored()) {
                var5_5.addIgnoredStatement(statement);
                continue;
            }
            var5_5.add(statement);
        }
        return coverage;
    }

    private final void writeHeader$1(Writer writer) {
        writer.write(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# Coverage data, format version: 2.0\n        |# Statement data:\n        |# - id\n        |# - source path\n        |# - package name\n        |# - class name\n        |# - class type (Class, Object or Trait)\n        |# - full class name\n        |# - method name\n        |# - start offset\n        |# - end offset\n        |# - line number\n        |# - symbol name\n        |# - tree name\n        |# - is branch\n        |# - invocations count\n        |# - is ignored\n        |# - description (can be multi-line)\n        |# '\\f' sign\n        |# ------------------------------------------\n        |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }

    public final void scoverage$Serializer$$writeStatement$1(Statement stmt, Writer writer) {
        writer.write(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |", "\n        |\\f\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stmt.id()), stmt.location().sourcePath(), stmt.location().packageName(), stmt.location().className(), stmt.location().classType(), stmt.location().fullClassName(), stmt.location().method(), BoxesRunTime.boxToInteger((int)stmt.start()), BoxesRunTime.boxToInteger((int)stmt.end()), BoxesRunTime.boxToInteger((int)stmt.line()), stmt.symbolName(), stmt.treeName(), BoxesRunTime.boxToBoolean((boolean)stmt.branch()), BoxesRunTime.boxToInteger((int)stmt.count()), BoxesRunTime.boxToBoolean((boolean)stmt.ignored()), stmt.desc()})))).stripMargin());
    }

    private final Statement toStatement$1(Iterator lines) {
        int id = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toInt();
        String sourcePath2 = (String)lines.next();
        String packageName = (String)lines.next();
        String className = (String)lines.next();
        String classType = (String)lines.next();
        String fullClassName = (String)lines.next();
        String method2 = (String)lines.next();
        Location loc2 = new Location(packageName, className, fullClassName, ClassType$.MODULE$.fromString(classType), method2, sourcePath2);
        int start = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toInt();
        int end = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toInt();
        int lineNo = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toInt();
        String symbolName = (String)lines.next();
        String treeName = (String)lines.next();
        boolean branch = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toBoolean();
        int count = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toInt();
        boolean ignored = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).toBoolean();
        String desc = lines.toList().mkString("\n");
        return new Statement(loc2, id, start, end, lineNo, desc, symbolName, treeName, branch, count, ignored);
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

