/*
 * Decompiled with CFR 0.152.
 */
package scoverage.report;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scoverage.Coverage;
import scoverage.IOUtils$;
import scoverage.MeasuredClass;
import scoverage.MeasuredFile;
import scoverage.MeasuredPackage;
import scoverage.report.BaseReportWriter;
import scoverage.report.CodeGrid;
import scoverage.report.StatementWriter;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\f\u0019\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\ts\u0001\u0011\t\u0011)A\u0005c!A!\b\u0001B\u0001B\u0003%1\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003H\u0001\u0011\u0005Q\nC\u0003H\u0001\u0011\u0005A\u000bC\u0003H\u0001\u0011\u0005q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0003g\u0001\u0011%q\rC\u0003n\u0001\u0011%a\u000eC\u0003u\u0001\u0011%Q\u000fC\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u00111\u000e\u0001\u0005\u0002\u00055$aE*d_Z,'/Y4f\u0011RlGn\u0016:ji\u0016\u0014(BA\r\u001b\u0003\u0019\u0011X\r]8si*\t1$A\u0005tG>4XM]1hK\u000e\u00011C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0019\u0013\t\t\u0003D\u0001\tCCN,'+\u001a9peR<&/\u001b;fe\u0006\t2o\\;sG\u0016$\u0015N]3di>\u0014\u0018.Z:\u0011\u0007\u0011r\u0013G\u0004\u0002&W9\u0011a%K\u0007\u0002O)\u0011\u0001\u0006H\u0001\u0007yI|w\u000e\u001e \n\u0003)\nQa]2bY\u0006L!\u0001L\u0017\u0002\u000fA\f7m[1hK*\t!&\u0003\u00020a\t\u00191+Z9\u000b\u00051j\u0003C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\tIwNC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u001a$\u0001\u0002$jY\u0016\f\u0011b\\;uaV$H)\u001b:\u0002\u001dM|WO]2f\u000b:\u001cw\u000eZ5oOB\u0019A(P \u000e\u00035J!AP\u0017\u0003\r=\u0003H/[8o!\t\u0001EI\u0004\u0002B\u0005B\u0011a%L\u0005\u0003\u00076\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111)L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%S5\n\u0014\t\u0003?\u0001AQA\t\u0003A\u0002\rBQ!\u000f\u0003A\u0002EBQA\u000f\u0003A\u0002m\"B!\u0013(S'\")!%\u0002a\u0001\u001fB\u0019A\bU\u0019\n\u0005Ek#!B!se\u0006L\b\"B\u001d\u0006\u0001\u0004\t\u0004\"\u0002\u001e\u0006\u0001\u0004YDcA%V-\")!E\u0002a\u0001G!)\u0011H\u0002a\u0001cQ\u0019\u0011\n\u0017.\t\u000be;\u0001\u0019A\u0019\u0002\u001fM|WO]2f\t&\u0014Xm\u0019;pefDQ!O\u0004A\u0002E\nQa\u001e:ji\u0016$\"!\u00181\u0011\u0005qr\u0016BA0.\u0005\u0011)f.\u001b;\t\u000b\u0005D\u0001\u0019\u00012\u0002\u0011\r|g/\u001a:bO\u0016\u0004\"a\u00193\u000e\u0003iI!!\u001a\u000e\u0003\u0011\r{g/\u001a:bO\u0016\fAb\u001e:ji\u0016\u0004\u0016mY6bO\u0016$\"!\u00185\t\u000b%L\u0001\u0019\u00016\u0002\u0007A\\w\r\u0005\u0002dW&\u0011AN\u0007\u0002\u0010\u001b\u0016\f7/\u001e:fIB\u000b7m[1hK\u0006IqO]5uK\u001aKG.\u001a\u000b\u0003;>DQ\u0001\u001d\u0006A\u0002E\fQ!\u001c4jY\u0016\u0004\"a\u0019:\n\u0005MT\"\u0001D'fCN,(/\u001a3GS2,\u0017a\u00079bG.\fw-Z(wKJ4\u0018.Z<SK2\fG/\u001b<f!\u0006$\b\u000e\u0006\u0002wwB\u0011qO_\u0007\u0002q*\u0011\u00110N\u0001\u0005Y\u0006tw-\u0003\u0002Fq\")\u0011n\u0003a\u0001U\u0006Aa-\u001b7f!\u0006<W\rF\u0002\u007f\u0003\u0013\u00012a`A\u0003\u001b\t\t\tAC\u0002\u0002\u00045\n1\u0001_7m\u0013\u0011\t9!!\u0001\u0003\t9{G-\u001a\u0005\u0006a2\u0001\r!]\u0001\u0007Q\u0016\fG-\u001a:\u0016\u0005\u0005=\u0001cA@\u0002\u0012%!\u00111CA\u0001\u0005\u0011)E.Z7\u0002\u001fA\f7m[1hK>3XM\u001d<jK^$2A`A\r\u0011\u0019\tYB\u0004a\u0001U\u0006!\u0001/Y2l\u00031\u0019G.Y:tKN$\u0016M\u00197f)\u0015q\u0018\u0011EA\u0019\u0011\u001d\t\u0019c\u0004a\u0001\u0003K\tqa\u00197bgN,7\u000fE\u0003%\u0003O\tY#C\u0002\u0002*A\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0004G\u00065\u0012bAA\u00185\tiQ*Z1tkJ,Gm\u00117bgNDq!a\r\u0010\u0001\u0004\t)$A\u0004bI\u0012\u0004\u0016\r\u001e5\u0011\u0007q\n9$C\u0002\u0002:5\u0012qAQ8pY\u0016\fg.\u0001\u0005dY\u0006\u001c8OU8x)\rq\u0018q\b\u0005\b\u0003\u0003\u0002\u0002\u0019AA\u0016\u0003\u0015YG.Y:t\u0003-\u0001\u0018mY6bO\u0016d\u0015n\u001d;\u0015\u0007y\f9\u0005C\u0003b#\u0001\u0007!-A\u0003sSN\\7\u000f\u0006\u0004\u0002\u0010\u00055\u0013q\n\u0005\u0006CJ\u0001\rA\u0019\u0005\b\u0003#\u0012\u0002\u0019AA*\u0003\u0015a\u0017.\\5u!\ra\u0014QK\u0005\u0004\u0003/j#aA%oi\u0006I\u0001/Y2lC\u001e,7O\r\u000b\u0005\u0003\u001f\ti\u0006C\u0003b'\u0001\u0007!-\u0001\u0005pm\u0016\u0014h/[3x)\rq\u00181\r\u0005\u0006CR\u0001\rAY\u0001\u0006gR\fGo\u001d\u000b\u0004}\u0006%\u0004\"B1\u0016\u0001\u0004\u0011\u0017a\u00029mk\u001eLgn]\u000b\u0003\u0003_\u00022a`A9\u0013\u0011\t\u0019(!\u0001\u0003\u00159{G-\u001a\"vM\u001a,'\u000f")
public class ScoverageHtmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final Option<String> sourceEncoding;

    public void write(Coverage coverage) {
        File indexFile = new File(new StringBuilder(11).append(this.outputDir.getAbsolutePath()).append("/index.html").toString());
        File cssFile = new File(new StringBuilder(13).append(this.outputDir.getAbsolutePath()).append("/pure-min.css").toString());
        File packageFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/packages.html").toString());
        File overviewFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/overview.html").toString());
        String index = IOUtils$.MODULE$.readStreamAsString(this.getClass().getResourceAsStream("/scoverage/index.html"));
        String css = IOUtils$.MODULE$.readStreamAsString(this.getClass().getResourceAsStream("/scoverage/pure-min.css"));
        IOUtils$.MODULE$.writeToFile(indexFile, index);
        IOUtils$.MODULE$.writeToFile(cssFile, css);
        IOUtils$.MODULE$.writeToFile(packageFile, this.packageList(coverage).toString());
        IOUtils$.MODULE$.writeToFile(overviewFile, this.overview(coverage).toString());
        coverage.packages().foreach((Function1 & Serializable & scala.Serializable)pkg -> {
            this.writePackage(pkg);
            return BoxedUnit.UNIT;
        });
    }

    private void writePackage(MeasuredPackage pkg) {
        File file = new File(this.outputDir, this.packageOverviewRelativePath(pkg));
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.packageOverview(pkg).toString());
        pkg.files().foreach((Function1 & Serializable & scala.Serializable)mfile -> {
            this.writeFile(mfile);
            return BoxedUnit.UNIT;
        });
    }

    private void writeFile(MeasuredFile mfile) {
        File file = new File(this.outputDir, new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString());
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.filePage(mfile).toString());
    }

    private String packageOverviewRelativePath(MeasuredPackage pkg) {
        return new StringBuilder(5).append(pkg.name().replace("<empty>", "(empty)")).append(".html").toString();
    }

    private Node filePage(MeasuredFile mfile) {
        String filename = new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString();
        String css = "table.codegrid { font-family: monospace; font-size: 12px; width: auto!important; }table.statementlist { width: auto!important; font-size: 13px; } table.codegrid td { padding: 0!important; border: 0!important } table td.linenumber { width: 40px!important; } ";
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)filename);
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)css);
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("nav nav-tabs"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("#codegrid"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Codegrid"));
        $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("href", (Seq)new Text("#statementlist"), (MetaData)$md6);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Statement List"));
        $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("tab-content"), (MetaData)$md7);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("codegrid"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane active"), (MetaData)$md8);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)Unparsed$.MODULE$.apply(new CodeGrid(mfile, this.sourceEncoding).highlighted()));
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("id", (Seq)new Text("statementlist"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane"), (MetaData)$md9);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf13.$amp$plus((Object)new StatementWriter(mfile).output());
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public Elem header() {
        void var2_2;
        String css = new StringOps(Predef$.MODULE$.augmentString(".meter {\n                |        height: 14px;\n                |        position: relative;\n                |        background: #BB2020;\n                |}\n                |\n                |.meter span {\n                |\tdisplay: block;\n                |\theight: 100%;\n                |\tbackground-color: rgb(43,194,83);\n                |\tbackground-image: -webkit-gradient(\n                |\t  linear,\n                |\t  left bottom,\n                |\t  left top,\n                |\t  color-stop(0, rgb(43,194,83)),\n                |\t  color-stop(1, rgb(84,240,84))\n                |\t );\n                |\tbackground-image: -webkit-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -moz-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -ms-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -o-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\t-webkit-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\t-moz-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\tposition: relative;\n                |\toverflow: hidden;\n                |}")).stripMargin();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Scoverage Code Coverage"));
        $buf.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.plugins());
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)css);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Node packageOverview(MeasuredPackage pack) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)pack.classes(), false));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public Node classesTable(Iterable<MeasuredClass> classes, boolean addPath) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size:13px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Source file\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus(((TraversableLike)classes.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.fullClassName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)klass -> this.classRow((MeasuredClass)klass), Seq$.MODULE$.canBuildFrom()));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Node classRow(MeasuredClass klass) {
        File fileRelativeToSource = new File(new StringBuilder(5).append(this.relativeSource(klass.source())).append(".html").toString());
        String path = fileRelativeToSource.getParent();
        String value = fileRelativeToSource.getName();
        String filename = path != "" ? fileRelativeToSource.toString().replace(File.separator, "/") : value;
        String statement0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(klass.statementCoveragePercent())))).toString();
        String branch0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(klass.branchCoveragePercent())))).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", filename, (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)klass.displayClassName());
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(klass.statements().headOption().map((Function1 & Serializable & scala.Serializable)x$2 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$2.source())).split(File.separatorChar))).last()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.loc())).toString());
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.methodCount())).toString());
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.statementCount())).toString());
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.invokedStatementCount())).toString());
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md2);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md3);
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)klass.statementCoverageFormatted());
        $buf11.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf12.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.branchCount())).toString());
        $buf12.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf13.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.invokedBranchesCount())).toString());
        $buf13.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md4);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md5);
        $buf15.$amp$plus((Object)new Elem(null, "span", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf14.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus((Object)klass.branchCoverageFormatted());
        $buf16.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public Node packageList(Coverage coverage) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Scoverage Code Coverage\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("font-size: 13px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("overview.html"), (MetaData)$md5);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("All packages"));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf10.$amp$plus((Object)new Text("%"));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus(coverage.packages().map((Function1 & Serializable & scala.Serializable)arg -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md);
            $md = new UnprefixedAttribute("href", this.packageOverviewRelativePath((MeasuredPackage)arg), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("%"));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
        }, Seq$.MODULE$.canBuildFrom()));
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "table", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public Elem risks(Coverage coverage, int limit) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size: 12px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statement Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Branch Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus(coverage.risks(limit).map((Function1 & Serializable & scala.Serializable)klass -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)klass.displayClassName());
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.loc())).toString());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.methodCount())).toString());
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.statementCount())).toString());
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n            "));
            $buf6.$amp$plus((Object)klass.statementCoverageFormatted());
            $buf6.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.branchCount())).toString());
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n            "));
            $buf8.$amp$plus((Object)klass.branchCoverageFormatted());
            $buf8.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf.$amp$plus((Object)new Text("\n        "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
        }, Seq$.MODULE$.canBuildFrom()));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public Elem packages2(Coverage coverage) {
        void var3_3;
        Seq rows = (Seq)coverage.packages().map((Function1 & Serializable & scala.Serializable)arg -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)arg.invokedClasses())).toString());
            $buf3.$amp$plus((Object)new Text("\n          /\n          "));
            $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.classCount()));
            $buf3.$amp$plus((Object)new Text("\n          (\n          "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToDouble((double)arg.classCoverage())).toString());
            $buf3.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)arg.invokedStatements().toString());
            $buf4.$amp$plus((Object)new Text("\n          /\n          "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.statementCount()));
            $buf4.$amp$plus((Object)new Text("\n          (\n          "));
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)rows);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Node overview(Coverage coverage) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("alert alert-info"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          SCoverage\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n        generated at\n        "));
        $buf3.$amp$plus((Object)new Date().toString());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("overview"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("stats"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)this.stats(coverage));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)coverage.classes(), true));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public Node stats(Coverage coverage) {
        String statement0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(coverage.statementCoveragePercent())))).toString();
        String branch0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(coverage.branchCoveragePercent())))).toString();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Lines of code:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.loc())).toString());
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          Files:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.fileCount())).toString());
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          Classes:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.classCount())).toString());
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          Methods:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf10.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.methodCount())).toString());
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n          Lines per file:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf13.$amp$plus((Object)coverage.linesPerFileFormatted());
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n          Packages:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf15.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.packageCount())).toString());
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n          Classes per package:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus((Object)coverage.avgClassesPerPackageFormatted());
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n          Methods per class:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n          "));
        $buf19.$amp$plus((Object)coverage.avgMethodsPerClassFormatted());
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n          Total statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n          "));
        $buf22.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.statementCount())).toString());
        $buf22.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n          Invoked statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf24 = new NodeBuffer();
        $buf24.$amp$plus((Object)new Text("\n          "));
        $buf24.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.invokedStatementCount())).toString());
        $buf24.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("\n          Total branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)new Text("\n          "));
        $buf26.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.branchCount())).toString());
        $buf26.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)new Text("\n          Invoked branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)new Text("\n          "));
        $buf28.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.invokedBranchesCount())).toString());
        $buf28.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
        $buf20.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)new Text("\n          Ignored statements:\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf30));
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("\n          "));
        $buf31.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.ignoredStatementCount())).toString());
        $buf31.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf31));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf32 = new NodeBuffer();
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("\n          Statement coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf33));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("\n          "));
        $buf34.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf34.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf34));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md2);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md3);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md4);
        $buf36.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf36.$amp$plus((Object)new Text("\n          "));
        $buf35.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf36));
        $buf35.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf35));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          Branch coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf37));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf38.$amp$plus((Object)coverage.branchCoverageFormatted());
        $buf38.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf38));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md5);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md6);
        NodeBuffer $buf40 = new NodeBuffer();
        $buf40.$amp$plus((Object)new Text("\n            "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md7);
        $buf40.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf40.$amp$plus((Object)new Text("\n          "));
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf40));
        $buf39.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf39));
        $buf32.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf32));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public NodeBuffer plugins() {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", (Seq)new Text("https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/css/theme.default.min.css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/js/jquery.tablesorter.min.js"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/js/bootstrap.min.js"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md6);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)Unparsed$.MODULE$.apply("$(document).ready(function() {$(\".tablesorter\").tablesorter();});"));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        return var1_1;
    }

    public ScoverageHtmlWriter(Seq<File> sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this.outputDir = outputDir;
        this.sourceEncoding = sourceEncoding;
        super(sourceDirectories, outputDir);
    }

    public ScoverageHtmlWriter(File[] sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this((Seq<File>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDirectories)).toSeq(), outputDir, sourceEncoding);
    }

    public ScoverageHtmlWriter(Seq<File> sourceDirectories, File outputDir) {
        this(sourceDirectories, outputDir, (Option<String>)None$.MODULE$);
    }

    public ScoverageHtmlWriter(File sourceDirectory, File outputDir) {
        this((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{sourceDirectory}))), outputDir);
    }
}

