/*
 * Decompiled with CFR 0.152.
 */
package scoverage.serialize;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scoverage.domain.ClassType$;
import scoverage.domain.Constants$;
import scoverage.domain.Coverage;
import scoverage.domain.Coverage$;
import scoverage.domain.Location;
import scoverage.domain.Location$;
import scoverage.domain.Statement;
import scoverage.domain.Statement$;

public final class Serializer$
implements Serializable {
    public static final Serializer$ MODULE$ = new Serializer$();

    private Serializer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serializer$.class);
    }

    public File coverageFile(File dataDir) {
        return this.coverageFile(dataDir.getAbsolutePath());
    }

    public File coverageFile(String dataDir) {
        return new File(dataDir, Constants$.MODULE$.CoverageFileName());
    }

    public void serialize(Coverage coverage, String dataDir, String sourceRoot) {
        this.serialize(coverage, this.coverageFile(dataDir), new File(sourceRoot));
    }

    public void serialize(Coverage coverage, File file, File sourceRoot) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Codec$.MODULE$.UTF8().name()));
        try {
            this.serialize(coverage, writer, sourceRoot);
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    public void serialize(Coverage coverage, Writer writer, File sourceRoot) {
        this.writeHeader$1(writer);
        ((IterableOnceOps)coverage.statements().toSeq().sortBy((Function1 & Serializable)_$1 -> _$1.id(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)stmt -> this.writeStatement$1(sourceRoot, (Statement)stmt, writer));
    }

    public Coverage deserialize(File file, File sourceRoot) {
        Coverage coverage;
        try (BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8());){
            coverage = this.deserialize((Iterator<String>)source.getLines(), sourceRoot);
        }
        return coverage;
    }

    public Coverage deserialize(Iterator<String> lines, File sourceRoot) {
        String headerFirstLine;
        String string = headerFirstLine = (String)lines.next();
        String string2 = new StringBuilder(33).append("# Coverage data, format version: ").append(Constants$.MODULE$.CoverageDataFormatVersion()).toString();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), this::deserialize$$anonfun$1);
        Iterator linesWithoutHeader = lines.dropWhile((Function1 & Serializable)_$2 -> _$2.startsWith("#"));
        Coverage coverage = Coverage$.MODULE$.apply();
        while (!linesWithoutHeader.isEmpty()) {
            Iterator oneStatementLines = linesWithoutHeader.takeWhile((Function1 & Serializable)_$3 -> {
                String string = _$3;
                String string2 = "\f";
                return string == null ? string2 != null : !string.equals(string2);
            });
            Statement statement = this.toStatement$1(sourceRoot, oneStatementLines);
            if (statement.ignored()) {
                coverage.addIgnoredStatement(statement);
                continue;
            }
            coverage.add(statement);
        }
        return coverage;
    }

    public void clean(File dataDir) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.findMeasurementFiles(dataDir));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)_$4 -> _$4.delete());
    }

    public void clean(String dataDir) {
        this.clean(new File(dataDir));
    }

    public File[] findMeasurementFiles(File dataDir) {
        return dataDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
            }
        });
    }

    private final String getRelativePath$1(File sourceRoot$1, String filePath) {
        Path base = sourceRoot$1.getCanonicalFile().toPath();
        Path relPath = base.relativize(new File(filePath).getCanonicalFile().toPath());
        return relPath.toString();
    }

    private final void writeHeader$1(Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(644).append("# Coverage data, format version: ").append(Constants$.MODULE$.CoverageDataFormatVersion()).append("\n           |# Statement data:\n           |# - id\n           |# - source path\n           |# - package name\n           |# - class name\n           |# - class type (Class, Object or Trait)\n           |# - full class name\n           |# - method name\n           |# - start offset\n           |# - end offset\n           |# - line number\n           |# - symbol name\n           |# - tree name\n           |# - is branch\n           |# - invocations count\n           |# - is ignored\n           |# - description (can be multi-line)\n           |# '\f' sign\n           |# ------------------------------------------\n           |").toString())));
    }

    private final void writeStatement$1(File sourceRoot$4, Statement stmt, Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(409).append(stmt.id()).append("\n                      |").append(this.getRelativePath$1(sourceRoot$4, stmt.location().sourcePath())).append("\n                      |").append(stmt.location().packageName()).append("\n                      |").append(stmt.location().className()).append("\n                      |").append(stmt.location().classType()).append("\n                      |").append(stmt.location().fullClassName()).append("\n                      |").append(stmt.location().method()).append("\n                      |").append(stmt.start()).append("\n                      |").append(stmt.end()).append("\n                      |").append(stmt.line()).append("\n                      |").append(stmt.symbolName()).append("\n                      |").append(stmt.treeName()).append("\n                      |").append(stmt.branch()).append("\n                      |").append(stmt.count()).append("\n                      |").append(stmt.ignored()).append("\n                      |").append(stmt.desc()).append("\n                      |\f\n                      |").toString())));
    }

    private final String getAbsolutePath$1(File sourceRoot$3, String filePath) {
        return new File(sourceRoot$3, filePath).getCanonicalPath();
    }

    private final Statement toStatement$1(File sourceRoot$5, Iterator lines) {
        int id = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String sourcePath = (String)lines.next();
        String packageName = (String)lines.next();
        String className = (String)lines.next();
        String classType = (String)lines.next();
        String fullClassName = (String)lines.next();
        String method = (String)lines.next();
        Location loc = Location$.MODULE$.apply(packageName, className, fullClassName, ClassType$.MODULE$.fromString(classType), method, this.getAbsolutePath$1(sourceRoot$5, sourcePath));
        int start = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int end = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int lineNo = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String symbolName = (String)lines.next();
        String treeName = (String)lines.next();
        boolean branch = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int count = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        boolean ignored = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String desc = lines.toList().mkString("\n");
        return Statement$.MODULE$.apply(loc, id, start, end, lineNo, desc, symbolName, treeName, branch, count, ignored, Statement$.MODULE$.$lessinit$greater$default$12());
    }

    private final Object deserialize$$anonfun$1() {
        return "Wrong file format";
    }
}

