/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import org.scoverage.plugin.ScalaVersion;

@Mojo(name="pre-compile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SCoveragePreCompileMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scala.version")
    private String scalaVersion;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.excludedPackages", defaultValue="")
    private String excludedPackages;
    @Parameter(property="scoverage.excludedFiles", defaultValue="")
    private String excludedFiles;
    @Parameter(property="scoverage.highlighting", defaultValue="true")
    private boolean highlighting;
    @Parameter(property="scoverage.scalacPluginVersion", defaultValue="2.0.11")
    private String scalacPluginVersion;
    @Parameter(property="scoverage.additionalForkedProjectProperties", defaultValue="")
    private String additionalForkedProjectProperties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    private ArtifactRepository localRepo;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepos;
    @Parameter(property="plugin.artifacts", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;
    private static final String SCALA_LIBRARY_GROUP_ID = "org.scala-lang";
    private static final String SCALA2_LIBRARY_ARTIFACT_ID = "scala-library";
    private static final String SCALA3_LIBRARY_ARTIFACT_ID = "scala3-library_3";
    private static final String SCALA2_DATA_DIR_OPTION = "-P:scoverage:dataDir:";
    private static final String SCALA3_COVERAGE_OUT_OPTION = "-coverage-out:";
    private static final String SOURCE_ROOT_OPTION = "-P:scoverage:sourceRoot:";
    private static final String EXCLUDED_PACKAGES_OPTION = "-P:scoverage:excludedPackages:";
    private static final String EXCLUDED_FILES_OPTION = "-P:scoverage:excludedFiles:";
    private static final String PLUGIN_OPTION = "-Xplugin:";
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char PIPE = '|';

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution");
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "maven.test.skip", "true");
            this.setProperty(projectProperties, "skipTests", "true");
            return;
        }
        long ts = System.currentTimeMillis();
        ScalaVersion resolvedScalaVersion = this.resolveScalaVersion();
        if (resolvedScalaVersion != null) {
            boolean supportedScalaVersion;
            boolean bl = supportedScalaVersion = resolvedScalaVersion.isScala2() && resolvedScalaVersion.isAtLeast("2.12.8") || resolvedScalaVersion.isAtLeast("3.2.0");
            if (!supportedScalaVersion) {
                this.getLog().warn((CharSequence)String.format("Skipping SCoverage execution - unsupported Scala version \"%s\". Supported Scala versions are 2.12.8+, 2.13.0+ and 3.2.0+ .", resolvedScalaVersion.full));
                return;
            }
        } else {
            this.getLog().warn((CharSequence)"Skipping SCoverage execution - Scala version not set");
            return;
        }
        HashMap<String, String> additionalProjectPropertiesMap = null;
        if (this.additionalForkedProjectProperties != null && !this.additionalForkedProjectProperties.isEmpty()) {
            String[] props = this.additionalForkedProjectProperties.split(";");
            additionalProjectPropertiesMap = new HashMap<String, String>(props.length);
            for (String propVal : props) {
                String[] tmp = propVal.split("=", 2);
                if (tmp.length == 2) {
                    String propName = tmp[0].trim();
                    String propValue = tmp[1].trim();
                    additionalProjectPropertiesMap.put(propName, propValue);
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Skipping invalid additional forked project property \"%s\", must be in \"key=value\" format", propVal));
            }
        }
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleEnter(this.project, this.reactorProjects, additionalProjectPropertiesMap);
        try {
            String _scalacPlugins;
            boolean scala2 = resolvedScalaVersion.isScala2();
            List<Artifact> pluginArtifacts = this.getScalaScoveragePluginArtifacts(resolvedScalaVersion);
            if (scala2) {
                Artifact runtimeArtifact = this.getScalaScoverageRuntimeArtifact(resolvedScalaVersion);
                this.addScoverageDependenciesToClasspath(runtimeArtifact);
            }
            Object arg = (scala2 ? SCALA2_DATA_DIR_OPTION : SCALA3_COVERAGE_OUT_OPTION) + this.dataDirectory.getAbsolutePath();
            Object _scalacOptions = this.quoteArgument((String)arg);
            String addScalacArgs = arg;
            arg = scala2 ? SOURCE_ROOT_OPTION + this.session.getExecutionRootDirectory() : "";
            _scalacOptions = (String)_scalacOptions + " " + this.quoteArgument((String)arg);
            addScalacArgs = addScalacArgs + "|" + (String)arg;
            if (!StringUtils.isEmpty((String)this.excludedPackages)) {
                arg = EXCLUDED_PACKAGES_OPTION + this.excludedPackages.replace("(empty)", "<empty>");
                _scalacOptions = (String)_scalacOptions + " " + this.quoteArgument((String)arg);
                addScalacArgs = addScalacArgs + "|" + (String)arg;
            }
            if (!StringUtils.isEmpty((String)this.excludedFiles)) {
                arg = EXCLUDED_FILES_OPTION + this.excludedFiles;
                _scalacOptions = (String)_scalacOptions + " " + this.quoteArgument((String)arg);
                addScalacArgs = addScalacArgs + "|" + (String)arg;
            }
            if (this.highlighting && scala2) {
                _scalacOptions = (String)_scalacOptions + " -Yrangepos";
                addScalacArgs = addScalacArgs + "|-Yrangepos";
            }
            String string = _scalacPlugins = scala2 ? pluginArtifacts.stream().map(x -> String.format("%s:%s:%s", x.getGroupId(), x.getArtifactId(), x.getVersion())).collect(Collectors.joining(" ")) : "";
            if (scala2) {
                arg = PLUGIN_OPTION + pluginArtifacts.stream().map(x -> x.getFile().getAbsolutePath()).collect(Collectors.joining(String.valueOf(File.pathSeparatorChar)));
                addScalacArgs = addScalacArgs + "|" + (String)arg;
            }
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "sbt._scalacOptions", (String)_scalacOptions);
            this.setProperty(projectProperties, "sbt._scalacPlugins", _scalacPlugins);
            this.setProperty(projectProperties, "addScalacArgs", addScalacArgs);
            this.setProperty(projectProperties, "analysisCacheFile", "${project.build.directory}/scoverage-analysis/compile");
            this.setProperty(projectProperties, "maven.test.failure.ignore", "true");
            this.project.getBuild().setFinalName("scoverage-" + this.project.getBuild().getFinalName());
            this.saveSourceRootsToFile();
        }
        catch (IOException | ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoExecutionException("SCoverage preparation failed", (Exception)e);
        }
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private String quoteArgument(String arg) {
        return arg.indexOf(32) >= 0 ? "\"" + arg + "\"" : arg;
    }

    private ScalaVersion resolveScalaVersion() {
        String result = this.scalaVersion;
        if (result == null || result.isEmpty()) {
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (!SCALA_LIBRARY_GROUP_ID.equals(dependency.getGroupId()) || !SCALA2_LIBRARY_ARTIFACT_ID.equals(dependency.getArtifactId()) && !SCALA3_LIBRARY_ARTIFACT_ID.equals(dependency.getArtifactId())) continue;
                result = dependency.getVersion();
                break;
            }
        }
        return result != null ? new ScalaVersion(result) : null;
    }

    private void setProperty(Properties projectProperties, String propertyName, String newValue) {
        if (projectProperties.containsKey(propertyName)) {
            String oldValue = projectProperties.getProperty(propertyName);
            projectProperties.put("scoverage.backup." + propertyName, oldValue);
        } else {
            projectProperties.remove("scoverage.backup." + propertyName);
        }
        if (newValue != null) {
            projectProperties.put(propertyName, newValue);
        } else {
            projectProperties.remove(propertyName);
        }
    }

    private ArtifactVersion getScalacPluginVersion() {
        if (this.scalacPluginVersion == null || this.scalacPluginVersion.isEmpty()) {
            throw new IllegalStateException("scalacPluginVersion is unset.");
        }
        if (this.scalacPluginVersion.startsWith("1.")) {
            throw new IllegalStateException(String.format("Unsupported scalacPluginVersion \"%s\". Please use scalacPluginVersion 2.0.0+ or use older version of scoverage-maven-plugin", this.scalacPluginVersion));
        }
        return new DefaultArtifactVersion(this.scalacPluginVersion);
    }

    private List<Artifact> getScalaScoveragePluginArtifacts(ScalaVersion resolvedScalaVersion) throws ArtifactNotFoundException, ArtifactResolutionException {
        String resolvedScalacPluginVersion = this.getScalacPluginVersion().toString();
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        if (resolvedScalaVersion.isScala2()) {
            resolvedArtifacts.add(this.getResolvedArtifact("org.scoverage", "scalac-scoverage-plugin_" + resolvedScalaVersion.full, resolvedScalacPluginVersion));
        }
        resolvedArtifacts.add(this.getResolvedArtifact("org.scoverage", "scalac-scoverage-domain_" + resolvedScalaVersion.compatible, resolvedScalacPluginVersion));
        resolvedArtifacts.add(this.getResolvedArtifact("org.scoverage", "scalac-scoverage-serializer_" + resolvedScalaVersion.compatible, resolvedScalacPluginVersion));
        return resolvedArtifacts;
    }

    private Artifact getScalaScoverageRuntimeArtifact(ScalaVersion resolvedScalaVersion) throws ArtifactNotFoundException, ArtifactResolutionException {
        return this.getResolvedArtifact("org.scoverage", "scalac-scoverage-runtime_" + resolvedScalaVersion.compatible, this.getScalacPluginVersion().toString());
    }

    private void addScoverageDependenciesToClasspath(Artifact scalaScoveragePluginArtifact) {
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.project.getDependencyArtifacts());
        set.add(scalaScoveragePluginArtifact);
        this.project.setDependencyArtifacts(set);
    }

    private Artifact getResolvedArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "compile", "jar");
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSourceRootsToFile() throws IOException {
        List sourceRoots = this.project.getCompileSourceRoots();
        if (!sourceRoots.isEmpty()) {
            if (!this.dataDirectory.exists() && !this.dataDirectory.mkdirs()) {
                throw new IOException(String.format("Cannot create \"%s\" directory ", this.dataDirectory.getAbsolutePath()));
            }
            File sourceRootsFile = new File(this.dataDirectory, "source.roots");
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sourceRootsFile), "UTF-8"));){
                for (String sourceRoot : sourceRoots) {
                    writer.write(sourceRoot);
                    writer.newLine();
                }
            }
        }
    }
}

