/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="post-compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SCoveragePostCompileMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.skip) {
            return;
        }
        long ts = System.currentTimeMillis();
        Properties projectProperties = this.project.getProperties();
        this.restoreProperty(projectProperties, "addScalacArgs");
        this.restoreProperty(projectProperties, "analysisCacheFile");
        this.restoreProperty(projectProperties, "maven.test.failure.ignore");
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private void restoreProperty(Properties projectProperties, String propertyName) {
        if (projectProperties.containsKey("scoverage.backup." + propertyName)) {
            String oldValue = projectProperties.getProperty("scoverage.backup." + propertyName);
            projectProperties.put(propertyName, oldValue);
            projectProperties.remove("scoverage.backup." + propertyName);
        } else {
            projectProperties.remove(propertyName);
        }
    }
}

