/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import org.scoverage.plugin.ScalaVersion;

@Mojo(name="pre-compile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SCoveragePreCompileMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scala.version")
    private String scalaVersion;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.excludedPackages")
    private String excludedPackages;
    @Parameter(property="scoverage.excludedFiles")
    private String excludedFiles;
    @Parameter(property="scoverage.highlighting", defaultValue="true")
    private boolean highlighting;
    @Parameter(property="scoverage.scalacPluginVersion", defaultValue="2.3.0")
    private String scalacPluginVersion;
    @Parameter(property="scoverage.additionalForkedProjectProperties")
    private String additionalForkedProjectProperties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Inject
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepos;
    private static final String SCALA_LIBRARY_GROUP_ID = "org.scala-lang";
    private static final String SCALA2_LIBRARY_ARTIFACT_ID = "scala-library";
    private static final String SCALA3_LIBRARY_ARTIFACT_ID = "scala3-library_3";
    private static final String SCALA2_DATA_DIR_OPTION = "-P:scoverage:dataDir:";
    private static final String SCALA3_COVERAGE_OUT_OPTION = "-coverage-out:";
    private static final String SOURCE_ROOT_OPTION = "-P:scoverage:sourceRoot:";
    private static final String SCALA2_EXCLUDED_PACKAGES_OPTION = "-P:scoverage:excludedPackages:";
    private static final String SCALA3_EXCLUDED_PACKAGES_OPTION = "-coverage-exclude-classlikes:";
    private static final String SCALA2_EXCLUDED_FILES_OPTION = "-P:scoverage:excludedFiles:";
    private static final String SCALA3_EXCLUDED_FILES_OPTION = "-coverage-exclude-files:";
    private static final String PLUGIN_OPTION = "-Xplugin:";
    private static final char PIPE = '|';

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution as configured");
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "maven.main.skip", "true");
            this.setProperty(projectProperties, "maven.test.skip", "true");
            this.setProperty(projectProperties, "skipTests", "true");
            return;
        }
        long ts = System.currentTimeMillis();
        ScalaVersion scalaVersion = this.resolveScalaVersion();
        if (scalaVersion != null) {
            boolean supportedScalaVersion;
            boolean bl = supportedScalaVersion = scalaVersion.isScala2() && scalaVersion.isAtLeast("2.12.8") || scalaVersion.isAtLeast("3.2.0");
            if (!supportedScalaVersion) {
                this.getLog().warn((CharSequence)String.format("Skipping SCoverage execution - unsupported Scala version \"%s\". Supported Scala versions are 2.12.8+, 2.13.0+ and 3.2.0+ .", scalaVersion.full));
                return;
            }
        } else {
            this.getLog().warn((CharSequence)"Skipping SCoverage execution - Scala version not set");
            return;
        }
        HashMap<String, String> additionalProjectPropertiesMap = null;
        if (this.additionalForkedProjectProperties != null && !this.additionalForkedProjectProperties.isEmpty()) {
            String[] props = this.additionalForkedProjectProperties.split(";");
            additionalProjectPropertiesMap = new HashMap<String, String>(props.length);
            for (String propVal : props) {
                String[] tmp = propVal.split("=", 2);
                if (tmp.length == 2) {
                    String propName = tmp[0].trim();
                    String propValue = tmp[1].trim();
                    additionalProjectPropertiesMap.put(propName, propValue);
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Skipping invalid additional forked project property \"%s\", must be in \"key=value\" format", propVal));
            }
        }
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleEnter(this.project, this.reactorProjects, additionalProjectPropertiesMap);
        try {
            boolean scala2 = scalaVersion.isScala2();
            boolean filePackageExclusionSupportingScala3 = scalaVersion.isAtLeast("3.4.2") || scalaVersion.full.startsWith("3.3.") && scalaVersion.isAtLeast("3.3.4");
            List<Artifact> pluginArtifacts = this.getScoveragePluginArtifacts(scalaVersion);
            if (scala2) {
                this.addScalacScoverageRuntimeDependencyToClasspath(scalaVersion);
            }
            Object arg = (scala2 ? SCALA2_DATA_DIR_OPTION : SCALA3_COVERAGE_OUT_OPTION) + this.dataDirectory.getAbsolutePath();
            String addScalacArgs = arg;
            arg = scala2 ? SOURCE_ROOT_OPTION + this.session.getExecutionRootDirectory() : "";
            addScalacArgs = addScalacArgs + "|" + (String)arg;
            if (!StringUtils.isEmpty((String)this.excludedPackages)) {
                if (scala2) {
                    arg = SCALA2_EXCLUDED_PACKAGES_OPTION + this.excludedPackages.replace("(empty)", "<empty>");
                    addScalacArgs = addScalacArgs + "|" + (String)arg;
                } else if (filePackageExclusionSupportingScala3) {
                    String scala3FormatExcludedPackages = this.excludedPackages.replace(";", ",");
                    arg = SCALA3_EXCLUDED_PACKAGES_OPTION + scala3FormatExcludedPackages;
                    addScalacArgs = addScalacArgs + "|" + (String)arg;
                } else {
                    this.getLog().warn((CharSequence)"Package exclusion is supported for Scala [3.3.4-3.4.0) or 3.4.2+");
                }
            }
            if (!StringUtils.isEmpty((String)this.excludedFiles)) {
                if (scala2) {
                    arg = SCALA2_EXCLUDED_FILES_OPTION + this.excludedFiles;
                    addScalacArgs = addScalacArgs + "|" + (String)arg;
                } else if (filePackageExclusionSupportingScala3) {
                    String scala3FormatExcludedFiles = this.excludedFiles.replace(";", ",");
                    arg = SCALA3_EXCLUDED_FILES_OPTION + scala3FormatExcludedFiles;
                    addScalacArgs = addScalacArgs + "|" + (String)arg;
                } else {
                    this.getLog().warn((CharSequence)"File exclusion is supported for Scala [3.3.4-3.4.0) or 3.4.2+");
                }
            }
            if (this.highlighting && scala2) {
                addScalacArgs = addScalacArgs + "|-Yrangepos";
            }
            if (scala2) {
                arg = PLUGIN_OPTION + pluginArtifacts.stream().map(x -> x.getFile().getAbsolutePath()).collect(Collectors.joining(String.valueOf(File.pathSeparatorChar)));
                addScalacArgs = addScalacArgs + "|" + (String)arg;
            }
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "addScalacArgs", addScalacArgs);
            this.setProperty(projectProperties, "analysisCacheFile", "${project.build.directory}/scoverage-analysis/compile");
            this.setProperty(projectProperties, "maven.test.failure.ignore", "true");
            this.project.getBuild().setFinalName("scoverage-" + this.project.getBuild().getFinalName());
            this.saveSourceRootsToFile();
        }
        catch (IOException | ArtifactResolutionException e) {
            throw new MojoExecutionException("SCoverage preparation failed", (Exception)e);
        }
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private ScalaVersion resolveScalaVersion() {
        String result = this.scalaVersion;
        if (result == null || result.isEmpty()) {
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (!SCALA_LIBRARY_GROUP_ID.equals(dependency.getGroupId()) || !SCALA2_LIBRARY_ARTIFACT_ID.equals(dependency.getArtifactId()) && !SCALA3_LIBRARY_ARTIFACT_ID.equals(dependency.getArtifactId())) continue;
                result = dependency.getVersion();
                break;
            }
        }
        return result != null ? new ScalaVersion(result) : null;
    }

    private void setProperty(Properties projectProperties, String propertyName, String newValue) {
        if (projectProperties.containsKey(propertyName)) {
            String oldValue = projectProperties.getProperty(propertyName);
            projectProperties.put("scoverage.backup." + propertyName, oldValue);
        } else {
            projectProperties.remove("scoverage.backup." + propertyName);
        }
        if (newValue != null) {
            projectProperties.put(propertyName, newValue);
        } else {
            projectProperties.remove(propertyName);
        }
    }

    private String getScalacPluginVersion() {
        if (StringUtils.isEmpty((String)this.scalacPluginVersion)) {
            throw new IllegalStateException("scalacPluginVersion is unset.");
        }
        if (this.scalacPluginVersion.startsWith("1.")) {
            throw new IllegalStateException(String.format("Unsupported scalacPluginVersion \"%s\". Please use scalacPluginVersion 2.0.0+ or use older version of scoverage-maven-plugin", this.scalacPluginVersion));
        }
        return this.scalacPluginVersion;
    }

    private List<Artifact> getScoveragePluginArtifacts(ScalaVersion scalaVersion) throws ArtifactResolutionException {
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        if (scalaVersion.isScala2()) {
            resolvedArtifacts.add(this.resolveScoverageArtifact("scalac-scoverage-plugin_" + scalaVersion.full));
        }
        resolvedArtifacts.add(this.resolveScoverageArtifact("scalac-scoverage-domain_" + scalaVersion.compatible));
        resolvedArtifacts.add(this.resolveScoverageArtifact("scalac-scoverage-serializer_" + scalaVersion.compatible));
        return resolvedArtifacts;
    }

    private void addScalacScoverageRuntimeDependencyToClasspath(ScalaVersion resolvedScalaVersion) throws ArtifactResolutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> set = new LinkedHashSet<org.apache.maven.artifact.Artifact>(this.project.getDependencyArtifacts());
        set.add(this.toMavenClasspathArtifact(this.resolveScoverageArtifact("scalac-scoverage-runtime_" + resolvedScalaVersion.compatible)));
        this.project.setDependencyArtifacts(set);
    }

    private org.apache.maven.artifact.Artifact toMavenClasspathArtifact(Artifact artifact) {
        DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler(artifact.getExtension());
        artifactHandler.setAddedToClasspath(true);
        return new org.apache.maven.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "compile", artifact.getExtension(), artifact.getClassifier(), (ArtifactHandler)artifactHandler);
    }

    private Artifact resolveScoverageArtifact(String artifactId) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)new DefaultArtifact("org.scoverage", artifactId, "jar", this.getScalacPluginVersion()));
        request.setRepositories(this.remoteRepos);
        ArtifactResult result = this.repositorySystem.resolveArtifact(this.repoSession, request);
        return result.getArtifact();
    }

    private void saveSourceRootsToFile() throws IOException {
        List sourceRoots = this.project.getCompileSourceRoots();
        if (!sourceRoots.isEmpty()) {
            if (!this.dataDirectory.exists() && !this.dataDirectory.mkdirs()) {
                throw new IOException(String.format("Cannot create \"%s\" directory ", this.dataDirectory.getAbsolutePath()));
            }
            File sourceRootsFile = new File(this.dataDirectory, "source.roots");
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sourceRootsFile), StandardCharsets.UTF_8));){
                for (String sourceRoot : sourceRoots) {
                    writer.write(sourceRoot);
                    writer.newLine();
                }
            }
        }
    }
}

