/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScalaVersion {
    private static final Pattern regexp = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?([-\\.].+)?");
    public String full;
    public String compatible;
    public int major;
    public int minor;
    public int bugfix;
    public String modifier;

    public ScalaVersion(String s) {
        this.full = s;
        Matcher match = regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("Invalid Scala version [" + s + "]. Expected major.minor(.bugfix)(modifier)");
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = Integer.parseInt(match.group(2));
        if (match.group(3) != null && match.group(3).length() > 1) {
            this.bugfix = Integer.parseInt(match.group(3).substring(1));
        }
        if (match.group(4) != null && match.group(4).length() > 1) {
            this.modifier = match.group(4);
        }
        this.compatible = this.modifier != null ? this.full : (this.major == 2 ? this.major + "." + this.minor : "" + this.major);
    }

    public boolean isAtLeast(ScalaVersion other) {
        return !(this.major < other.major || this.major == other.major && this.minor < other.minor || this.major == other.major && this.minor == other.minor && this.bugfix < other.bugfix);
    }

    public boolean isAtLeast(String scalaVersion) {
        return this.isAtLeast(new ScalaVersion(scalaVersion));
    }

    public boolean isScala2() {
        return this.major == 2;
    }
}

