/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scoverage.domain.Constants;
import scoverage.domain.Coverage;
import scoverage.domain.Statement;
import scoverage.reporter.CoberturaXmlWriter;
import scoverage.reporter.IOUtils;
import scoverage.reporter.ScoverageHtmlWriter;
import scoverage.reporter.ScoverageXmlWriter;
import scoverage.serialize.Serializer;

@Mojo(name="report", threadSafe=false)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.TEST)
public class SCoverageReportMojo
extends AbstractMojo
implements MavenReport {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scoverage.aggregate", defaultValue="false")
    private boolean aggregate;
    @Parameter(property="scoverage.aggregateOnly", defaultValue="false")
    private boolean aggregateOnly;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="scoverage.failOnError", defaultValue="true", readonly=true)
    private boolean failOnError;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.outputDirectory", defaultValue="${project.reporting.outputDirectory}/scoverage", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(property="scoverage.xmlOutputDirectory", defaultValue="${project.build.directory}", required=true, readonly=true)
    private File xmlOutputDirectory;
    @Parameter(property="destDir", defaultValue="scoverage", required=true, readonly=true)
    private String destDir;
    @Parameter(property="name", readonly=true)
    private String name;
    @Parameter(property="description", readonly=true)
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.scoverage.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.scoverage.description");
        }
        return this.description;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        boolean canGenerateNonAggregatedReport = this.canGenerateNonAggregatedReport();
        boolean canGenerateAggregatedReport = this.canGenerateAggregatedReport();
        boolean canAttachAggregatedReportToSite = this.canAttachAggregatedReportToSite();
        if (canAttachAggregatedReportToSite && !canGenerateNonAggregatedReport && !canGenerateAggregatedReport) {
            return;
        }
        try {
            long ts = System.currentTimeMillis();
            if (canGenerateNonAggregatedReport) {
                this.generateReports();
            }
            if (canGenerateAggregatedReport) {
                this.generateAggregatedReports();
            }
            long te = System.currentTimeMillis();
            this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
        }
        catch (MavenReportException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)("Error while creating scoverage report: " + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw new MavenReportException("Report generation exception", (Exception)e);
            }
            this.getLog().error((CharSequence)("Error while creating scoverage report: " + e.getMessage()), (Throwable)e);
        }
    }

    public String getOutputName() {
        return this.getOutputPath();
    }

    public String getOutputPath() {
        return this.destDir + "/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean result;
        if (!this.skip && !"pom".equals(this.project.getPackaging())) {
            SCoverageForkedLifecycleConfigurator.afterForkedLifecycleExit(this.project, this.reactorProjects);
        }
        boolean canGenerateNonAggregatedReport = this.canGenerateNonAggregatedReport();
        boolean canAttachAggregatedReportToSite = this.canAttachAggregatedReportToSite();
        boolean bl = result = canGenerateNonAggregatedReport || canAttachAggregatedReportToSite;
        if (!result && this.canGenerateAggregatedReport()) {
            try {
                this.generateAggregatedReports();
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean canGenerateNonAggregatedReport() {
        if (this.skip) {
            return false;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return false;
        }
        if (this.aggregateOnly && this.reactorProjects.size() > 1) {
            return false;
        }
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        return coverageFile.exists() && coverageFile.isFile();
    }

    private boolean canGenerateAggregatedReport() {
        return (this.aggregate || this.aggregateOnly) && this.reactorProjects.size() > 1 && this.project == this.reactorProjects.get(this.reactorProjects.size() - 1);
    }

    private boolean canAttachAggregatedReportToSite() {
        return (this.aggregate || this.aggregateOnly) && this.reactorProjects.size() > 1 && this.project.isExecutionRoot();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && this.destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Skipping SCoverage report generation");
            return;
        }
        try {
            DocumentRenderingContext context = new DocumentRenderingContext(this.outputDirectory, this.getOutputName() + ".html", null);
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            String prefix = "An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation";
            throw new MojoExecutionException(prefix + ": " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scoverage-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void generateReports() throws MavenReportException {
        List sourceDirs = this.project.getExecutionProject().getCompileSourceRoots();
        ArrayList<File> sourceRoots = new ArrayList<File>(sourceDirs.size());
        for (String dir : sourceDirs) {
            sourceRoots.add(new File(dir));
        }
        this.mkdirs(this.outputDirectory);
        this.mkdirs(this.xmlOutputDirectory);
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        this.getLog().info((CharSequence)String.format("Reading scoverage instrumentation [%s]...", coverageFile.getAbsolutePath()));
        Coverage coverage = Serializer.deserialize((File)coverageFile, (File)this.executionRootDirectory());
        this.getLog().info((CharSequence)String.format("Reading scoverage measurements [%s*]...", new File(this.dataDirectory, Constants.MeasurementsPrefix()).getAbsolutePath()));
        List<File> measurementFiles = Arrays.asList(IOUtils.findMeasurementFiles((File)this.dataDirectory));
        Set measurements = IOUtils.invoked((Seq)CollectionConverters.asScala(measurementFiles).toSeq(), (String)this.encoding);
        coverage.apply((Iterable)measurements);
        this.getLog().info((CharSequence)"Generating coverage reports...");
        this.writeReports(coverage, sourceRoots, this.xmlOutputDirectory, this.xmlOutputDirectory, this.outputDirectory);
        this.getLog().info((CharSequence)"Coverage reports completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAggregatedReports() throws MavenReportException {
        Coverage coverage = new Coverage();
        AtomicInteger id = new AtomicInteger();
        ArrayList<File> scoverageDataDirs = new ArrayList<File>();
        ArrayList<File> sourceRoots = new ArrayList<File>();
        for (MavenProject module : this.reactorProjects) {
            File sourceRootsFile;
            File scoverageDataDir;
            if (module.getPackaging().equals("pom") || !(scoverageDataDir = this.rebase(this.dataDirectory, module.getBasedir())).isDirectory()) continue;
            scoverageDataDirs.add(scoverageDataDir);
            File coverageFile = Serializer.coverageFile((File)scoverageDataDir);
            if (coverageFile.exists()) {
                Coverage subCoverage = Serializer.deserialize((File)coverageFile, (File)this.executionRootDirectory());
                List<File> measurementFiles = Arrays.asList(IOUtils.findMeasurementFiles((File)scoverageDataDir));
                Set measurements = IOUtils.invoked((Seq)CollectionConverters.asScala(measurementFiles).toSeq(), (String)this.encoding);
                subCoverage.apply((Iterable)measurements);
                subCoverage.statements().foreach(statement -> {
                    int statementId = id.getAndIncrement();
                    Statement copy = statement.copy(statement.location(), statementId, statement.start(), statement.end(), statement.line(), statement.desc(), statement.symbolName(), statement.treeName(), statement.branch(), statement.count(), statement.ignored(), statement.tests());
                    coverage.add(copy);
                    return null;
                });
            }
            if (!(sourceRootsFile = new File(scoverageDataDir, "source.roots")).isFile()) continue;
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceRootsFile), "UTF-8"));){
                String path = r.readLine();
                while (path != null) {
                    sourceRoots.add(new File(path));
                    path = r.readLine();
                }
            }
            catch (IOException e) {
                throw new MavenReportException("...", (Exception)e);
            }
        }
        if (this.getLog().isDebugEnabled() && scoverageDataDirs.size() > 0) {
            this.getLog().debug((CharSequence)String.format("Found %d subproject subproject scoverage data directories:", scoverageDataDirs.size()));
            for (File dataDir : scoverageDataDirs) {
                this.getLog().debug((CharSequence)String.format("- %s", dataDir.getAbsolutePath()));
            }
        } else {
            this.getLog().info((CharSequence)String.format("Found %d subproject scoverage data directories.", scoverageDataDirs.size()));
        }
        File executionRootOutputDirectory = this.rebase(this.outputDirectory, this.executionRootDirectory());
        File executionRootXmlOutputDirectory = this.rebase(this.xmlOutputDirectory, this.executionRootDirectory());
        this.mkdirs(executionRootOutputDirectory);
        this.mkdirs(executionRootXmlOutputDirectory);
        this.getLog().info((CharSequence)"Generating coverage aggregated reports...");
        this.writeReports(coverage, sourceRoots, executionRootXmlOutputDirectory, executionRootXmlOutputDirectory, executionRootOutputDirectory);
        this.getLog().info((CharSequence)"Coverage aggregated reports completed.");
    }

    private void writeReports(Coverage coverage, List<File> sourceRoots, File coberturaXmlOutputDirectory, File scoverageXmlOutputDirectory, File scoverageHtmlOutputDirectory) {
        Seq sourceRootsAsScalaSeq = CollectionConverters.asScala(sourceRoots).toSeq();
        new CoberturaXmlWriter(sourceRootsAsScalaSeq, coberturaXmlOutputDirectory, Option.apply((Object)this.encoding)).write(coverage);
        this.getLog().info((CharSequence)String.format("Written Cobertura XML report [%s]", new File(coberturaXmlOutputDirectory, "cobertura.xml").getAbsolutePath()));
        new ScoverageXmlWriter(sourceRootsAsScalaSeq, scoverageXmlOutputDirectory, false, Option.apply((Object)this.encoding)).write(coverage);
        this.getLog().info((CharSequence)String.format("Written XML coverage report [%s]", new File(scoverageXmlOutputDirectory, "scoverage.xml").getAbsolutePath()));
        new ScoverageHtmlWriter(sourceRootsAsScalaSeq, scoverageHtmlOutputDirectory, Option.apply((Object)this.encoding)).write(coverage);
        this.getLog().info((CharSequence)String.format("Written HTML coverage report [%s]", new File(scoverageHtmlOutputDirectory, "index.html").getAbsolutePath()));
        this.getLog().info((CharSequence)String.format("Statement coverage.: %s%%", coverage.statementCoverageFormatted()));
        this.getLog().info((CharSequence)String.format("Branch coverage....: %s%%", coverage.branchCoverageFormatted()));
    }

    private void mkdirs(File directory) throws MavenReportException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MavenReportException(String.format("Cannot create \"%s\" directory ", directory.getAbsolutePath()));
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new MavenReportException(String.format("Directory \"%s\" exists but is not a directory ", directory.getAbsolutePath()));
        }
    }

    private File rebase(File file, File otherProjectDir) {
        return new File(file.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath(), otherProjectDir.getAbsolutePath()));
    }

    private File executionRootDirectory() {
        return new File(this.session.getExecutionRootDirectory());
    }
}

