/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.parser.antlr;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANTLRMessageUtil {
    private static final char END_LOCATION_SEPARATOR = ' ';
    private static final String LOCATION_PREFIX_TOKEN = "line ";

    public static String getMessageText(String mesg) {
        int index;
        String ret = mesg;
        if (mesg != null && mesg.startsWith(LOCATION_PREFIX_TOKEN) && (index = mesg.indexOf(32, LOCATION_PREFIX_TOKEN.length())) != -1) {
            ret = mesg.substring(index + 1);
        }
        return ret;
    }

    public static Map<String, Object> getProperties(String mesg, String document) {
        String lineDetails;
        String[] nums;
        int index;
        HashMap<String, Integer> ret = null;
        if (mesg != null && mesg.startsWith(LOCATION_PREFIX_TOKEN) && (index = mesg.indexOf(32, LOCATION_PREFIX_TOKEN.length())) != -1 && (nums = (lineDetails = mesg.substring(LOCATION_PREFIX_TOKEN.length(), index)).split(":")) != null && nums.length == 2) {
            ret = new HashMap<String, Integer>();
            Integer line = Integer.parseInt(nums[0]);
            Integer col = Integer.parseInt(nums[1]);
            ret.put("start.line", line);
            ret.put("start.column", col);
            int pos = 0;
            for (int i = 0; pos != -1 && i < line - 1; ++i) {
                if ((pos = document.indexOf("\r\n", pos)) == -1) continue;
                pos += 2;
            }
            if (pos != -1) {
                ret.put("position.start", new Integer(pos += col.intValue()));
                int endpos = document.length();
                int nextpos = -1;
                for (int j = pos + 1; nextpos == -1 && j < endpos; ++j) {
                    char ch = document.charAt(j);
                    if (!Character.isWhitespace(ch)) continue;
                    nextpos = j - 1;
                }
                if (nextpos == -1) {
                    nextpos = pos;
                }
                ret.put("position.end", new Integer(nextpos));
            }
        }
        return ret;
    }
}

