/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.BlockProjectorRule;
import org.scribble.protocol.projection.impl.CatchProjectorRule;
import org.scribble.protocol.projection.impl.ChoiceProjectorRule;
import org.scribble.protocol.projection.impl.DataTypeProjectorRule;
import org.scribble.protocol.projection.impl.IncludeProjectorRule;
import org.scribble.protocol.projection.impl.InteractionProjectorRule;
import org.scribble.protocol.projection.impl.MessageSignatureProjectorRule;
import org.scribble.protocol.projection.impl.OptionalProjectorRule;
import org.scribble.protocol.projection.impl.ParallelProjectorRule;
import org.scribble.protocol.projection.impl.ParameterProjectorRule;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolImportListProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolImportProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolModelProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolReferenceProjectorRule;
import org.scribble.protocol.projection.impl.RaiseProjectorRule;
import org.scribble.protocol.projection.impl.RecBlockProjectorRule;
import org.scribble.protocol.projection.impl.RecursionProjectorRule;
import org.scribble.protocol.projection.impl.RepeatProjectorRule;
import org.scribble.protocol.projection.impl.RoleListProjectorRule;
import org.scribble.protocol.projection.impl.RoleProjectorRule;
import org.scribble.protocol.projection.impl.RunProjectorRule;
import org.scribble.protocol.projection.impl.Scope;
import org.scribble.protocol.projection.impl.TryProjectorRule;
import org.scribble.protocol.projection.impl.TypeImportListProjectorRule;
import org.scribble.protocol.projection.impl.TypeImportProjectorRule;
import org.scribble.protocol.projection.impl.TypeReferenceProjectorRule;
import org.scribble.protocol.projection.impl.UnorderedProjectorRule;
import org.scribble.protocol.projection.impl.WhenProjectorRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectorContext
implements ProjectorContext {
    private static Logger logger = Logger.getLogger(DefaultProjectorContext.class.getName());
    private ProtocolContext m_context = null;
    private static List<ProjectorRule> m_rules = new Vector<ProjectorRule>();
    private Scope m_scope = new Scope();
    private List<Scope> m_scopeStack = new Vector<Scope>();
    private Map<Protocol, List<Role>> m_definitionRoleMap = new HashMap<Protocol, List<Role>>();

    public DefaultProjectorContext(ProtocolContext context) {
        this.m_context = context;
    }

    @Override
    public ProtocolContext getProtocolContext() {
        return this.m_context;
    }

    @Override
    public ModelObject project(ModelObject model, Role role, Journal l) {
        ModelObject ret = null;
        for (int i = 0; model != null && ret == null && i < this.getRules().size(); ++i) {
            if (!this.getRules().get(i).isSupported(model)) continue;
            ret = this.getRules().get(i).project(this, model, role, l);
        }
        return ret;
    }

    public List<ProjectorRule> getRules() {
        return m_rules;
    }

    @Override
    public Object getState(String name) {
        return this.m_scope.getState(name);
    }

    @Override
    public void setState(String name, Object value) {
        this.m_scope.setState(name, value);
    }

    @Override
    public void pushState() {
        this.m_scope.pushState();
    }

    @Override
    public void popState() {
        this.m_scope.popState();
    }

    @Override
    public void pushScope() {
        this.m_scopeStack.add(0, this.m_scope);
        this.m_scope = new Scope();
    }

    @Override
    public void popScope() {
        if (this.m_scopeStack.size() > 0) {
            this.m_scope = this.m_scopeStack.remove(0);
        } else {
            logger.severe("No state entry to pop from stack");
        }
    }

    @Override
    public boolean isOuterScope() {
        return this.m_scopeStack.size() < 1;
    }

    @Override
    public void registerInterest(Protocol defn, Role role) {
        List<Role> roles = this.m_definitionRoleMap.get(defn);
        if (roles == null) {
            roles = new Vector<Role>();
            this.m_definitionRoleMap.put(defn, roles);
        }
        if (!roles.contains(role)) {
            roles.add(role);
        }
    }

    @Override
    public List<Role> getRolesOfInterestForDefinition(Protocol defn) {
        return this.m_definitionRoleMap.get(defn);
    }

    static {
        m_rules.add(new BlockProjectorRule());
        m_rules.add(new CatchProjectorRule());
        m_rules.add(new ChoiceProjectorRule());
        m_rules.add(new ProtocolImportListProjectorRule());
        m_rules.add(new ProtocolImportProjectorRule());
        m_rules.add(new TypeImportListProjectorRule());
        m_rules.add(new TypeImportProjectorRule());
        m_rules.add(new InteractionProjectorRule());
        m_rules.add(new MessageSignatureProjectorRule());
        m_rules.add(new OptionalProjectorRule());
        m_rules.add(new ParallelProjectorRule());
        m_rules.add(new RoleListProjectorRule());
        m_rules.add(new RoleProjectorRule());
        m_rules.add(new ProtocolModelProjectorRule());
        m_rules.add(new ProtocolProjectorRule());
        m_rules.add(new ParameterProjectorRule());
        m_rules.add(new ProtocolReferenceProjectorRule());
        m_rules.add(new RaiseProjectorRule());
        m_rules.add(new RepeatProjectorRule());
        m_rules.add(new RecBlockProjectorRule());
        m_rules.add(new RecursionProjectorRule());
        m_rules.add(new RunProjectorRule());
        m_rules.add(new IncludeProjectorRule());
        m_rules.add(new TryProjectorRule());
        m_rules.add(new DataTypeProjectorRule());
        m_rules.add(new TypeReferenceProjectorRule());
        m_rules.add(new WhenProjectorRule());
        m_rules.add(new UnorderedProjectorRule());
    }
}

