/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.projection.impl.DefaultProjectorContext;

public class ProtocolProjectorImpl
implements ProtocolProjector {
    public ProtocolModel project(ProtocolModel model, Role role, Journal journal, ProtocolContext context) {
        ProtocolModel ret = null;
        if (model == null || role == null) {
            throw new IllegalArgumentException("Model and/or role has not bee specified");
        }
        List roles = model.getRoles();
        int index = roles.indexOf(role);
        if (index == -1) {
            throw new IllegalArgumentException("Role '" + role.getName() + "' is not defined within the protocol model");
        }
        DefaultProjectorContext projectorContext = new DefaultProjectorContext(context);
        role = (Role)roles.get(index);
        ModelObject obj = projectorContext.project((ModelObject)model, role, journal);
        if (obj != null) {
            if (obj instanceof ProtocolModel) {
                ret = (ProtocolModel)obj;
            } else {
                String modelName = model.getProtocol().getName();
                if (model.getProtocol().getRole() != null) {
                    modelName = modelName + "," + model.getProtocol().getRole();
                }
                journal.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.Messages").getString("_NOT_PROJECTED_MODEL"), modelName), null);
            }
        }
        return ret;
    }
}

